#!/bin/bash
###############################################################################
# Author        : onlyshenmin
# Created Time  : 2019-05-29 15:10:38
# Last Modified : 2020-03-13 13:46:46
# File Name     : install.sh
# Description   : install ansible 2.8.0
###############################################################################
# color/title setting
set +e
set -o noglob
bold=$(tput bold)
underline=$(tput sgr 0 1)
reset=$(tput sgr0)
red=$(tput setaf 1)
green=$(tput setaf 2)
yellow=$(tput setaf 3)
blue=$(tput setaf 4)
magenta=$(tput setaf 5)
cyan=$(tput setaf 6)
white=$(tput setaf 7)
underline() {
    printf "${underline}${bold}%s${reset}\n" "$@"
}
h1() {
    printf "\n${underline}${bold}${cyan}%s${reset}\n" "$@"
}
h2() {
    printf "\n${underline}${bold}${white}%s${reset}\n" "$@"
}
debug() {
    printf "${white}%s${reset}\n" "$@"
}
info() {
    printf "${white}-> %s${reset}\n" "$@"
}
success() {
    printf "${bold}${green}✔ %s${reset}\n" "$@"
}
error() {
    printf "${red}✖ %s${reset}\n" "$@"
}
warn() {
    printf "${yellow}%s${reset}\n" "$@"
}
bold() {
    printf "${bold}%s${reset}\n" "$@"
}
note() {
    printf "\n${underline}${bold}${blue}Note:${reset} ${blue}%s${reset}\n" "$@"
}
countdown() {
    printf "${yellow}%s${reset}" "$@"
}
set -e
set +o noglob
item=1
###############################################################################
# 获取当前目录
work_dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
packages_dir="${work_dir}/packages"

# 定义通用软件列表
software_list=(
    ansible
    python2-pip
    rsync
)

# 检查输入是否为 yes 或 no
check_input_yes_no() {
    read choice
    if [[ $choice != "yes" && $choice != "no" ]]; then
        error "必须输入 yes 或者 no, 请重新输入："
        check_input_yes_no
    fi
}

# 禁用 firewalld
disable_firewalld() {
    h1 "[Step ${item}]: 禁用防火墙 ..."
    let item+=1
    systemctl stop firewalld
    systemctl disable firewalld
}

# 禁用 selinux
disable_selinux() {
    h1 "[Step ${item}]: 禁用selinux ..."
    let item+=1
    if [ "$(getenforce)" != "Disabled" ]; then
        selinux_flag="true"
        setenforce 0
        sed -i "s/^SELINUX=.*$/SELINUX=disabled/g" /etc/selinux/config
        h1 "[Step ${item}]: 要彻底禁用selinux需要重启服务器，重启后请重新运行安装脚本，是否重启？ (yes/no)"
        check_input_yes_no
        if [ "$choice" == "yes" ]; then
            for i in $(seq 9 | tac); do
                countdown "服务器将在 ${i} 秒后重启 ......"
                sleep 1
                # 清除本行文字 \r 用后面的字符串取代掉最前面的字符串
                echo -ne "\r \r"
            done
            reboot
        fi
    fi
}

# 通过 yum 安装 rpm 格式的软件包
install_software_rpm() {
    cd ${work_dir}
    h1 "[Step ${item}]: 创建通用软件的安装源 ..."
    let item+=1
    if [ $(ls /etc/yum.repos.d/*.repo 2>/dev/null | wc -l) != 0 ]; then
        mkdir /etc/yum.repos.d/tmp -p
        mv /etc/yum.repos.d/*.repo /etc/yum.repos.d/tmp/ -f
    fi
    cat >/etc/yum.repos.d/software.repo <<EOF
[software]
name=software
baseurl=file://${packages_dir}
enabled=1
gpgcheck=0
EOF
    yum clean all
    rm -rf /var/cache/yum
    yum makecache

    h1 "[Step ${item}]: 安装通用软件  ..."
    let item+=1
    yum install "${software_list[@]}" -y

    h1 "[Step ${item}]: 清理通用软件的安装源 ..."
    let item+=1
    yum clean all
    rm -rf /var/cache/yum
    rm /etc/yum.repos.d/software.repo -rf
    if [ -d /etc/yum.repos.d/tmp ]; then
        mv /etc/yum.repos.d/tmp/*.repo /etc/yum.repos.d/ -f
        rm /etc/yum.repos.d/tmp/ -rf
    fi
}

# 通过pip安装软件
install_pip_software() {
    cd ${work_dir}
    pip install --no-index --find-links="./docker-4.2.0-py2.py3-none-any" docker
}

# 直接安装二进制软件
install_software_binary() {
    cd ${work_dir}
    h1 "[Step ${item}]: 安装  ..."
    let item+=1
}

# 验证软件安装是否成功
verify_software_installed() {
    h1 "[Step ${item}]: 验证软件安装  ..."
    let item+=1
    if ansible --version; then
        echo ""
        success "ansible 安装成功 ！"
    else
        echo ""
        error "ansible 安装失败 !!!"
        exit 1
    fi
}

main() {
    disable_firewalld
    disable_selinux
    install_software_rpm
    # install_software_binary
    install_pip_software
    verify_software_installed
}

main
