#!/bin/bash
###############################################################################
# Author        : onlyshenmin
# Created Time  : 2018-12-13 16:26:09
# Last Modified : 2018-12-18 11:26:21
# File Name     : update.sh
# Description   : update
###############################################################################
set -e
###############################################################################
# 变量设置
workdir=$(readlink -f "$(dirname "$0")")
project="eppv5"
reg_fqdn="reg.citms.cn"
reg_url="${reg_fqdn}:7443"
reg_username="admin"
reg_password="citms@123"
ansible_inventory="inventory.ini"
api_status=$(curl -o /dev/null -s -w "%{http_code}\n" -u admin:citms@123 https://reg.citms.cn:7443/api/v2.0/projects)
###############################################################################
# 配置 SSH 信任关系
passwordless_login() {
    clear
    if ! [ -f /root/.ssh/id_rsa ]; then
        ssh-keygen -t rsa -N '' -f /root/.ssh/id_rsa
    fi
    cd ${workdir}
    local password=""
    title_box="配置 SSH 无密码登录"
    password_box="请输入被控端服务器密码："
    password=$(whiptail --title "${title_box}" --passwordbox "${password_box}" 8 78 3>&1 1>&2 2>&3)
    sed -i "s/^ansible_ssh_pass=.*$/ansible_ssh_pass=\"${password}\"/g" ./inventory.ini
    ansible-playbook passwordless-login.yml
    sed -i "s/^ansible_ssh_pass=.*$/ansible_ssh_pass=\"\"/g" ./inventory.ini
}

# 系统初始化
system_initialization() {
    cd ${workdir}
    ansible-playbook system-initialization.yml
}

# 获取微服务对应仓库目录 参数一：服务名称 如smw 参数二：setup.sh 文件中的project变量
get_microserveice_repo() {
    #读取repo.ini 服务：仓库配置文件
    compareRule="0"
    for line in $(cat repo.ini)
    do
        #去空格
        rule=$(echo "${line}" | sed "s/ /,/g")
        #排除以#开头的注释语句
        if [ ${rule:0:1} != "#" ]; then
            #通过:分割字符串
            array=(${rule//:/ }) 
            if  [ ${array[0]} == $1  ]; then
                echo ${array[1]}
                compareRule="1"
                break
            fi
        fi
    done
    if [ $compareRule == "0" ]; then
        echo $2
    fi
}


###############################################################################
# 安装注册中心服务器
install_consul_servers() {
    cd ${workdir}
    ansible-playbook install-consul-servers.yml
}
# 卸载注册中心服务器
uninstall_consul_servers() {
    cd ${workdir}
    ansible-playbook uninstall-consul-servers.yml
}

# 安装注册中心客户端
install_consul_clients() {
    cd ${workdir}
    ansible-playbook install-consul-clients.yml
}
# 卸载注册中心客户端
uninstall_consul_clients() {
    cd ${workdir}
    ansible-playbook uninstall-consul-clients.yml
}

###############################################################################
# 选择微服务，多选，用于批量安装、更新、卸载
checklist_microservice() {
    title_box="Microservice list"
    checklist_box="选择微服务，使用空格键选定"
    checklist_options=(
        ctw "在线接口服务" off
        ufnginx "    统一入口代理服务" off
        aif "    应用集成框架" off
      	mcm "    MCM消息中心微服务" off  
	eipsw "    企业积分系统" off
        eipsa " 创新券积分app " off
        ivsw "    创新券系统" off
  	cbsdw "    企业银行服务对接" off
	common "    C#的公共库" off
        smw "    系统管理Web微服务" off
        licensew "license授权服务" off
    )
    choices=($(
        whiptail \
            --fullbuttons \
            --separate-output \
            --title "${title_box}" \
            --checklist "${checklist_box}" 0 0 0 \
            "${checklist_options[@]}" \
            3>&1 1>&2 2>&3
    ))
    microserveice_choosed=("${choices[@]}")
}
# 安装微服务的默认版本
install_microservice_latest() {
	cd ${workdir}
    for microservice_name in "${microserveice_choosed[@]}"; do
		project=$(get_microserveice_repo "${microservice_name}" "${project}")
        if [ ${api_status} != "200" ];then
            microservice_version=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/repositories/${project}/${microservice_name}/tags | grep '^    "name": ' | grep -v latest | sort -r | head -n 1 | awk -F\" '{print $4}')
        else
            microservice_version=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/v2.0/projects/${project}/repositories/${microservice_name}/artifacts |jq '.[].tags[].name' | grep -v latest |awk -F "\"" '{print $2}'| sort -r | head -n 1)
        fi
        sed -i "s/^${microservice_name}_version=.*$/${microservice_name}_version=\"${microservice_version}\"/g" ${ansible_inventory}
		echo ansible-playbook -t ${microservice_name} install-microservice.yml  -e reg_repo="${project}"
		ansible-playbook -t ${microservice_name} install-microservice.yml -e reg_repo="${project}"
    done  
}

# 更新微服务到最新版本
update_microservice_latest() {
	cd ${workdir}
    for microservice_name in "${microserveice_choosed[@]}"; do
		project=$(get_microserveice_repo "${microservice_name}" "${project}")
        if [ ${api_status} != "200" ];then
            microservice_version=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/repositories/${project}/${microservice_name}/tags | grep '^    "name": ' | grep -v latest | sort -r | head -n 1 | awk -F\" '{print $4}')
        else
            microservice_version=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/v2.0/projects/${project}/repositories/${microservice_name}/artifacts |jq '.[].tags[].name' | grep -v latest |awk -F "\"" '{print $2}'| sort -r | head -n 1)
        fi
        sed -i "s/^${microservice_name}_version=.*$/${microservice_name}_version=\"${microservice_version}\"/g" ${ansible_inventory}
		echo ansible-playbook -t ${microservice_name} update-microservice.yml  -e reg_repo="${project}"  
		ansible-playbook -t ${microservice_name} update-microservice.yml  -e reg_repo="${project}"
    done
}

# 卸载微服务
uninstall_microservice() {
    microserveice_choosed_tags=$(echo "${microserveice_choosed[@]}" | sed "s/ /,/g")
    cd ${workdir}
    ansible-playbook -t ${microserveice_choosed_tags} uninstall-microservice.yml
}

###############################################################################
# 选择微服务，单选，用于更新
menu_microservice() {
    local title_box="Microservice Menu"
    local menu_box="选择需要更新的微服务："
    local menu_options=(
        ctw     "在线接口服务"
        ufnginx "    统一入口代理服务" 
        aif "    应用集成框架" 
	mcm "    MCM消息中心微服务"  
       eipsw "    企业积分系统" 
        ivsw "    创新券系统" 
        eipsa " 创新券积分app " 
  	cbsdw "    企业银行服务对接" 
	common "    C#的公共库" 
        smw "    系统管理Web微服务"
        licensew "license授权服务"
    )
    local choice
    choice=$(
        whiptail \
            --fullbuttons \
            --separate-output \
            --title "${title_box}" \
            --menu "${menu_box}" 0 0 0 \
            "${menu_options[@]}" \
            3>&1 1>&2 2>&3
    )
    microservice_name="${choice}"
}
# 选择微服务版本
menu_version() {
    project=$(get_microserveice_repo "${microservice_name}" "${project}")
    if [ ${api_status} != "200"  ];then
        version_list=($(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/repositories/${project}/${microservice_name}/tags | grep '^    "name": ' | sort -r | head -n 200 | awk -F\" '{print $4}'))
        version_menu_list=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/repositories/${project}/${microservice_name}/tags | grep '^    "name": ' | sort -r | head -n 200 | awk -F\" '{print NR" "$4}')
    else
        version_list=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/v2.0/projects/${project}/repositories/${microservice_name}/artifacts |jq '.[].tags[].name' |awk -F "\"" '{print $2}'| sort -r | head -n 200)
        version_menu_list=$(curl -s -u ${reg_username}:${reg_password} -X GET -H Content-Type:application/json https://${reg_url}/api/v2.0/projects/${project}/repositories/${microservice_name}/artifacts |jq '.[].tags[].name' |awk -F "\"" '{print $2}'| sort -r | head -n 200)
    fi
    local title_box="version Menu"
    local menu_box="选择微服务版本："
    local menu_options=(${version_menu_list})
    local choice
    choice=$(whiptail \
        --fullbuttons \
        --separate-output \
        --title "${title_box}" \
        --menu "${menu_box}" 0 0 0 \
        "${menu_options[@]}" \
        3>&1 1>&2 2>&3)
    microservice_version=${version_list[${choice} - 1]}
}

# 更新微服务到指定版本
update_microservice_specified() {
    sed -i "s/^${microservice_name}_version=.*$/${microservice_name}_version=\"${microservice_version}\"/g" ${ansible_inventory}
    cd ${workdir}
    project=$(get_microserveice_repo "${microservice_name}" "${project}")
    ansible-playbook -t ${microservice_name} update-microservice.yml  -e reg_repo="${project}"
}

###############################################################################
# 主菜单，选择初始化、安装、卸载、更新
main() {
    local title_box="Operation menu"
    local menu_box="选择对应的操作："
    local menu_options=(
        "Passwordless login" "    无密码登录"
        "System initialization" "    系统初始化"
        "Install consul servers" "    安装注册服务器"
        "Uninstall consul servers" "    卸载注册服务器"
        "Install consul clients" "    安装注册客户端"
        "Uninstall consul clients" "    卸载注册客户端"
        "Install microservice" "    安装微服务的最新版本"
        "Update microservice to latest" "    更新微服务到最新版本"
        "Update microservice to specified" "    更新微服务到指定版本"
        "Uninstall microservice" "    卸载微服务"
    )
    local choice
    choice=$(
        whiptail \
            --fullbuttons \
            --separate-output \
            --title "${title_box}" \
            --menu "${menu_box}" 0 0 0 \
            "${menu_options[@]}" \
            3>&1 1>&2 2>&3
    )
    operation=${choice}
    if [ "${operation}" == "Passwordless login" ]; then
        passwordless_login
    elif [ "${operation}" == "System initialization" ]; then
        system_initialization
    elif [ "${operation}" == "Install consul servers" ]; then
        install_consul_servers
    elif [ "${operation}" == "Uninstall consul servers" ]; then
        uninstall_consul_servers
    elif [ "${operation}" == "Install consul clients" ]; then
        install_consul_clients
    elif [ "${operation}" == "Uninstall consul clients" ]; then
        uninstall_consul_clients
    elif [ "${operation}" == "Install microservice" ]; then
        checklist_microservice
        install_microservice_latest
    elif [ "${operation}" == "Update microservice to latest" ]; then
        checklist_microservice
        update_microservice_latest
    elif [ "${operation}" == "Update microservice to specified" ]; then
        menu_microservice
        menu_version
        update_microservice_specified
    elif [ "${operation}" == "Uninstall microservice" ]; then
        checklist_microservice
        uninstall_microservice
    else
        main
    fi
}

###############################################################################
# 执行主函数
main
