#!/bin/bash
###############################################################################
# Author        : onlyshenmin
# Created Time  : 2019-05-28 16:26:09
# Last Modified : 2019-05-29 10:04:53
# File Name     : add-microservice.sh
# Description   : add microservice
###############################################################################
workdir=$(readlink -f "$(dirname "$0")")

get_microservice_number() {
    local title_box="Input microservice number"
    local input_box
    input_box="请输入微服务的编号："
    while true; do
        microservice_number=$(whiptail --title "${title_box}" --inputbox "${input_box}" 0 78 3>&1 1>&2 2>&3)
        [ $? != 0 ] && exit
        echo ${microservice_number} | grep -E "^[0-9]{3}$" >/dev/null
        if [ $? != 0 ]; then
            whiptail --title "Error" --msgbox "编号不符合要求，请重新输入。" 0 0
            continue
        fi
        break
    done
}

get_microservice_name() {
    local title_box="Input microservice name"
    local input_box
    input_box="请输入微服务的名称："
    while true; do
        microservice_name=$(whiptail --title "${title_box}" --inputbox "${input_box}" 0 78 3>&1 1>&2 2>&3)
        [ $? != 0 ] && exit
        [ -z ${microservice_name} ] && continue
        break
    done
}

get_microservice_type() {
    local type_list=(
        "java" "        java微服务"
        "dotnet core" "        dotnet core微服务"
    )
    local title_box="Select microservice type"
    local menu_box="选择微服务的类型："
    local menu_options=("${type_list[@]}")
    local choice
    microservice_type=$(
        whiptail \
            --fullbuttons \
            --separate-output \
            --title "${title_box}" \
            --menu "${menu_box}" 0 0 0 \
            "${menu_options[@]}" \
            3>&1 1>&2 2>&3
    )
}

get_microservice_port() {
    local title_box="Input microservice port: "
    local input_box
    input_box="请输入${microservice_name}的端口，如有多个端口，使用','隔开: "
    while true; do
        microservice_port=$(whiptail --title "${title_box}" --inputbox "${input_box}" 0 78 3>&1 1>&2 2>&3)
        [ $? != 0 ] && exit
        for port in $(echo ${microservice_port} | tr ',' ' '); do
            if [ ${port} -le 65535 ] && [ ${port} -ge 1 ]; then
                port_flag=true
            else
                port_flag=false
                break
            fi
        done
        if [ ${port_flag} = "false" ]; then
            whiptail --title "Error" --msgbox "端口不符合要求，请重新输入。" 0 0
            continue
        fi
        break
    done
    microservice_port="[\"$(echo ${microservice_port} | sed s/,/\",\"/g)\"]"
}

get_server_ip() {
    local title_box="Input server ip: "
    local input_box
    input_box="请输入安装${microservice_name}的服务器的IP地址，如有多个IP地址，使用','隔开: "
    while true; do
        server_ips=$(whiptail --title "${title_box}" --inputbox "${input_box}" 0 78 3>&1 1>&2 2>&3)
        [ $? != 0 ] && exit
        for ip in $(echo ${server_ips} | tr ',' ' '); do
            echo ${ip} | grep -E "^([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$" >/dev/null
            if [ $? == 0 ]; then
                ip_flag=true
            else
                ip_flag=false
                break
            fi
        done
        if [ ${ip_flag} = "false" ]; then
            whiptail --title "Error" --msgbox "IP地址不符合要求，请重新输入。" 0 0
            continue
        fi
        break
    done
    server_ips="$(echo ${server_ips} | sed 's/,/ /g')"
}

get_microservice_appname() {
    local title_box="Input microservice appname"
    local input_box
    input_box="请输入微服务的中文名："
    while true; do
        microservice_appname=$(whiptail --title "${title_box}" --inputbox "${input_box}" 0 78 3>&1 1>&2 2>&3)
        [ $? != 0 ] && exit
        [ -z ${microservice_appname} ] && continue
        break
    done
}

create_role() {
    if [ "${microservice_type}" = "java" ]; then
        cp -a ${workdir}/roles/role-templates/template-java ${workdir}/roles/${microservice_number}-${microservice_name}
        cp -a ${workdir}/roles/role-templates/template-java-uninstall ${workdir}/roles/uninstall-${microservice_number}-${microservice_name}
        cp -a ${workdir}/roles/role-templates/template-java-update ${workdir}/roles/update-${microservice_number}-${microservice_name}

        sed -i "s/t_appname/${microservice_appname}/g" \
            ${workdir}/roles/${microservice_number}-${microservice_name}/templates/bootstrap.yml.j2
    else
        cp -a ${workdir}/roles/role-templates/template-dotnet ${workdir}/roles/${microservice_number}-${microservice_name}
        cp -a ${workdir}/roles/role-templates/template-dotnet-uninstall ${workdir}/roles/uninstall-${microservice_number}-${microservice_name}
        cp -a ${workdir}/roles/role-templates/template-dotnet-update ${workdir}/roles/update-${microservice_number}-${microservice_name}
    fi
    sed -i "s/t_name/${microservice_name}/g" \
        ${workdir}/roles/${microservice_number}-${microservice_name}/defaults/main.yml \
        ${workdir}/roles/uninstall-${microservice_number}-${microservice_name}/defaults/main.yml \
        ${workdir}/roles/update-${microservice_number}-${microservice_name}/defaults/main.yml
}

modify_install_yml() {
    cat >>${workdir}/install-microservice.yml <<EOF

- name: Install ${microservice_name}_servers
  hosts: ${microservice_name}_servers
  remote_user: root
  roles:
    - role: ${microservice_number}-${microservice_name}
      tags: ${microservice_name}
EOF
}
#
modify_uninstall_yml() {
    cat >>${workdir}/uninstall-microservice.yml <<EOF

- name: Unstall ${microservice_name}_servers
  hosts: ${microservice_name}_servers
  remote_user: root
  roles:
    - role: uninstall-${microservice_number}-${microservice_name}
      tags: ${microservice_name}
EOF
}

modify_update_yml() {
    cat >>${workdir}/update-microservice.yml <<EOF

- name: Update ${microservice_name}_servers
  hosts: ${microservice_name}_servers
  remote_user: root
  roles:
    - role: update-${microservice_number}-${microservice_name}
      tags: ${microservice_name}
EOF
}

modify_inventory() {
    echo "# 计划安装 ${microservice_name} server 的服务器组" >/tmp/addserver.tmp
    echo "[${microservice_name}_servers]" >>/tmp/addserver.tmp
    for server_ip in ${server_ips}; do
        echo ${server_ip} >>/tmp/addserver.tmp
    done
    echo "" >>/tmp/addserver.tmp
    sed -i "/^#server_group$/r /tmp/addserver.tmp" inventory.ini
    rm -rf /tmp/addserver.tmp
    sed -i "/^#consul_client$/a\\${microservice_name}_servers" inventory.ini
    sed -i "/^#microservice_port$/a\\${microservice_name}_port=${microservice_port}" inventory.ini
    sed -i "/^#microservice_version$/a\\${microservice_name}_version="latest"" inventory.ini
}

main() {
    get_microservice_number
    #echo ${microservice_number}
    get_microservice_type
    #echo ${microservice_type}
    get_microservice_name
    #echo ${microservice_name}
    get_microservice_port
    #echo ${microservice_port}
    get_server_ip
    #echo ${server_ips}
    get_microservice_appname
    #echo ${microservice_appname}
    create_role
    modify_install_yml
    modify_uninstall_yml
    modify_update_yml
    modify_inventory
}

main
