/*
 Navicat Premium Data Transfer

 Source Server         : 192.168.0.132
 Source Server Type    : MySQL
 Source Server Version : 100508
 Source Host           : 192.168.0.132:3306
 Source Schema         : eppv5

 Target Server Type    : MySQL
 Target Server Version : 100508
 File Encoding         : 65001

 Date: 08/10/2022 16:17:42
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for common_attachment
-- ----------------------------
DROP TABLE IF EXISTS `common_attachment`;
CREATE TABLE IF NOT EXISTS `common_attachment`  (
  `ATTACHMENTID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '附件ID，主键',
  `NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '附件名称',
  `URL` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '附件URL',
  `EXTENSON` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '后缀名',
  `SOURCEID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关联表主键',
  `FILESIZE` decimal(12, 2) NULL DEFAULT NULL COMMENT '文件大小(M)',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`ATTACHMENTID`) USING BTREE,
  INDEX `ATTACHMENT_SOURCEID_TIME`(`SOURCEID`, `CREATEDTIME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '附件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of common_attachment
-- ----------------------------

-- ----------------------------
-- Table structure for common_dictionary
-- ----------------------------
DROP TABLE IF EXISTS `common_dictionary`;
CREATE TABLE IF NOT EXISTS `common_dictionary`  (
  `DICTIONARYID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典id',
  `KIND` decimal(8, 0) NOT NULL COMMENT '字典类型',
  `DICTIONARYNO` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典编号',
  `DICTIONARYVALUE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典值',
  `PARENTID` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级id',
  `SORTNO` decimal(4, 0) NULL DEFAULT NULL COMMENT '当前层级排序值',
  `SHOWORDER` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '显示顺序 用于树形和列表排序用',
  `HIERARCHYCODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '层级代码 树形结构时 用于搜索',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `ISSYSTEM` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否系统级数据 默认为 0否 1:是',
  `BOPOMOFO` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拼音',
  `DESCRIPTION` varchar(4000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`DICTIONARYID`) USING BTREE,
  UNIQUE INDEX `IX_KIND_DICTIONARYNO`(`KIND`, `DICTIONARYNO`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '字典表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of common_dictionary
-- ----------------------------
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP5T1H1XTUQ46F7', 200001, '1', '股份有限公司(非上市、自然人投资或控股)', NULL, 1, '0001', '', '', 0, 'GUFENYOUXIANGONGSI(FEISHANGSHI、ZIRANRENTOUZIHUOKONGGU) GFYXGS(FSS、ZRRTZHKG)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP6PN51XTU1URDY', 200001, '2', '股份有限公司(非上市、外商投资企业投资)', NULL, 3, '0003', '', '', 0, 'GUFENYOUXIANGONGSI(FEISHANGSHI、WAISHANGTOUZIQIYETOUZI) GFYXGS(FSS、WSTZQYTZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP72MO1XTU3QQJG', 200001, '3', '股份有限公司(非上市、国有控股)', NULL, 5, '0005', '', '', 0, 'GUFENYOUXIANGONGSI(FEISHANGSHI、GUOYOUKONGGU) GFYXGS(FSS、GYKG)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP7D201XTUWVOTM', 200001, '4', '股份有限公司(港澳台投资、未上市)', NULL, 7, '0007', '', '', 0, 'GUFENYOUXIANGONGSI(GANGAOTAITOUZI、WEISHANGSHI) GFYXGS(GATTZ、WSS)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP7OTE1XTUGNRYI', 200001, '5', '股份有限公司(港澳台投资、上市)', NULL, 9, '0009', '', '', 0, 'GUFENYOUXIANGONGSI(GANGAOTAITOUZI、SHANGSHI) GFYXGS(GATTZ、SS)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP7ZXH1XTUQ33OQ', 200001, '6', '股份有限公司(外商投资、未上市)', NULL, 11, '0011', '', '', 0, 'GUFENYOUXIANGONGSI(WAISHANGTOUZI、WEISHANGSHI) GFYXGS(WSTZ、WSS)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP8A5Z1XTUIVWLH', 200001, '7', '股份有限公司(台港澳与境内合资、未上市)', NULL, 13, '0013', '', '', 0, 'GUFENYOUXIANGONGSI(TAIGANGAOYUJINGNEIHEZI、WEISHANGSHI) GFYXGS(TGAYJNHZ、WSS)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP8KS51XTURNP6G', 200001, '8', '股份有限公司(中外合资、未上市)', NULL, 15, '0015', '', '', 0, 'GUFENYOUXIANGONGSI(ZHONGWAIHEZI、WEISHANGSHI) GFYXGS(ZWHZ、WSS)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP8V7A1XTU025VM', 200001, '9', '股份有限公司(上市、自然人投资或控股)', NULL, 17, '0017', '', '', 0, 'GUFENYOUXIANGONGSI(SHANGSHI、ZIRANRENTOUZIHUOKONGGU) GFYXGS(SS、ZRRTZHKG)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP96D21XTUUEDZM', 200001, '10', '有限责任公司（非自然人投资或控股的法人独资）', NULL, 19, '0019', '', '', 0, 'YOUXIANZERENGONGSI（FEIZIRANRENTOUZIHUOKONGGUDEFARENDUZI） YXZRGS（FZRRTZHKGDFRDZ）', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP9GOI1XTUQ5I1O', 200001, '11', '有限责任公司（自然人投资或控股的法人独资）', NULL, 21, '0021', '', '', 0, 'YOUXIANZERENGONGSI（ZIRANRENTOUZIHUOKONGGUDEFARENDUZI） YXZRGS（ZRRTZHKGDFRDZ）', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MP9TG91XTUCDTZ5', 200001, '12', '有限责任公司(自然人独资)', NULL, 23, '0023', '', '', 0, 'YOUXIANZERENGONGSI(ZIRANRENDUZI) YXZRGS(ZRRDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPA8XW1XTUQC9AU', 200001, '13', '有限责任公司(自然人投资或控股)', NULL, 25, '0025', '', '', 0, 'YOUXIANZERENGONGSI(ZIRANRENTOUZIHUOKONGGU) YXZRGS(ZRRTZHKG)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPAK7J1XTUR4Y24', 200001, '14', '有限责任公司(港澳台法人独资)', NULL, 27, '0027', '', '', 0, 'YOUXIANZERENGONGSI(GANGAOTAIFARENDUZI) YXZRGS(GATFRDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPAUWZ1XTUDUV6C', 200001, '15', '有限责任公司(港澳台投资、非独资)', NULL, 29, '0029', '', '', 0, 'YOUXIANZERENGONGSI(GANGAOTAITOUZI、FEIDUZI) YXZRGS(GATTZ、FDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPB7NL1XTUKJ058', 200001, '16', '有限责任公司(外国自然人独资)', NULL, 31, '0031', '', '', 0, 'YOUXIANZERENGONGSI(WAIGUOZIRANRENDUZI) YXZRGS(WGZRRDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPBLO61XTUJL437', 200001, '17', '有限责任公司(外国法人独资)', NULL, 33, '0033', '', '', 0, 'YOUXIANZERENGONGSI(WAIGUOFARENDUZI) YXZRGS(WGFRDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPC06X1XTUB4C4L', 200001, '18', '有限责任公司(外商投资企业法人独资)', NULL, 35, '0035', '', '', 0, 'YOUXIANZERENGONGSI(WAISHANGTOUZIQIYEFARENDUZI) YXZRGS(WSTZQYFRDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPCCLZ1XTUU5CSL', 200001, '19', '有限责任公司(外商投资企业与内资合资)', NULL, 37, '0037', '', '', 0, 'YOUXIANZERENGONGSI(WAISHANGTOUZIQIYEYUNEIZIHEZI) YXZRGS(WSTZQYYNZHZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPCPEZ1XTU6QFUN', 200001, '20', '有限责任公司(外商投资、非独资)', NULL, 39, '0039', '', '', 0, 'YOUXIANZERENGONGSI(WAISHANGTOUZI、FEIDUZI) YXZRGS(WSTZ、FDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPD1BL1XTUXO2R7', 200001, '21', '有限责任公司(国有控股)', NULL, 41, '0041', '', '', 0, 'YOUXIANZERENGONGSI(GUOYOUKONGGU) YXZRGS(GYKG)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPDCW71XTU2FML0', 200001, '22', '有限责任公司(台港澳与境内合资)', NULL, 43, '0043', '', '', 0, 'YOUXIANZERENGONGSI(TAIGANGAOYUJINGNEIHEZI) YXZRGS(TGAYJNHZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPDRZW1XTUKTDF1', 200001, '23', '有限责任公司(中外合资)', NULL, 45, '0045', '', '', 0, 'YOUXIANZERENGONGSI(ZHONGWAIHEZI) YXZRGS(ZWHZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPE5GI1XTUTGVRB', 200001, '24', '有限责任公司', NULL, 47, '0047', '', '', 0, 'YOUXIANZERENGONGSI YXZRGS', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPEJ0L1XTUJJ355', 200001, '25', '其他股份有限公司(非上市)', NULL, 49, '0049', '', '', 0, 'QITAGUFENYOUXIANGONGSI(FEISHANGSHI) QTGFYXGS(FSS)', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6MPEWCY1XTUUTZ8E', 200001, '26', '其他有限责任公司', NULL, 51, '0051', '', '', 0, 'QITAYOUXIANZERENGONGSI QTYXZRGS', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEEF7C1XTUNU1YJ', 200002, '1', '零售业', NULL, 1, '0001', '', '', 0, 'LINGSHOUYE LSY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEEPLQ1XTUS0QPW', 200002, '2', '铁路、船舶、航空航天和其他运输设备制造业', NULL, 3, '0003', '', '', 0, 'TIELU、CHUANBO、HANGKONGHANGTIANHEQITAYUNSHUSHEBEIZHIZAOYE TL、CB、HKHTHQTYSSBZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEEYJC1XTU0R9EF', 200002, '3', '道路运输业', NULL, 5, '0005', '', '', 0, 'DAOLUYUNSHUYE DLYSY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEF80J1XTU7AZQK', 200002, '4', '通用设备制造业', NULL, 7, '0007', '', '', 0, 'TONGYONGSHEBEIZHIZAOYE TYSBZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEFKML1XTUR7WX3', 200002, '5', '软件和信息技术服务业', NULL, 9, '0009', '', '', 0, 'RUANJIANHEXINXIJISHUFUWUYE RJHXXJSFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEFWTI1XTUDC9DK', 200002, '6', '计算机、通信和其他电子设备制造业', NULL, 11, '0011', '', '', 0, 'JISUANJI、TONGXINHEQITADIANZISHEBEIZHIZAOYE JSJ、TXHQTDZSBZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEG9HD1XTU3HRBG', 200002, '7', '科技推广和应用服务业', NULL, 13, '0013', '', '', 0, 'KEJITUIGUANGHEYINGYONGFUWUYE KJTGHYYFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEGL2F1XTUR3FPZ', 200002, '8', '研究和试验发展', NULL, 15, '0015', '', '', 0, 'YANJIUHESHIYANFAZHAN YJHSYFZ', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEGUY01XTUPYP1W', 200002, '9', '电气机械和器材制造业', NULL, 17, '0017', '', '', 0, 'DIANQIJIXIEHEQICAIZHIZAOYE DQJXHQCZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEH5AU1XTUDHJX1', 200002, '10', '电力、热力生产和供应业', NULL, 19, '0019', '', '', 0, 'DIANLI、RELISHENGCHANHEGONGYINGYE DL、RLSCHGYY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEHH2T1XTUW5DRE', 200002, '11', '生态保护和环境治理业', NULL, 21, '0021', '', '', 0, 'SHENGTAIBAOHUHEHUANJINGZHILIYE STBHHHJZLY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEHSRV1XTUENWEI', 200002, '12', '文化艺术业', NULL, 23, '0023', '', '', 0, 'WENHUAYISHUYE WHYSY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEI4R61XTU1VB3W', 200002, '13', '批发业', NULL, 25, '0025', '', '', 0, 'PIFAYE PFY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEIGN91XTU1EXWE', 200002, '14', '建筑装饰、装修和其他建筑业', NULL, 27, '0027', '', '', 0, 'JIANZHUZHUANGSHI、ZHUANGXIUHEQITAJIANZHUYE JZZS、ZXHQTJZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEITVV1XTUEKCCO', 200002, '15', '广播、电视、电影和录音制作业', NULL, 29, '0029', '', '', 0, 'GUANGBO、DIANSHI、DIANYINGHELUYINZHIZUOYE GB、DS、DYHLYZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEJ84Y1XTUPBMIL', 200002, '16', '居民服务业', NULL, 31, '0031', '', '', 0, 'JUMINFUWUYE JMFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEJK3B1XTUERPKO', 200002, '17', '商务服务业', NULL, 33, '0033', '', '', 0, 'SHANGWUFUWUYE SWFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEJZ3F1XTU1Y0T0', 200002, '18', '医药制造业', NULL, 35, '0035', '', '', 0, 'YIYAOZHIZAOYE YYZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEKD741XTUNLCRX', 200002, '19', '化学原料和化学制品制造业', NULL, 37, '0037', '', '', 0, 'HUAXUEYUANLIAOHEHUAXUEZHIPINZHIZAOYE HXYLHHXZPZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEKR081XTU5T936', 200002, '20', '农业', NULL, 39, '0039', '', '', 0, 'NONGYE NY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEL4P81XTU5NT7V', 200002, '21', '其他金融业', NULL, 41, '0041', '', '', 0, 'QITAJINRONGYE QTJRY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VELJP51XTUHSIJP', 200002, '22', '其他服务业', NULL, 43, '0043', '', '', 0, 'QITAFUWUYE QTFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VELXY41XTULFG2B', 200002, '23', '其他制造业', NULL, 45, '0045', '', '', 0, 'QITAZHIZAOYE QTZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEMBJX1XTUHHPC5', 200002, '24', '公共设施管理业', NULL, 47, '0047', '', '', 0, 'GONGGONGSHESHIGUANLIYE GGSSGLY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEMO5E1XTUT9X5N', 200002, '25', '仪器仪表制造业', NULL, 49, '0049', '', '', 0, 'YIQIYIBIAOZHIZAOYE YQYBZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VEN1971XTUKWZUC', 200002, '26', '互联网和相关服务', NULL, 51, '0051', '', '', 0, 'HULIANWANGHEXIANGGUANFUWU HLWHXGFW', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VENF6A1XTU1JEMX', 200002, '27', '专用设备制造业', NULL, 53, '0053', '', '', 0, 'ZHUANYONGSHEBEIZHIZAOYE ZYSBZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6VENSD91XTUYZQS8', 200002, '28', '专业技术服务业', NULL, 55, '0055', '', '', 0, 'ZHUANYEJISHUFUWUYE ZYJSFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ6A851XTU6LNGX', 200003, '1', '存续', NULL, 1, '0001', '', '', 0, 'CUNXU CX', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ6NBJ1XTUZHLR8', 200003, '2', '在营', NULL, 3, '0003', '', '', 0, 'ZAIYING ZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ6ZN41XTUFRHUH', 200003, '3', '开业', NULL, 5, '0005', '', '', 0, 'KAIYE KY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ7BEJ1XTUJ8E2S', 200003, '4', '在业', NULL, 7, '0007', '', '', 0, 'ZAIYE ZY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ7N071XTUJKHU2', 200003, '5', '吊销', NULL, 9, '0009', '', '', 0, 'DIAOXIAO DX', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ7X3G1XTUJD4KO', 200003, '6', '注销', NULL, 11, '0011', '', '', 0, 'ZHUXIAO ZX', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ87SH1XTUBC5DU', 200003, '7', '迁入', NULL, 13, '0013', '', '', 0, 'QIANRU QR', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ8IHI1XTU7385Y', 200003, '8', '迁出', NULL, 15, '0015', '', '', 0, 'QIANCHU QC', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ8TFO1XTUEL2U2', 200003, '9', '停业', NULL, 17, '0017', '', '', 0, 'TINGYE TY', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ94EW1XTUBC183', 200003, '10', '清算', NULL, 19, '0019', '', '', 0, 'QINGSUAN QS', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ6ZJ9FCG1XTUIP8HX', 200003, '11', '吊销，未注销', NULL, 21, '0021', '', '', 0, 'DIAOXIAO，WEIZHUXIAO DX，WZX', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ709S06Q1XTUCQOKC', 200004, '1', '初创期', NULL, 1, '0001', '', '', 0, 'CHUCHUANGQI CCQ', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ709SAS51XTUVMGX5', 200004, '2', '成长期', NULL, 3, '0003', '', '', 0, 'CHENGZHANGQI CZQ', '');
INSERT INTO `common_dictionary` VALUES ('0GAJ709SMJA1XTU7F3TL', 200004, '3', '壮大期', NULL, 5, '0005', '', '', 0, 'ZHUANGDAQI ZDQ', '');
INSERT INTO `common_dictionary` VALUES ('0GAK2DBVCSA1XTUJJ525', 200005, '1', '高新技术企业', NULL, 1, '0001', '', '', 0, 'GAOXINJISHUQIYE GXJSQY', '');
INSERT INTO `common_dictionary` VALUES ('0GAK2DBVR651XTUU3BT6', 200005, '2', '科技型中小企业', NULL, 3, '0003', '', '', 0, 'KEJIXINGZHONGXIAOQIYE KJXZXQY', '');
INSERT INTO `common_dictionary` VALUES ('0GAK2DBW1EY1XTU3C6TR', 200005, '3', '规上高新技术企业', NULL, 5, '0005', '', '', 0, 'GUISHANGGAOXINJISHUQIYE GSGXJSQY', '');
INSERT INTO `common_dictionary` VALUES ('0GAK2DBWBWP1XTUXZ8EQ', 200005, '4', '瞪羚企业', NULL, 7, '0007', '', '', 0, 'DENGLINGQIYE DLQY', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3NNJQ9M1XTU623EX', 200006, '1', '最近三年研发费用累计金额（万元）', '', 1, '0001', '', '', 0, 'ZUIJINSANNIANYANFAFEIYONGLEIJIJINE（WANYUAN） ZJSNYFFYLJJE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3OAOV861XTUG592X', 200006, '2', '研发费用占营业收入的比例（%）', '', 2, '0002', '', '', 0, 'YANFAFEIYONGZHANYINGYESHOURUDEBILI（%） YFFYZYYSRDBL（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3OIU23C1XTU6U05D', 200006, '3', '研发费用增速（%）', '', 3, '0003', '', '', 0, 'YANFAFEIYONGZENGSU（%） YFFYZS（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3OX8KRH1XTUM3FYI', 200006, '4', '研发人员占职工总数的比重（%）', '', 4, '0004', '', '', 0, 'YANFARENYUANZHANZHIGONGZONGSHUDEBIZHONG（%） YFRYZZGZSDBZ（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3P4D70N1XTUP6EX5', 200006, '5', '与主营业务相关的发明专利申请量（件）', '', 5, '0005', '', '', 0, 'YUZHUYINGYEWUXIANGGUANDEFAMINGZHUANLISHENQINGLIANG（JIAN） YZYYWXGDFMZLSQL（J）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3RFUGEW1XTUYGT1P', 200006, '6', 'PCT专利申请量（件）', '', 6, '0006', '', '', 0, 'PCTZHUANLISHENQINGLIANG（JIAN） PCTZLSQL（J）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3RMEWI21XTUW2ABG', 200006, '7', '与主营业务相关的知识产权授权数（件）', '', 7, '0007', '', '', 0, 'YUZHUYINGYEWUXIANGGUANDEZHISHICHANQUANSHOUQUANSHU（JIAN） YZYYWXGDZSCQSQS（J）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3RRIT5J1XTUOAN6Z', 200006, '8', '企业与高校、院所之间的技术合同成交额（万元）', '', 8, '0008', '', '', 0, 'QIYEYUGAOXIAO、YUANSUOZHIJIANDEJISHUHETONGCHENGJIAOE（WANYUAN） QYYGX、YSZJDJSHTCJE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3S1FCYS1XTUULRHM', 200006, '9', '主导或参与制修订国家/国际标准数（项）', '', 9, '0009', '', '', 0, 'ZHUDAOHUOCANYUZHIXIUDINGGUOJIA/GUOJIBIAOZHUNSHU（XIANG） ZDHCYZXDGJ/GJBZS（X）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3SETPIA1XTUO9V98', 200006, '10', '高新技术产品收入（万元）', '', 10, '0010', '', '', 0, 'GAOXINJISHUCHANPINSHOURU（WANYUAN） GXJSCPSR（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3SKTO5H1XTUAE1NF', 200006, '11', '营业收入（万元）', '', 11, '0011', '', '', 0, 'YINGYESHOURU（WANYUAN） YYSR（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3SSNQZU1XTUY7AS1', 200006, '12', '营业收入增长率（%）', '', 12, '0012', '', '', 0, 'YINGYESHOURUZENGZHANGLV（%） YYSRZZL（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3T1190Z1XTUDVT5M', 200006, '13', '本科以上人员占比（%）', '', 13, '0013', '', '', 0, 'BENKEYISHANGRENYUANZHANBI（%） BKYSRYZB（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3T8BCCW1XTU5KXKZ', 200006, '14', '研发费用加计扣除所得税减免额（万元）', '', 14, '0014', '', '', 0, 'YANFAFEIYONGJIAJIKOUCHUSUODESHUIJIANMIANE（WANYUAN） YFFYJJKCSDSJME（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3TE4QG01XTUR3J24', 200006, '15', '净资产利润率（%）', '', 15, '0015', '', '', 0, 'JINGZICHANLIRUNLV（%） JZCLRL（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3TKGQWU1XTUJ3GP9', 200006, '16', '近三年累计获得创业风险投资额（万元）', '', 16, '0016', '', '', 0, 'JINSANNIANLEIJIHUODECHUANGYEFENGXIANTOUZIE（WANYUAN） JSNLJHDCYFXTZE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3TUWUI41XTU2LOJ5', 200006, '17', '每年社保净增人数（人）', '', 17, '0017', '', '', 0, 'MEINIANSHEBAOJINGZENGRENSHU（REN） MNSBJZRS（R）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3U36ZJO1XTUW757Z', 200006, '18', '当年吸纳高效应届毕业生人数（人）', '', 18, '0018', '', '', 0, 'DANGNIANXINAGAOXIAOYINGJIEBIYESHENGRENSHU（REN） DNXNGXYJBYSRS（R）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3U8XM341XTUDADHA', 200006, '19', '承担建设省级以上研发或创新平台数量（家）', '', 19, '0019', '', '', 0, 'CHENGDANJIANSHESHENGJIYISHANGYANFAHUOCHUANGXINPINGTAISHULIANG（JIA） CDJSSJYSYFHCXPTSL（J）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3UF7W751XTUISUUO', 200006, '20', '获得国家科技奖励数量（项）', '', 20, '0020', '', '', 0, 'HUODEGUOJIAKEJIJIANGLISHULIANG（XIANG） HDGJKJJLSL（X）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3UKBY1P1XTU98EXU', 200006, '21', '承担国家科技计划项目数量（项）', '', 21, '0021', '', '', 0, 'CHENGDANGUOJIAKEJIJIHUAXIANGMUSHULIANG（XIANG） CDGJKJJHXMSL（X）', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3UP556Z1XTUWD964', 200006, '22', '是否高新技术企业/科技型中小企业', '', 22, '0022', '', '', 0, 'SHIFOUGAOXINJISHUQIYE/KEJIXINGZHONGXIAOQIYE SFGXJSQY/KJXZXQY', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3UTFBON1XTU9WRYY', 200006, '23', '在国家级创新创业赛事获奖名次', '', 23, '0023', '', '', 0, 'ZAIGUOJIAJICHUANGXINCHUANGYESAISHIHUOJIANGMINGCI ZGJJCXCYSSHJMC', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3V2Q9XF1XTU4OK87', 200006, '24', '创始人背景', '', 24, '0024', '', '', 0, 'CHUANGSHIRENBEIJING CSRBJ', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3V8NRSO1XTUOGI8U', 200006, '25', '是否为瞪羚/独角兽（潜在独角兽）企业', '', 25, '0025', '', '', 0, 'SHIFOUWEIDENGLING/DUJIAOSHOU（QIANZAIDUJIAOSHOU）QIYE SFWDL/DJS（QZDJS）QY', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3VHR1GJ1XTUXJWWI', 200006, '26', '进行股权激励', '', 26, '0026', '', '', 0, 'JINXINGGUQUANJILI JXGQJL', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3VOV3TX1XTUWI06U', 200006, '27', '完成股份制改造', '', 27, '0027', '', '', 0, 'WANCHENGGUFENZHIGAIZAO WCGFZGZ', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3VV53KX1XTUP96VN', 200006, '28', '企业征信情况', '', 28, '0028', '', '', 0, 'QIYEZHENGXINQINGKUANG QYZXQK', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3W48YMC1XTUR8BQH', 200006, '29', '企业环境信用等级', '', 29, '0029', '', '', 0, 'QIYEHUANJINGXINYONGDENGJI QYHJXYDJ', '');
INSERT INTO `common_dictionary` VALUES ('0GAK3W9TGCH1XTUN600Q', 200006, '30', '税务零申报', '', 30, '0030', '', '', 0, 'SHUIWULINGSHENBAO SWLSB', '');
INSERT INTO `common_dictionary` VALUES ('0GAPZCPG96P1XTURFBTE', 200000, '1', '基本信息', '', 1, '0001', '1', '', 0, 'JIBENXINXI JBXX', '');
INSERT INTO `common_dictionary` VALUES ('0GAPZFNQH9F1XTU3Z2DR', 200000, '2', '经营风险', NULL, 2, '0002', '2', '', 0, 'JINGYINGFENGXIAN JYFX', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4UZP11XTUQARZA', 200008, '天使轮', '天使轮', NULL, 1, '0001', '', '', 0, 'TIANSHILUN TSL', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4VIM71XTU8825M', 200008, 'A轮', 'A轮', NULL, 3, '0003', '', '', 0, 'ALUN AL', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4VVR31XTUYV49K', 200008, 'B轮', 'B轮', NULL, 5, '0005', '', '', 0, 'BLUN BL', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4W6AW1XTUTUOJG', 200008, 'C轮', 'C轮', NULL, 7, '0007', '', '', 0, 'CLUN CL', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4WISJ1XTU6LLML', 200008, 'D轮', 'D轮', NULL, 9, '0009', '', '', 0, 'DLUN DL', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4WXWJ1XTUQR52O', 200008, 'E轮及以上', 'E轮及以上', NULL, 11, '0011', '', '', 0, 'ELUNJIYISHANG ELJYS', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4X97C1XTUID4GI', 200008, 'IPO', 'IPO', NULL, 13, '0013', '', '', 0, 'IPO', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4XJG91XTUZLGJL', 200008, '定向增发', '定向增发', NULL, 15, '0015', '', '', 0, 'DINGXIANGZENGFA DXZF', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPN4XSSE1XTUKSSA0', 200008, '其他', '其他', NULL, 17, '0017', '', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN5Y6B1XTUSX4G5', 200009, 'A股', 'A股', NULL, 1, '0001', '', '', 0, 'AGU AG', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN67X21XTUCLDY2', 200009, '中概股', '中概股', NULL, 3, '0003', '', '', 0, 'ZHONGGAIGU ZGG', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN6G2K1XTUIPWYH', 200009, '港股', '港股', NULL, 5, '0005', '', '', 0, 'GANGGU GG', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN6S7N1XTU3LEDC', 200009, '科创板', '科创板', NULL, 7, '0007', '', '', 0, 'KECHUANGBAN KCB', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN74311XTUVVAU1', 200009, '新三板', '新三板', NULL, 9, '0009', '', '', 0, 'XINSANBAN XSB', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN7D671XTUNXP6Y', 200009, '新四板', '新四板', NULL, 11, '0011', '', '', 0, 'XINSIBAN XSB', '');
INSERT INTO `common_dictionary` VALUES ('0GAQPUN7M3W1XTUHFA4N', 200009, '未上市', '未上市', NULL, 0, '0000', '', '', 0, 'WEISHANGSHI WSS', '');
INSERT INTO `common_dictionary` VALUES ('0GAQWRTZ7BI1XTUZPWVB', 200006, '31', '社保增长率', '', 31, '0031', '', '', 0, 'SHEBAOZENGZHANGLV SBZZL', '');
INSERT INTO `common_dictionary` VALUES ('0GARZYKDOR81XTUVXF4O', 200000, '102', 'tbl_enterprise_qydt', '1', 2, '0001.0002', '1.102', '', 0, 'tbl_enterprise_qydt', '企业动态');
INSERT INTO `common_dictionary` VALUES ('0GAS0083E5K1XTUD6U3G', 200000, '201', 'tbl_enterprise_qyfx', '2', 1, '0002.0001', '2.201', '', 0, 'tbl_enterprise_qyfx', '企业风险');
INSERT INTO `common_dictionary` VALUES ('0GAT2AX1EQ91XTUISTQ1', 200000, '3', '企业发展', '', 3, '0003', '3', '', 0, 'QIYEFAZHAN QYFZ', '企业发展');
INSERT INTO `common_dictionary` VALUES ('0GAT2D0Y77X1XTU68FSD', 200000, '999', '更多信息', NULL, 5, '0005', '999', '', 0, 'GENGDUOXINXI GDXX', '更多信息');
INSERT INTO `common_dictionary` VALUES ('0GB0UOZE65S1XTUB8CL7', 2001301, 'config', '{\"dlEnterpriseQuota\":200000,\"gsEnterpriseQuota\":500000,\"gxEnterpriseQuota\":200000,\"kjEnterpriseQuota\":200000,\"powerJobId\":1193,\"updateDate\":\"09-06 17:50:00\"}', '', 1, '0001', '', '', 0, '{\"dlEnterpriseQuota\":200000,\"gsEnterpriseQuota\":500000,\"gxEnterpriseQuota\":200000,\"kjEnterpriseQuota\":200000,\"powerJobId\":1193,\"updateDate\":\"09-06 17:50:00\"}', '');
INSERT INTO `common_dictionary` VALUES ('0GB47Z0DK5C1XTU6VNY8', 200007, '1', '光电子信息', NULL, 1, '0001', '', '', 0, 'GUANGDIANZIXINXI GDZXX', '');
INSERT INTO `common_dictionary` VALUES ('0GB47Z0DUWF1XTU802TG', 200007, '2', '生命健康', NULL, 3, '0003', '', '', 0, 'SHENGMINGJIANKANG SMJK', '');
INSERT INTO `common_dictionary` VALUES ('0GB47Z0E7O51XTUB7DN8', 200007, '3', '智能产业+脑科学', NULL, 5, '0005', '', '', 0, 'ZHINENGCHANYE+NAOKEXUE ZNCY+NKX', '');
INSERT INTO `common_dictionary` VALUES ('0GB47Z0FRNI1XTU5SQOW', 200007, '4', '区块链', NULL, 9, '0009', '', '', 0, 'QUKUAILIAN QKL', '');
INSERT INTO `common_dictionary` VALUES ('0GB47Z0GDKD1XTUZ4WLF', 200007, '5', '量子信息', NULL, 11, '0011', '', '', 0, 'LIANGZIXINXI LZXX', '');
INSERT INTO `common_dictionary` VALUES ('0GB47Z0GUR51XTUR3YN1', 200007, '6', '其他', NULL, 13, '0013', '', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GB5CXSSLUH1XTUKYWME', 2001302, '1', '研究开发', '', 1, '0001', '', '', 0, 'YANJIUKAIFA YJKF', '');
INSERT INTO `common_dictionary` VALUES ('0GB5CYB86OT1XTULXKPQ', 2001302, '2', '校验检测类', '', 3, '0003', '', '', 0, 'XIAOYANJIANCELEI XYJCL', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VR3PI1XTUM7YAO', 2001303, '1', '工业（产品）设计与服务', NULL, 1, '0001', '', '', 0, 'GONGYE（CHANPIN）SHEJIYUFUWU GY（CP）SJYFW', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VR9S01XTU8D5SK', 2001303, '2', '工艺设计与服务', NULL, 3, '0003', '', '', 0, 'GONGYISHEJIYUFUWU GYSJYFW', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VRHNN1XTUVRMAK', 2001303, '3', '集成电路设计', NULL, 5, '0005', '', '', 0, 'JICHENGDIANLUSHEJI JCDLSJ', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VROVB1XTUQA457', 2001303, '4', '新产品与工艺合作研发', NULL, 7, '0007', '', '', 0, 'XINCHANPINYUGONGYIHEZUOYANFA XCPYGYHZYF', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VRVBO1XTUDVTFQ', 2001303, '5', '新技术委托开发', NULL, 9, '0009', '', '', 0, 'XINJISHUWEITUOKAIFA XJSWTKF', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VS3NM1XTUB6YD6', 2001303, '6', '技术解决方案', NULL, 11, '0011', '', '', 0, 'JISHUJIEJUEFANGAN JSJJFA', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VSB0U1XTUDIMMO', 2001303, '7', '中试及工程化开发服务', NULL, 13, '0013', '', '', 0, 'ZHONGSHIJIGONGCHENGHUAKAIFAFUWU ZSJGCHKFFW', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VSJ8A1XTUXC6O3', 2001303, '8', '云计算服务', NULL, 15, '0015', '', '', 0, 'YUNJISUANFUWU YJSFW', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VSQ9T1XTUHMPE5', 2001303, '9', '超算服务', NULL, 17, '0017', '', '', 0, 'CHAOSUANFUWU CSFW', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VSY8M1XTUDKLG9', 2001303, '10', '产品检验', NULL, 19, '0019', '', '', 0, 'CHANPINJIANYAN CPJY', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VT7HX1XTU8BQSK', 2001303, '11', '指标测试', NULL, 21, '0021', '', '', 0, 'ZHIBIAOCESHI ZBCS', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VTFDE1XTUKJN1H', 2001303, '12', '产品性能测试', NULL, 23, '0023', '', '', 0, 'CHANPINXINGNENGCESHI CPXNCS', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VTMR61XTUE2OA1', 2001303, '13', '技术标准研制与应用', NULL, 25, '0025', '', '', 0, 'JISHUBIAOZHUNYANZHIYUYINGYONG JSBZYZYYY', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VTTRJ1XTU4L0IU', 2001303, '14', '集成电路封装测试', NULL, 27, '0027', '', '', 0, 'JICHENGDIANLUFENGZHUANGCESHI JCDLFZCS', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VU2GR1XTUWKANK', 2001303, '15', '检验检疫', NULL, 29, '0029', '', '', 0, 'JIANYANJIANYI JYJY', '');
INSERT INTO `common_dictionary` VALUES ('0GB5D4VUAMH1XTU0RAVS', 2001303, '16', '材料测试', NULL, 31, '0031', '', '', 0, 'CAILIAOCESHI CLCS', '');
INSERT INTO `common_dictionary` VALUES ('0GB7FPRL0FR1XTUARG48', 2001304, '1', '湖北实验室', '', 1, '0001', '', '', 0, 'HUBEISHIYANSHI HBSYS', '');
INSERT INTO `common_dictionary` VALUES ('0GB7FQ3226S1XTUD9983', 2001304, '2', '国家级创新中心', '', 2, '0002', '', '', 0, 'GUOJIAJICHUANGXINZHONGXIN GJJCXZX', '');
INSERT INTO `common_dictionary` VALUES ('0GB7FQ87VFM1XTUDHBRR', 2001304, '3', '中试平台', '', 3, '0003', '', '', 0, 'ZHONGSHIPINGTAI ZSPT', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07PKXO1XTUIZLNX', 200010, '1', '光谷生物城', NULL, 1, '0001', '', '', 0, 'GUANGGUSHENGWUCHENG GGSWC', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07PVH01XTU8XVLN', 200010, '2', '光谷现代服务业园', NULL, 3, '0003', '', '', 0, 'GUANGGUXIANDAIFUWUYEYUAN GGXDFWYY', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07Q8MW1XTUFVWM4', 200010, '3', '光谷未来科技城', NULL, 5, '0005', '', '', 0, 'GUANGGUWEILAIKEJICHENG GGWLKJC', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07QIP11XTUOGCH0', 200010, '4', '光谷智能制造产业园', NULL, 7, '0007', '', '', 0, 'GUANGGUZHINENGZHIZAOCHANYEYUAN GGZNZZCYY', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07QUXG1XTUAEVYX', 200010, '5', '光谷光电子信息产业园', NULL, 9, '0009', '', '', 0, 'GUANGGUGUANGDIANZIXINXICHANYEYUAN GGGDZXXCYY', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07R7HB1XTUB2CTI', 200010, '6', '光谷中心城', NULL, 11, '0011', '', '', 0, 'GUANGGUZHONGXINCHENG GGZXC', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07RI881XTUTV1TI', 200010, '7', '光谷中华科技产业园', NULL, 13, '0013', '', '', 0, 'GUANGGUZHONGHUAKEJICHANYEYUAN GGZHKJCYY', '');
INSERT INTO `common_dictionary` VALUES ('0GBJP07RT0K1XTUUI8BH', 200010, '8', '光谷东湖综合保税区', NULL, 15, '0015', '', '', 0, 'GUANGGUDONGHUZONGHEBAOSHUIQU GGDHZHBSQ', '');
INSERT INTO `common_dictionary` VALUES ('0GBKH7Z740M1XTUCN07Z', 2001304, '4', '高校院所', '', 4, '0004', '', '', 0, 'GAOXIAOYUANSUO GXYS', '');
INSERT INTO `common_dictionary` VALUES ('0GBKH85PO6X1XTUNIM0H', 2001304, '5', '工业技术研究院', '', 5, '0005', '', '', 0, 'GONGYEJISHUYANJIUYUAN GYJSYJY', '');
INSERT INTO `common_dictionary` VALUES ('0GBKH8ATEUF1XTUQ5QU9', 2001304, '6', '具有CMA或CNAS资质', '', 6, '0006', '', '', 0, 'JUYOUCMAHUOCNASZIZHI JYCMAHCNASZZ', '');
INSERT INTO `common_dictionary` VALUES ('0GBKH8L98HL1XTU071ZK', 2001304, '7', '行业领先的开放式第三方机构', '', 7, '0007', '', '', 0, 'XINGYELINGXIANDEKAIFANGSHIDISANFANGJIGOU XYLXDKFSDSFJG', '');
INSERT INTO `common_dictionary` VALUES ('0GBMZIGUUEF1XTUE0FTD', 200000, '101', 'tbl_enterprise_qygd', '1', 1, '0001.0001', '1.101', '', 0, 'tbl_enterprise_qygd', '企业股东信息');
INSERT INTO `common_dictionary` VALUES ('0GBP6KU0LNO1XTUY0Z3P', 200001, '27', '有限责任公司(外商合资)', '', 53, '0053', '', '', 0, 'YOUXIANZERENGONGSI(WAISHANGHEZI) YXZRGS(WSHZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6LKVNJE1XTUFAS31', 200002, '29', '餐饮业', '', 57, '0057', '', '', 0, 'CANYINYE CYY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6LPYF391XTUV57XI', 200002, '30', '土木工程建筑业', '', 59, '0059', '', '', 0, 'TUMUGONGCHENGJIANZHUYE TMGCJZY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6LVL1C91XTUMUE89', 200002, '31', '房屋建筑业', '', 61, '0061', '', '', 0, 'FANGWUJIANZHUYE FWJZY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6LZKNYB1XTU0WQUX', 200002, '32', '机动车、电子产品和日用产品修理业', '', 63, '0063', '', '', 0, 'JIDONGCHE、DIANZICHANPINHERIYONGCHANPINXIULIYE JDC、DZCPHRYCPXLY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6M3AZ8E1XTU9EZK2', 200002, '33', '建筑安装业', '', 65, '0065', '', '', 0, 'JIANZHUANZHUANGYE JZAZY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6M6WJAN1XTU873P3', 200002, '34', '金属制品业', '', 67, '0067', '', '', 0, 'JINSHUZHIPINYE JSZPY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6MFRENJ1XTU73LMO', 200002, '35', '房地产业', '', 69, '0069', '', '', 0, 'FANGDICHANYE FDCY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6MKY1W01XTUZK5UK', 200002, '36', '农副食品加工业', '', 71, '0071', '', '', 0, 'NONGFUSHIPINJIAGONGYE NFSPJGY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6MQRJTA1XTUXMVH6', 200002, '37', '橡胶和塑料制品业', '', 73, '0073', '', '', 0, 'XIANGJIAOHESULIAOZHIPINYE XJHSLZPY', '');
INSERT INTO `common_dictionary` VALUES ('0GBP6MX43QM1XTUC52SK', 200002, '38', '纺织业', '', 75, '0075', '', '', 0, 'FANGZHIYE FZY', '');
INSERT INTO `common_dictionary` VALUES ('0GBTNI36TE11XTUCX5XG', 200004, '4', '成熟期', '', 7, '0007', '', '', 0, 'CHENGSHUQI CSQ', '');
INSERT INTO `common_dictionary` VALUES ('0GBUMGVTSGT1XTUTR0LS', 200006, '32', '税务增长率', '', 32, '0032', '', '', 0, 'SHUIWUZENGZHANGLV SWZZL', '');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPHSQO1XTU28J9H', 2001401, '1', '国家开发银行', NULL, 1, '0001', '', '', 0, 'GUOJIAKAIFAYINXING GJKFYX', 'http://192.168.0.132/citms/2022/7/21/425cacbb58d0c04ccb4d72b06639815c.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPI1KK1XTU1Q6GZ', 2001401, '2', '汉口银行', NULL, 3, '0003', '', '', 0, 'HANKOUYINXING HKYX', 'http://192.168.0.132/citms/2022/7/21/849a1bb727c802b7a51634d59ab51f03.jpg');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPIAVO1XTUR4WFT', 2001401, '3', '浦发银行', NULL, 5, '0005', '', '', 0, 'PUFAYINXING PFYX', 'http://192.168.0.132/citms/2022/7/21/4fa5fdc280bcf0cb444d4ae58eb010de.jpg');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPIM221XTUA937B', 2001401, '4', '微众银行', NULL, 7, '0007', '', '', 0, 'WEIZHONGYINXING WZYX', 'http://192.168.0.132/citms/2022/7/21/e9281edcb938254a81c64a4e1396455a.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPIV2T1XTULYWCP', 2001401, '5', '武汉农村商业银行', NULL, 9, '0009', '', '', 0, 'WUHANNONGCUNSHANGYEYINXING WHNCSYYX', 'http://192.168.0.132/citms/2022/7/21/c5c6bb382931e6be8bca5dfb7a13af1c.jpg');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPJ5FN1XTUFEIEX', 2001401, '6', '中国工商银行', NULL, 11, '0011', '', '', 0, 'ZHONGGUOGONGSHANGYINXING ZGGSYX', 'http://192.168.0.132/citms/2022/7/21/fd3d2b6140129b3a6428eafed08cb31d.jpg');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPJHB61XTU3PFXS', 2001401, '7', '中国建设银行', NULL, 13, '0013', '', '', 0, 'ZHONGGUOJIANSHEYINXING ZGJSYX', 'http://192.168.0.132/citms/2022/7/21/90897256ba4e9bdc2f448c5b53673a86.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPJS6A1XTU4JG58', 2001401, '8', '中国交通银行', NULL, 15, '0015', '', '', 0, 'ZHONGGUOJIAOTONGYINXING ZGJTYX', 'http://192.168.0.132/citms/2022/7/21/5eb14cd53a8d3443eaba1dc5a2ec5b3d.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPK1KX1XTURYPGN', 2001401, '9', '中国农业银行', NULL, 17, '0017', '', '', 0, 'ZHONGGUONONGYEYINXING ZGNYYX', 'http://192.168.0.132/citms/2022/7/21/d615efef2ed6babe22b287b74be4ef6b.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPKBCI1XTU8X1RD', 2001401, '10', '中国人民银行', NULL, 19, '0019', '', '', 0, 'ZHONGGUORENMINYINXING ZGRMYX', 'http://192.168.0.132/citms/2022/7/21/ca10b5c9d86511edded63572878a85c3.jpg');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPKLKL1XTUJ8KKM', 2001401, '11', '中国银行', NULL, 21, '0021', '', '', 0, 'ZHONGGUOYINXING ZGYX', 'http://192.168.0.132/citms/2022/7/21/be65521e599f4b6ca6aa1887eafcdd9d.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPKUVL1XTUL8LQP', 2001401, '12', '中国邮政储蓄银行', NULL, 23, '0023', '', '', 0, 'ZHONGGUOYOUZHENGCHUXUYINXING ZGYZCXYX', 'http://192.168.0.132/citms/2022/7/21/b4524807c9c5a207124cb55ff3ae08f1.png');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPL4QH1XTUOZ6ZI', 2001401, '13', '中国招商银行', NULL, 25, '0025', '', '', 0, 'ZHONGGUOZHAOSHANGYINXING ZGZSYX', 'http://192.168.0.132/citms/2022/7/21/5c54c5b0c2c1093da03b6d1117a57cb2.jpg');
INSERT INTO `common_dictionary` VALUES ('0GBUQXPLDZX1XTULUESA', 2001401, '14', '中信银行', NULL, 27, '0027', '', '', 0, 'ZHONGXINYINXING ZXYX', 'http://192.168.0.132/citms/2022/7/21/c7012ac30db740b15117f7eca1b8d603.png');
INSERT INTO `common_dictionary` VALUES ('0GBWSOIV5961XTUQBF0P', 200008, '种子轮', '种子轮', '', 0, '0000', '', '', 0, 'ZHONGZILUN ZZL', '');
INSERT INTO `common_dictionary` VALUES ('0GBYS47RK0C1XTUUVJK0', 200000, '103', 'tbl_enterprise_qyfz', '1', 5, '0001.0005', '1.103', '', 0, 'tbl_enterprise_qyfz', '分支机构');
INSERT INTO `common_dictionary` VALUES ('0GBZ21NRAMF1XTUL4MSZ', 200000, '301', 'tbl_enterprise_dwtz', '3', 1, '0003.0001', '3.301', '', 0, 'tbl_enterprise_dwtz', '投资信息');
INSERT INTO `common_dictionary` VALUES ('0GBZ22BZO721XTUVGWDC', 200000, '302', 'tbl_enterprise_qyrzxx', '3', 3, '0003.0003', '3.302', '', 0, 'tbl_enterprise_qyrzxx', '融资信息');
INSERT INTO `common_dictionary` VALUES ('0GBZ2966MR91XTUM8FJA', 200000, '303', 'tbl_enterprise_qyxwyq', '3', 5, '0003.0005', '3.303', '', 0, 'tbl_enterprise_qyxwyq', '新闻舆情');
INSERT INTO `common_dictionary` VALUES ('0GBZ2F2X7991XTUI9975', 200000, '304', 'tbl_enterprise_nbxx', '3', 7, '0003.0007', '3.304', '', 0, 'tbl_enterprise_nbxx', '企业年报');
INSERT INTO `common_dictionary` VALUES ('0GC6HE4NNCC1XTUUXT43', 200001, '28', '股份有限公司(台港澳与境内合资、上市)', '', 55, '0055', '', '', 0, 'GUFENYOUXIANGONGSI(TAIGANGAOYUJINGNEIHEZI、SHANGSHI) GFYXGS(TGAYJNHZ、SS)', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HE9FYFS1XTUE6580', 200001, '29', '其他股份有限公司(上市)', '', 57, '0057', '', '', 0, 'QITAGUFENYOUXIANGONGSI(SHANGSHI) QTGFYXGS(SS)', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HEE81LE1XTUI3GWH', 200001, '30', '全民所有制', '', 59, '0059', '', '', 0, 'QUANMINSUOYOUZHI QMSYZ', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HEHWPD41XTUZVSTP', 200001, '31', '股份合作制', '', 61, '0061', '', '', 0, 'GUFENHEZUOZHI GFHZZ', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HEPGI1E1XTUX9KG8', 200001, '32', '有限责任公司(国有独资)', '', 63, '0063', '', '', 0, 'YOUXIANZERENGONGSI(GUOYOUDUZI) YXZRGS(GYDZ)', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HGHLVK51XTUH4T4M', 200002, '39', '汽车制造业', '', 77, '0077', '', '', 0, 'QICHEZHIZAOYE QCZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HGO63Z41XTUA7O58', 200002, '40', '非金属矿物制品业', '', 79, '0079', '', '', 0, 'FEIJINSHUKUANGWUZHIPINYE FJSKWZPY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HGSEJSN1XTUNGFIZ', 200002, '41', '新闻和出版业', '', 81, '0081', '', '', 0, 'XINWENHECHUBANYE XWHCBY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HGW781B1XTUS6SYM', 200002, '42', '印刷和记录媒介复制业', '', 83, '0083', '', '', 0, 'YINSHUAHEJILUMEIJIEFUZHIYE YSHJLMJFZY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HGZWXB01XTU2K5B9', 200002, '43', '食品制造业', '', 85, '0085', '', '', 0, 'SHIPINZHIZAOYE SPZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HHCF1CG1XTUB2GKC', 200002, '44', '纺织服装、服饰业', '', 87, '0087', '', '', 0, 'FANGZHIFUZHUANG、FUSHIYE FZFZ、FSY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HHG3KMK1XTU7ZG23', 200002, '45', '电信、广播电视和卫星传输服务', '', 89, '0089', '', '', 0, 'DIANXIN、GUANGBODIANSHIHEWEIXINGCHUANSHUFUWU DX、GBDSHWXCSFW', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HHJUD1K1XTU821OB', 200002, '46', '金属制品、机械和设备修理业', '', 91, '0091', '', '', 0, 'JINSHUZHIPIN、JIXIEHESHEBEIXIULIYE JSZP、JXHSBXLY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HHPF2271XTUORE1K', 200002, '47', '文教、工美、体育和娱乐用品制造业', '', 93, '0093', '', '', 0, 'WENJIAO、GONGMEI、TIYUHEYULEYONGPINZHIZAOYE WJ、GM、TYHYLYPZZY', '');
INSERT INTO `common_dictionary` VALUES ('0GC6HHTYGX31XTUX9R6Q', 200002, '48', '娱乐业', '', 95, '0095', '', '', 0, 'YULEYE YLY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA6ZUJ0JA1XTUUL671', 200030, '1', '武汉东湖新技术开发区', NULL, 1, '0001', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQU WHDHXJSKFQ', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTVR1P1XTUWMW7W', 200031, '1', '海关', NULL, 1, '0001', '', '', 0, 'HAIGUAN HG', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTW23X1XTUS39OH', 200031, '2', '旅游', NULL, 3, '0003', '', '', 0, 'LVYOU LY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTWEYR1XTU8OGYI', 200031, '3', '商贸', NULL, 5, '0005', '', '', 0, 'SHANGMAO SM', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTWQGH1XTUVS45H', 200031, '4', '财政', NULL, 7, '0007', '', '', 0, 'CAIZHENG CZ', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTX20M1XTUJJ6Z2', 200031, '5', '审计', NULL, 9, '0009', '', '', 0, 'SHENJI SJ', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTXCVN1XTU2YXGQ', 200031, '6', '金融', NULL, 11, '0011', '', '', 0, 'JINRONG JR', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTXMZ01XTUX2ZHG', 200031, '7', '能源', NULL, 13, '0013', '', '', 0, 'NENGYUAN NY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTXWYZ1XTUXH22R', 200031, '8', '农业', NULL, 15, '0015', '', '', 0, 'NONGYE NY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTYBWF1XTUMXOWW', 200031, '9', '水利', NULL, 17, '0017', '', '', 0, 'SHUILI SL', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTYNC21XTURIH38', 200031, '10', '林业', NULL, 19, '0019', '', '', 0, 'LINYE LY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTYY4P1XTU15PWC', 200031, '11', '科技', NULL, 21, '0021', '', '', 0, 'KEJI KJ', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTZ9DV1XTUT932F', 200031, '12', '教育\"', NULL, 23, '0023', '', '', 0, 'JIAOYU\" JY\"', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTZL9C1XTU955BF', 200031, '13', '卫生', NULL, 25, '0025', '', '', 0, 'WEISHENG WS', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FTZXF91XTUIGKDV', 200031, '14', '体育', NULL, 27, '0027', '', '', 0, 'TIYU TY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU07KF1XTU1MO1Q', 200031, '15', '其他', NULL, 29, '0029', '', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU0N5I1XTU2QT77', 200031, '16', '环境保护', NULL, 31, '0031', '', '', 0, 'HUANJINGBAOHU HJBH', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU0ZAP1XTUFL5DU', 200031, '17', '城乡建设', NULL, 33, '0033', '', '', 0, 'CHENGXIANGJIANSHE CXJS', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU1BWA1XTU77IVZ', 200031, '18', '国土资源', NULL, 35, '0035', '', '', 0, 'GUOTUZIYUAN GTZY', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU1MDL1XTUCRI8M', 200031, '19', '综合政务', NULL, 37, '0037', '', '', 0, 'ZONGHEZHENGWU ZHZW', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU1WLT1XTUL47WZ', 200031, '20', '社会救助', NULL, 39, '0039', '', '', 0, 'SHEHUIJIUZHU SHJZ', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU27RV1XTUZAEXG', 200031, '21', '政务公开', NULL, 41, '0041', '', '', 0, 'ZHENGWUGONGKAI ZWGK', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU2IQD1XTU5BDMH', 200031, '22', '市场监管', NULL, 43, '0043', '', '', 0, 'SHICHANGJIANGUAN SCJG', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU2U9P1XTUEVCIU', 200031, '23', '安全生产监管', NULL, 45, '0045', '', '', 0, 'ANQUANSHENGCHANJIANGUAN AQSCJG', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7FU36ZH1XTUIEHJQ', 200031, '24', '食品药品监管', NULL, 47, '0047', '', '', 0, 'SHIPINYAOPINJIANGUAN SPYPJG', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QDWP4W1XTU0ZDMG', 200032, '1', '武汉市人民政府', NULL, 1, '0001', '', '', 0, 'WUHANSHIRENMINZHENGFU WHSRMZF', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QDWZWJ1XTUZ5HTK', 200032, '2', '武汉市民政局', NULL, 3, '0003', '', '', 0, 'WUHANSHIMINZHENGJU WHSMZJ', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QDXAB51XTUA6ONE', 200032, '3', '武汉市人民政府办公厅', NULL, 5, '0005', '', '', 0, 'WUHANSHIRENMINZHENGFUBANGONGTING WHSRMZFBGT', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QDXO0T1XTU0T6YN', 200032, '4', '武汉东湖新技术开发区政务网', NULL, 7, '0007', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQUZHENGWUWANG WHDHXJSKFQZWW', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QDXZUA1XTU8MSO8', 200032, '5', '武汉东湖新技术开发区管委会', NULL, 9, '0009', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQUGUANWEIHUI WHDHXJSKFQGWH', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QDYBBF1XTUC3366', 200032, '6', '武汉东湖新技术开发区管理委员会', NULL, 11, '0011', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQUGUANLIWEIYUANHUI WHDHXJSKFQGLWYH', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QKXLY41XTU0ONRK', 200032, '7', '武汉东湖新技术开发区管委会、中国（湖北）自由贸易试验区武汉片区管委会', '', 13, '0013', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQUGUANWEIHUI、ZHONGGUO（HUBEI）ZIYOUMAOYISHIYANQUWUHANPIANQUGUANWEIHUI WHDHXJSKFQGWH、ZG（HB）ZYMYSYQWHPQGWH', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7QTGCAQ1XTUUGX9K', 200032, '8', '武汉东湖新技术开发区管理委员会  中国（湖北）自由贸易试验区武汉片区管理委员会', '', 15, '0015', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQUGUANLIWEIYUANHUI  ZHONGGUO（HUBEI）ZIYOUMAOYISHIYANQUWUHANPIANQUGUANLIWEIYUANHUI WHDHXJSKFQGLWYH  ZG（HB）ZYMYSYQWHPQGLWYH', '');
INSERT INTO `common_dictionary` VALUES ('0GCA7R301EA1XTULEGOZ', 200032, '9', '武汉东湖新技术开发区管理委员会 中国（湖北）自由贸易试验区武汉片区管理委员会', '', 17, '0017', '', '', 0, 'WUHANDONGHUXINJISHUKAIFAQUGUANLIWEIYUANHUI ZHONGGUO（HUBEI）ZIYOUMAOYISHIYANQUWUHANPIANQUGUANLIWEIYUANHUI WHDHXJSKFQGLWYH ZG（HB）ZYMYSYQWHPQGLWYH', '');
INSERT INTO `common_dictionary` VALUES ('0GCGON6ZBVA1XTUESY7N', 200040, '1', '高企申报系统', NULL, 1, '0001', '', '', 0, 'GAOQISHENBAOXITONG GQSBXT', '');
INSERT INTO `common_dictionary` VALUES ('0GCGON6ZN5X1XTUGVO6I', 200040, '2', '火炬中心', NULL, 3, '0003', '', '', 0, 'HUOJUZHONGXIN HJZX', '');
INSERT INTO `common_dictionary` VALUES ('0GCGON6ZXZA1XTU2FGKL', 200040, '3', '瞪羚云申报', NULL, 5, '0005', '', '', 0, 'DENGLINGYUNSHENBAO DLYSB', '');
INSERT INTO `common_dictionary` VALUES ('0GCGON70AOG1XTUVVG47', 200040, '4', '科小申报系统', NULL, 7, '0007', '', '', 0, 'KEXIAOSHENBAOXITONG KXSBXT', '');
INSERT INTO `common_dictionary` VALUES ('0GCGON70L101XTUQ7FN3', 200040, '5', '填报', NULL, 9, '0009', '', '', 0, 'TIANBAO TB', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGAW1A1XTUF0P0G', 200041, '1', '营业收入（万元）', NULL, 1, '0001', '', '', 0, 'YINGYESHOURU（WANYUAN） YYSR（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGBASB1XTUPI9F1', 200041, '2', '主营业务收入（万元）', NULL, 3, '0003', '', '', 0, 'ZHUYINGYEWUSHOURU（WANYUAN） ZYYWSR（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGBOQE1XTUCCD8R', 200041, '3', '高新技术产品收入（万元）', NULL, 5, '0005', '', '', 0, 'GAOXINJISHUCHANPINSHOURU（WANYUAN） GXJSCPSR（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGC5HU1XTUUS9DU', 200041, '4', '研发费用总额（万元）', NULL, 7, '0007', '', '', 0, 'YANFAFEIYONGZONGE（WANYUAN） YFFYZE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGCQMV1XTUW1HOS', 200041, '5', '资产总额（万元）', NULL, 9, '0009', '', '', 0, 'ZICHANZONGE（WANYUAN） ZCZE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGD1XQ1XTUUWU9J', 200041, '6', '净资产（万元）', NULL, 11, '0011', '', '', 0, 'JINGZICHAN（WANYUAN） JZC（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGDFAM1XTUB89RY', 200041, '7', '利润总额（万元）', NULL, 13, '0013', '', '', 0, 'LIRUNZONGE（WANYUAN） LRZE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGDRXW1XTUBJGB4', 200041, '8', '净利润（万元）', NULL, 15, '0015', '', '', 0, 'JINGLIRUN（WANYUAN） JLR（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGE3BU1XTUU4VA2', 200041, '9', '纳税总额（万元）', NULL, 17, '0017', '', '', 0, 'NASHUIZONGE（WANYUAN） NSZE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGEDQU1XTUYAPPE', 200041, '10', '研发加计扣除所得税减免（万元）', NULL, 19, '0019', '', '', 0, 'YANFAJIAJIKOUCHUSUODESHUIJIANMIAN（WANYUAN） YFJJKCSDSJM（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGEOXG1XTUQLZZL', 200041, '11', '成本费用总额（万元）', NULL, 21, '0021', '', '', 0, 'CHENGBENFEIYONGZONGE（WANYUAN） CBFYZE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGF8BL1XTU8JAW0', 200041, '12', '研发费用占销售收入总额比例（%）', NULL, 23, '0023', '', '', 0, 'YANFAFEIYONGZHANXIAOSHOUSHOURUZONGEBILI（%） YFFYZXSSRZEBL（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGFLLH1XTURM2L5', 200041, '13', '研发费用占成本费用支出总额比例（%）', NULL, 25, '0025', '', '', 0, 'YANFAFEIYONGZHANCHENGBENFEIYONGZHICHUZONGEBILI（%） YFFYZCBFYZCZEBL（%）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGONGFX8D1XTULLJKW', 200041, '14', '上市（挂牌）企业年末市值（万元）', NULL, 27, '0027', '', '', 0, 'SHANGSHI（GUAPAI）QIYENIANMOSHIZHI（WANYUAN） SS（GP）QYNMSZ（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOV30O1XTU3P5H2', 200042, '1', '发明专利（个）', NULL, 1, '0001', '', '', 0, 'FAMINGZHUANLI（GE） FMZL（G）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOVE8L1XTUINJ5I', 200042, '2', '实用新型专利', NULL, 3, '0003', '', '', 0, 'SHIYONGXINXINGZHUANLI SYXXZL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOVYJV1XTU6ATTI', 200042, '3', '外观设计专利', NULL, 5, '0005', '', '', 0, 'WAIGUANSHEJIZHUANLI WGSJZL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOW9UI1XTU0Q3JB', 200042, '4', '软件著作权', NULL, 7, '0007', '', '', 0, 'RUANJIANZHUZUOQUAN RJZZQ', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOWJJW1XTU2JOX6', 200042, '5', 'PCT专利申请（项）', NULL, 9, '0009', '', '', 0, 'PCTZHUANLISHENQING（XIANG） PCTZLSQ（X）', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOX8S51XTUFJJCM', 200042, '7', '承担国家科技计划项目数量', NULL, 13, '0013', '', '', 0, 'CHENGDANGUOJIAKEJIJIHUAXIANGMUSHULIANG CDGJKJJHXMSL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOXJSA1XTUCO2VD', 200042, '8', '与主营业务相关的发明专利申请量', NULL, 15, '0015', '', '', 0, 'YUZHUYINGYEWUXIANGGUANDEFAMINGZHUANLISHENQINGLIANG YZYYWXGDFMZLSQL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOXUUU1XTUQWR75', 200042, '9', '承担建设省级以上研发或创新平台数量', NULL, 17, '0017', '', '', 0, 'CHENGDANJIANSHESHENGJIYISHANGYANFAHUOCHUANGXINPINGTAISHULIANG CDJSSJYSYFHCXPTSL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOY8Y11XTU0RQN0', 200042, '10', '获得国家科技奖项数量', NULL, 19, '0019', '', '', 0, 'HUODEGUOJIAKEJIJIANGXIANGSHULIANG HDGJKJJXSL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOZIO71XTUIW4KM', 200042, '11', '标准制定_国际标准', NULL, 21, '0021', '', '', 0, 'BIAOZHUNZHIDING_GUOJIBIAOZHUN BZZD_GJBZ', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTOZWFM1XTUVWY63', 200042, '12', '标准制定_国家标准', NULL, 23, '0023', '', '', 0, 'BIAOZHUNZHIDING_GUOJIABIAOZHUN BZZD_GJBZ', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTP08HT1XTU20F7E', 200042, '13', '标准制定_行业标准', NULL, 25, '0025', '', '', 0, 'BIAOZHUNZHIDING_XINGYEBIAOZHUN BZZD_XYBZ', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY0HWN1XTUCGJ0S', 200043, '1', '职工总数', NULL, 1, '0001', '', '', 0, 'ZHIGONGZONGSHU ZGZS', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY0QUJ1XTUDWY7H', 200043, '2', '科技人员数量', NULL, 3, '0003', '', '', 0, 'KEJIRENYUANSHULIANG KJRYSL', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY2CLI1XTUIOZ5Z', 200043, '3', '企业博士人数', NULL, 5, '0005', '', '', 0, 'QIYEBOSHIRENSHU QYBSRS', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY3QIH1XTU1TC51', 200043, '4', '企业硕士人数', NULL, 7, '0007', '', '', 0, 'QIYESHUOSHIRENSHU QYSSRS', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY4TLN1XTUWJT5W', 200043, '5', '企业本科人数', NULL, 9, '0009', '', '', 0, 'QIYEBENKERENSHU QYBKRS', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY5DG01XTUTNZRE', 200043, '6', '吸纳高校毕业生人数', NULL, 11, '0011', '', '', 0, 'XINAGAOXIAOBIYESHENGRENSHU XNGXBYSRS', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY5OJ21XTULZ22A', 200043, '7', '本年新增人数', NULL, 13, '0013', '', '', 0, 'BENNIANXINZENGRENSHU BNXZRS', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY66X51XTUFSL1P', 200043, '8', '机构研究开发人员合计', NULL, 15, '0015', '', '', 0, 'JIGOUYANJIUKAIFARENYUANHEJI JGYJKFRYHJ', '');
INSERT INTO `common_dictionary` VALUES ('0GCGOTY6O5X1XTUA4IZJ', 200043, '9', '科技人员占企业职工总数比例', NULL, 17, '0017', '', '', 0, 'KEJIRENYUANZHANQIYEZHIGONGZONGSHUBILI KJRYZQYZGZSBL', '');
INSERT INTO `common_dictionary` VALUES ('0GCHK377GB11XTU32E3M', 2001305, '1', '等待审批', '', 1, '0001', '', '', 0, 'DENGDAISHENPI DDSP', '');
INSERT INTO `common_dictionary` VALUES ('0GCHK3G3OPM1XTUT657K', 2001305, '2', '审批通过待公示', '', 3, '0003', '', '', 0, 'SHENPITONGGUODAIGONGSHI SPTGDGS', '');
INSERT INTO `common_dictionary` VALUES ('0GCHK3JLRQC1XTU8R5CW', 2001305, '3', '公示期中', '', 3, '0003', '', '', 0, 'GONGSHIQIZHONG GSQZ', '');
INSERT INTO `common_dictionary` VALUES ('0GCHK3VITM11XTUXWPJM', 2001305, '5', '兑付完成', '', 5, '0005', '', '', 0, 'DUIFUWANCHENG DFWC', '');
INSERT INTO `common_dictionary` VALUES ('0GCHK41WDT21XTU2ACV1', 2001305, '6', '审批未通过', '', 6, '0006', '', '', 0, 'SHENPIWEITONGGUO SPWTG', '');
INSERT INTO `common_dictionary` VALUES ('0GCURV70JWC1XTUBJBUH', 200000, '99901', 'tbl_enterprise_qysxbzxr', '999', 1, '0005.0001', '999.99901', '', 0, 'tbl_enterprise_qysxbzxr', '历史失信人');
INSERT INTO `common_dictionary` VALUES ('0GCURXEB9F51XTUI8VR9', 200000, '4', '知识产权', '', 4, '0004', '4', '', 0, 'ZHISHICHANQUAN ZSCQ', '');
INSERT INTO `common_dictionary` VALUES ('0GCURYCV1WE1XTUBB35Q', 200000, '401', 'tbl_enterprise_qyzl', '4', 1, '0004.0001', '4.401', '', 0, 'tbl_enterprise_qyzl', '专利信息');
INSERT INTO `common_dictionary` VALUES ('0GCV32PSW5G1XTUJLB8Z', 2001305, '4', '公示完成', '', 4, '0004', '', '', 0, 'GONGSHIWANCHENG GSWC', '');
INSERT INTO `common_dictionary` VALUES ('0GCW6FCDOM11XTULR6KQ', 200011, '1', '企业', '', 1, '0001', '', '', 0, 'QIYE QY', '');
INSERT INTO `common_dictionary` VALUES ('0GCW6FIR6BU1XTUQYT0Y', 200011, '2', '大专院校', '', 2, '0002', '', '', 0, 'DAZHUANYUANXIAO DZYX', '');
INSERT INTO `common_dictionary` VALUES ('0GCW6FVY2NZ1XTU3OLMO', 200011, '3', '科研院所', '', 3, '0003', '', '', 0, 'KEYANYUANSUO KYYS', '');
INSERT INTO `common_dictionary` VALUES ('0GCW6G21HFT1XTU45FR5', 200011, '4', '园区', '', 4, '0004', '', '', 0, 'YUANQU YQ', '');
INSERT INTO `common_dictionary` VALUES ('0GCY3KGXKGM1XTU5H7P8', 200041, '15', '企业与高校院所之间的技术合同成交额（万元）', '', 29, '0029', '', '', 0, 'QIYEYUGAOXIAOYUANSUOZHIJIANDEJISHUHETONGCHENGJIAOE（WANYUAN） QYYGXYSZJDJSHTCJE（WY）', '');
INSERT INTO `common_dictionary` VALUES ('0GCZCFU1F3M1XTUIIOTZ', 2001306, '1', '创新券兑付', '', 1, '0001', '', '', 0, 'CHUANGXINQUANDUIFU CXQDF', '');
INSERT INTO `common_dictionary` VALUES ('0GCZCG3A4VK1XTUETQYN', 2001306, '2', '兑付排行', '', 2, '0002', '', '', 0, 'DUIFUPAIXING DFPX', '');
INSERT INTO `common_dictionary` VALUES ('0GD2Q7EMF9C1XTUN0SJ6', 200050, 'tyc_qydt', '企业动态', '', 1, '0001', 'tyc_qydt', '', 0, 'QIYEDONGTAI QYDT', '');
INSERT INTO `common_dictionary` VALUES ('0GD2Q9ZKY5C1XTUZMDBA', 200050, 'tyc_gqct', '企业股权穿透', '', 1, '0001', 'tyc_gqct', '', 0, 'QIYEGUQUANCHUANTOU QYGQCT', '');
INSERT INTO `common_dictionary` VALUES ('0GD3QFIRRHT3K3Q2LKXR', 200050, 'tyc_nbxx', '企业年报信息', '', 1, '0001', 'tyc_nbxx', '', 0, 'QIYENIANBAOXINXI QYNBXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3QHAC7YI3K3QTNR0L', 200050, 'tyc_nbxx_gsmc', '公司名称', 'tyc_nbxx', 1, '0001.0001', 'tyc_nbxx.tyc_nbxx_gsmc', '', 0, 'GONGSIMINGCHENG GSMC', 'gsmc');
INSERT INTO `common_dictionary` VALUES ('0GD3QHSKR743K3Q6YEI0', 200050, 'tyc_nbxx_nbnf', '年报年份', 'tyc_nbxx', 3, '0001.0003', 'tyc_nbxx.tyc_nbxx_nbnf', '', 0, 'NIANBAONIANFEN NBNF', 'nbnf');
INSERT INTO `common_dictionary` VALUES ('0GD3QJGJKXV3K3QNUTKA', 200050, 'tyc_qydt_bdrq', '变更日期', 'tyc_qydt', 3, '0001.0003', 'tyc_qydt.tyc_qydt_bdrq', '', 0, 'BIANGENGRIQI BGRQ', 'bdrq');
INSERT INTO `common_dictionary` VALUES ('0GD3QJT5C4I3K3QAAQES', 200050, 'tyc_qydt_fxjb', '风险级别', 'tyc_qydt', 5, '0001.0005', 'tyc_qydt.tyc_qydt_fxjb', '', 0, 'FENGXIANJIBIE FXJB', 'fxjb');
INSERT INTO `common_dictionary` VALUES ('0GD3QK81BMR3K3QI0126', 200050, 'tyc_qydt_bglx', '变更类型', 'tyc_qydt', 7, '0001.0007', 'tyc_qydt.tyc_qydt_bglx', '', 0, 'BIANGENGLEIXING BGLX', 'bglx');
INSERT INTO `common_dictionary` VALUES ('0GD3QQOP7YM3K3Q0HZTC', 200050, 'tyc_gqct_tzrmc', '投资人名称', 'tyc_gqct', 1, '0001.0001', 'tyc_gqct.tyc_gqct_tzrmc', '', 0, 'TOUZIRENMINGCHENG TZRMC', 'tzrmc');
INSERT INTO `common_dictionary` VALUES ('0GD3QR0ZOOB3K3QZXTFJ', 200050, 'tyc_gqct_tzrzt', '投资人状态', 'tyc_gqct', 3, '0001.0003', 'tyc_gqct.tyc_gqct_tzrzt', '', 0, 'TOUZIRENZHUANGTAI TZRZT', 'tzrzt');
INSERT INTO `common_dictionary` VALUES ('0GD3QRD6D913K3QV7K5G', 200050, 'tyc_gqct_tze', '投资额', 'tyc_gqct', 5, '0001.0005', 'tyc_gqct.tyc_gqct_tze', '', 0, 'TOUZIE TZE', 'tze');
INSERT INTO `common_dictionary` VALUES ('0GD3QRQEVWL3K3QFQGQ7', 200050, 'tyc_gqct_tzzb', '投资占比', 'tyc_gqct', 7, '0001.0007', 'tyc_gqct.tyc_gqct_tzzb', '', 0, 'TOUZIZHANBI TZZB', 'tzzb');
INSERT INTO `common_dictionary` VALUES ('0GD3QSSGU593K3QF66TI', 200050, 'tyc_qygd', '企业股东信息', NULL, 5, '0005', 'tyc_qygd', '', 0, 'QIYEGUDONGXINXI QYGDXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3QTPZG043K3Q1VM99', 200050, 'tyc_qygd_gd', '股东名称', 'tyc_qygd', 1, '0005.0001', 'tyc_qygd.tyc_qygd_gd', '', 0, 'GUDONGMINGCHENG GDMC', 'gd');
INSERT INTO `common_dictionary` VALUES ('0GD3QU286T33K3Q2R1VR', 200050, 'tyc_qygd_cgbl', '持股比例', 'tyc_qygd', 3, '0005.0003', 'tyc_qygd.tyc_qygd_cgbl', '', 0, 'CHIGUBILI CGBL', 'cgbl');
INSERT INTO `common_dictionary` VALUES ('0GD3QUGAS8L3K3Q1D027', 200050, 'tyc_qygd_zzsygf', '最终受益股份', 'tyc_qygd', 5, '0005.0005', 'tyc_qygd.tyc_qygd_zzsygf', '', 0, 'ZUIZHONGSHOUYIGUFEN ZZSYGF', 'zzsygf');
INSERT INTO `common_dictionary` VALUES ('0GD3QUQXOS93K3QJG5FR', 200050, 'tyc_qygd_rjcze', '认缴出资额', 'tyc_qygd', 7, '0005.0007', 'tyc_qygd.tyc_qygd_rjcze', '', 0, 'RENJIAOCHUZIE RJCZE', 'rjcze');
INSERT INTO `common_dictionary` VALUES ('0GD3QV0L27J3K3QX3M6W', 200050, 'tyc_qygd_rjrq', '认缴日期', 'tyc_qygd', 9, '0005.0009', 'tyc_qygd.tyc_qygd_rjrq', '', 0, 'RENJIAORIQI RJRQ', 'rjrq');
INSERT INTO `common_dictionary` VALUES ('0GD3QWM3SXO3K3QG9COH', 200050, 'tyc_qyss', '企业上市信息', NULL, 11, '0011', 'tyc_qyss', '', 0, 'QIYESHANGSHIXINXI QYSSXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3QX5GLPS3K3Q021J4', 200050, 'tyc_qyss_ssbk', '上市板块', 'tyc_qyss', 1, '0011.0001', 'tyc_qyss.tyc_qyss_ssbk', '', 0, 'SHANGSHIBANKUAI SSBK', 'ssbk');
INSERT INTO `common_dictionary` VALUES ('0GD3QXGZG7Z3K3QNV87Y', 200050, 'tyc_qyss_gpmc', '股票名称', 'tyc_qyss', 3, '0011.0003', 'tyc_qyss.tyc_qyss_gpmc', '', 0, 'GUPIAOMINGCHENG GPMC', 'gpmc');
INSERT INTO `common_dictionary` VALUES ('0GD3QXQQ5PE3K3QYKI5C', 200050, 'tyc_qyss_gpdm', '股票代码', 'tyc_qyss', 5, '0011.0005', 'tyc_qyss.tyc_qyss_gpdm', '', 0, 'GUPIAODAIMA GPDM', 'gpdm');
INSERT INTO `common_dictionary` VALUES ('0GD3QYEUSOT3K3QLWZT0', 200050, 'tyc_qyss_sszt', '上市状态', 'tyc_qyss', 7, '0011.0007', 'tyc_qyss.tyc_qyss_sszt', '', 0, 'SHANGSHIZHUANGTAI SSZT', 'sszt');
INSERT INTO `common_dictionary` VALUES ('0GD3QZ4C1R03K3Q18VCK', 200050, 'tyc_qyzl', '企业专利信息', NULL, 9, '0009', 'tyc_qyzl', '', 0, 'QIYEZHUANLIXINXI QYZLXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3QZSKVJ53K3Q9J56I', 200050, 'tyc_qyzl_sqrq', '申请日期', 'tyc_qyzl', 1, '0009.0001', 'tyc_qyzl.tyc_qyzl_sqrq', '', 0, 'SHENQINGRIQI SQRQ', 'sqrq');
INSERT INTO `common_dictionary` VALUES ('0GD3R05V6UI3K3QJZX59', 200050, 'tyc_qyzl_zlmc', '专利名称', 'tyc_qyzl', 3, '0009.0003', 'tyc_qyzl.tyc_qyzl_zlmc', '', 0, 'ZHUANLIMINGCHENG ZLMC', 'zlmc');
INSERT INTO `common_dictionary` VALUES ('0GD3R0GPDPQ3K3QT9CYA', 200050, 'tyc_qyzl_zllx', '专利类型', 'tyc_qyzl', 5, '0009.0005', 'tyc_qyzl.tyc_qyzl_zllx', '', 0, 'ZHUANLILEIXING ZLLX', 'zllx');
INSERT INTO `common_dictionary` VALUES ('0GD3R0UH9EG3K3Q3EHJ1', 200050, 'tyc_qyzl_zlzt', '专利状态', 'tyc_qyzl', 7, '0009.0007', 'tyc_qyzl.tyc_qyzl_zlzt', '', 0, 'ZHUANLIZHUANGTAI ZLZT', 'zlzt');
INSERT INTO `common_dictionary` VALUES ('0GD3R17HT2X3K3QURRFS', 200050, 'tyc_qyzl_sqh', '申请号', 'tyc_qyzl', 9, '0009.0009', 'tyc_qyzl.tyc_qyzl_sqh', '', 0, 'SHENQINGHAO SQH', 'sqh');
INSERT INTO `common_dictionary` VALUES ('0GD3R6Q0PW33K3QXB2DZ', 200050, 'tyc_qyrjzz', '企业软件著作权信息', NULL, 11, '0011', 'tyc_qyrjzz', '', 0, 'QIYERUANJIANZHUZUOQUANXINXI QYRJZZQXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3R7EX7SP3K3QYU2DB', 200050, 'tyc_qyrjzz_rjqc', '软件全称', 'tyc_qyrjzz', 1, '0011.0001', 'tyc_qyrjzz.tyc_qyrjzz_rjqc', '', 0, 'RUANJIANQUANCHENG RJQC', 'rjqc');
INSERT INTO `common_dictionary` VALUES ('0GD3R7ONDDA3K3QCDP0G', 200050, 'tyc_qyrjzz_djh', '登记号', 'tyc_qyrjzz', 3, '0011.0003', 'tyc_qyrjzz.tyc_qyrjzz_djh', '', 0, 'DENGJIHAO DJH', 'djh');
INSERT INTO `common_dictionary` VALUES ('0GD3R7VXUKL3K3Q978IJ', 200050, 'tyc_qyrjzz_scfbrq', '首次发表日期', 'tyc_qyrjzz', 5, '0011.0005', 'tyc_qyrjzz.tyc_qyrjzz_scfbrq', '', 0, 'SHOUCIFABIAORIQI SCFBRQ', 'scfbrq');
INSERT INTO `common_dictionary` VALUES ('0GD3R8OSYJD3K3QVL4K9', 200050, 'tyc_qyjg', '企业架构信息', NULL, 9, '0009', 'tyc_qyjg', '', 0, 'QIYEJIAGOUXINXI QYJGXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3R9U8CYZ3K3QBX5XF', 200050, 'tyc_qyjg_name', '分支名称', 'tyc_qyjg', 1, '0009.0001', 'tyc_qyjg.tyc_qyjg_name', '', 0, 'FENZHIMINGCHENG FZMC', 'name');
INSERT INTO `common_dictionary` VALUES ('0GD3RA9SBSU3K3Q1GTZS', 200050, 'tyc_qyjg_flmc', '分类名称', 'tyc_qyjg', 3, '0009.0003', 'tyc_qyjg.tyc_qyjg_flmc', '', 0, 'FENLEIMINGCHENG FLMC', 'flmc');
INSERT INTO `common_dictionary` VALUES ('0GD3RM7DU773K3QB2W6Z', 200050, 'tyc_qydt_bgnr', '变更内容', 'tyc_qydt', 9, '0001.0009', 'tyc_qydt.tyc_qydt_bgnr', '', 0, 'BIANGENGNEIRONG BGNR', 'bgnr');
INSERT INTO `common_dictionary` VALUES ('0GD3S7HOXCX3K3Q1BOUS', 200050, 'tyc_qyjg_tzzb', '投资占比', 'tyc_qyjg', 5, '0009.0005', 'tyc_qyjg.tyc_qyjg_tzzb', '', 0, 'TOUZIZHANBI TZZB', 'tzzb');
INSERT INTO `common_dictionary` VALUES ('0GD3S95ORJ63K3QKBE1M', 200050, 'tyc_qyjg_tzed', '投资额度', 'tyc_qyjg', 7, '0009.0007', 'tyc_qyjg.tyc_qyjg_tzed', '', 0, 'TOUZIEDU TZED', 'tzed');
INSERT INTO `common_dictionary` VALUES ('0GD3S9TFGQX3K3QG5AN0', 200050, 'tyc_dwtz', '企业投资信息', NULL, 9, '0009', 'tyc_dwtz', '', 0, 'QIYETOUZIXINXI QYTZXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3SBU7CIU3K3QC662Q', 200050, 'tyc_dwtz_name', '被投资企业名称', 'tyc_dwtz', 1, '0009.0001', 'tyc_dwtz.tyc_dwtz_name', '', 0, 'BEITOUZIQIYEMINGCHENG BTZQYMC', 'name');
INSERT INTO `common_dictionary` VALUES ('0GD3SDURU133K3QVRL2L', 200050, 'tyc_dwtz_regStatus', '经营状态', 'tyc_dwtz', 3, '0009.0003', 'tyc_dwtz.tyc_dwtz_regStatus', '', 0, 'JINGYINGZHUANGTAI JYZT', 'regStatus');
INSERT INTO `common_dictionary` VALUES ('0GD3SIC0HT93K3QIRW0Y', 200050, 'tyc_dwtz_amount', '投资数额', 'tyc_dwtz', 5, '0009.0005', 'tyc_dwtz.tyc_dwtz_amount', '', 0, 'TOUZISHUE TZSE', 'amount');
INSERT INTO `common_dictionary` VALUES ('0GD3SJ34J5B3K3Q81GV0', 200050, 'tyc_dwtz_percent', '投资比例', 'tyc_dwtz', 7, '0009.0007', 'tyc_dwtz.tyc_dwtz_percent', '', 0, 'TOUZIBILI TZBL', 'percent');
INSERT INTO `common_dictionary` VALUES ('0GD3SLDIKJW3K3Q6N6MF', 200050, 'tyc_qyswdj', '企业税务评级', NULL, 9, '0009', 'tyc_qyswdj', '', 0, 'QIYESHUIWUPINGJI QYSWPJ', '');
INSERT INTO `common_dictionary` VALUES ('0GD3SN5YWFT3K3QUTHKA', 200050, 'tyc_qyswdj_grade', '税务等级', 'tyc_qyswdj', 1, '0009.0001', 'tyc_qyswdj.tyc_qyswdj_grade', '', 0, 'SHUIWUDENGJI SWDJ', 'grade');
INSERT INTO `common_dictionary` VALUES ('0GD3SNP183Q3K3Q3ZG8U', 200050, 'tyc_qyswdj_year', '评价年份', 'tyc_qyswdj', 3, '0009.0003', 'tyc_qyswdj.tyc_qyswdj_year', '', 0, 'PINGJIANIANFEN PJNF', 'year');
INSERT INTO `common_dictionary` VALUES ('0GD3SOR0L2X3K3QYTYML', 200050, 'tyc_qyswdj_evalDepartment', '评估部门', 'tyc_qyswdj', 5, '0009.0005', 'tyc_qyswdj.tyc_qyswdj_evalDepartment', '', 0, 'PINGGUBUMEN PGBM', 'evalDepartment');
INSERT INTO `common_dictionary` VALUES ('0GD3STGLJ0L3K3QVF3DP', 200050, 'tyc_qybzxr', '企业被执行人信息', NULL, 7, '0007', 'tyc_qybzxr', '', 0, 'QIYEBEIZHIXINGRENXINXI QYBZXRXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3SUC69B03K3QJQDUB', 200050, 'tyc_qybzxr_caseCode', '案件编号', 'tyc_qybzxr', 1, '0007.0001', 'tyc_qybzxr.tyc_qybzxr_caseCode', '', 0, 'ANJIANBIANHAO AJBH', 'caseCode');
INSERT INTO `common_dictionary` VALUES ('0GD3SUTF21K3K3QGTAQV', 200050, 'tyc_qybzxr_pname', '被执行人', 'tyc_qybzxr', 3, '0007.0003', 'tyc_qybzxr.tyc_qybzxr_pname', '', 0, 'BEIZHIXINGREN BZXR', 'pname');
INSERT INTO `common_dictionary` VALUES ('0GD3SVDHPU53K3Q5XD07', 200050, 'tyc_qybzxr_execCourtName', '执行法院', 'tyc_qybzxr', 5, '0007.0005', 'tyc_qybzxr.tyc_qybzxr_execCourtName', '', 0, 'ZHIXINGFAYUAN ZXFY', 'execCourtName');
INSERT INTO `common_dictionary` VALUES ('0GD3SW5LPIT3K3QFB0NA', 200050, 'tyc_qybzxr_caseCreateTime', '案件创建时间', 'tyc_qybzxr', 7, '0007.0007', 'tyc_qybzxr.tyc_qybzxr_caseCreateTime', '', 0, 'ANJIANCHUANGJIANSHIJIAN AJCJSJ', 'caseCreateTime');
INSERT INTO `common_dictionary` VALUES ('0GD3SXMDV913K3QKDZ4J', 200050, 'tyc_qybzxr_execMoney', '执行金额', 'tyc_qybzxr', 9, '0007.0009', 'tyc_qybzxr.tyc_qybzxr_execMoney', '', 0, 'ZHIXINGJINE ZXJE', 'execMoney');
INSERT INTO `common_dictionary` VALUES ('0GD3SYQ6DEH3K3QWIEYW', 200050, 'tyc_qybzxr_execMoneyUnit', '执行金额单位', 'tyc_qybzxr', 11, '0007.0011', 'tyc_qybzxr.tyc_qybzxr_execMoneyUnit', '', 0, 'ZHIXINGJINEDANWEI ZXJEDW', 'execMoneyUnit');
INSERT INTO `common_dictionary` VALUES ('0GD3TCL9N4B3K3QX9JUV', 200050, 'tyc_qycpxx', '企业产品信息', NULL, 13, '0013', 'tyc_qycpxx', '', 0, 'QIYECHANPINXINXI QYCPXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3TF81KCA3K3QVLHXU', 200050, 'tyc_qycpxx_type', '产品分类', 'tyc_qycpxx', 1, '0013.0001', 'tyc_qycpxx.tyc_qycpxx_type', '', 0, 'CHANPINFENLEI CPFL', 'type');
INSERT INTO `common_dictionary` VALUES ('0GD3TFLBHMD3K3QVL7EB', 200050, 'tyc_qycpxx_filterName', '产品简称', 'tyc_qycpxx', 3, '0013.0003', 'tyc_qycpxx.tyc_qycpxx_filterName', '', 0, 'CHANPINJIANCHENG CPJC', 'filterName');
INSERT INTO `common_dictionary` VALUES ('0GD3TKMIXJB3K3QZSISI', 200050, 'tyc_qyfz', '企业分支信息', '', 19, '0019', 'tyc_qyfz', '', 0, 'QIYEFENZHIXINXI QYFZXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3TN8GOQU3K3QM269J', 200050, 'tyc_qyfz_name', '企业名称', 'tyc_qyfz', 1, '0019.0001', 'tyc_qyfz.tyc_qyfz_name', '', 0, 'QIYEMINGCHENG QYMC', 'name');
INSERT INTO `common_dictionary` VALUES ('0GD3U0U0OL83K3Q4TIJW', 200050, 'tyc_qyfz_regStatus', '经营状态', 'tyc_qyfz', 3, '0019.0003', 'tyc_qyfz.tyc_qyfz_regStatus', '', 0, 'JINGYINGZHUANGTAI JYZT', 'regStatus');
INSERT INTO `common_dictionary` VALUES ('0GD3U19SRU53K3Q7AXLI', 200050, 'tyc_qyfz_estiblishTime', '成立日期', 'tyc_qyfz', 5, '0019.0005', 'tyc_qyfz.tyc_qyfz_estiblishTime', '', 0, 'CHENGLIRIQI CLRQ', 'estiblishTime');
INSERT INTO `common_dictionary` VALUES ('0GD3U3J98Y73K3QASAQ1', 200050, 'tyc_qyrzxx', '企业融资信息', NULL, 7, '0007', 'tyc_qyrzxx', '', 0, 'QIYERONGZIXINXI QYRZXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3U4JJWCR3K3QPAFBU', 200050, 'tyc_qyrzxx_pubTime', '披露日期', 'tyc_qyrzxx', 1, '0007.0001', 'tyc_qyrzxx.tyc_qyrzxx_pubTime', '', 0, 'PILURIQI PLRQ', 'pubTime');
INSERT INTO `common_dictionary` VALUES ('0GD3U51N9IX3K3QH9KUZ', 200050, 'tyc_qyrzxx_money', '交易金额', 'tyc_qyrzxx', 3, '0007.0003', 'tyc_qyrzxx.tyc_qyrzxx_money', '', 0, 'JIAOYIJINE JYJE', 'money');
INSERT INTO `common_dictionary` VALUES ('0GD3U5KP9JW3K3QCQNTY', 200050, 'tyc_qyrzxx_round', '融资轮次', 'tyc_qyrzxx', 5, '0007.0005', 'tyc_qyrzxx.tyc_qyrzxx_round', '', 0, 'RONGZILUNCI RZLC', 'round');
INSERT INTO `common_dictionary` VALUES ('0GD3U65MLXS3K3Q2C2HS', 200050, 'tyc_qyrzxx_value', '估值', 'tyc_qyrzxx', 7, '0007.0007', 'tyc_qyrzxx.tyc_qyrzxx_value', '', 0, 'GUZHI GZ', 'value');
INSERT INTO `common_dictionary` VALUES ('0GD3U6UYGMH3K3QOJ3DE', 200050, 'tyc_qyrzxx_share', '比例', 'tyc_qyrzxx', 9, '0007.0009', 'tyc_qyrzxx.tyc_qyrzxx_share', '', 0, 'BILI BL', 'share');
INSERT INTO `common_dictionary` VALUES ('0GD3U7LVK7G3K3QI8L4R', 200050, 'tyc_qyrzxx_investorName', '投资方', 'tyc_qyrzxx', 11, '0007.0011', 'tyc_qyrzxx.tyc_qyrzxx_investorName', '', 0, 'TOUZIFANG TZF', 'investorName');
INSERT INTO `common_dictionary` VALUES ('0GD3U8ACE333K3QEMB3G', 200050, 'tyc_qysxbzxr', '企业失信被执行人', NULL, 13, '0013', 'tyc_qysxbzxr', '', 0, 'QIYESHIXINBEIZHIXINGREN QYSXBZXR', '');
INSERT INTO `common_dictionary` VALUES ('0GD3V3HT2ON3K3QMUFFW', 200050, 'tyc_qysxbzxr_courtname', '做出执行依据单位名称', 'tyc_qysxbzxr', 1, '0013.0001', 'tyc_qysxbzxr.tyc_qysxbzxr_courtname', '', 0, 'ZUOCHUZHIXINGYIJUDANWEIMINGCHENG ZCZXYJDWMC', 'courtname');
INSERT INTO `common_dictionary` VALUES ('0GD3V40Z1NL3K3QLYJR0', 200050, 'tyc_qysxbzxr_iname', '失信被执行人', 'tyc_qysxbzxr', 3, '0013.0003', 'tyc_qysxbzxr.tyc_qysxbzxr_iname', '', 0, 'SHIXINBEIZHIXINGREN SXBZXR', 'iname');
INSERT INTO `common_dictionary` VALUES ('0GD3V4U6K6B3K3QXAW3U', 200050, 'tyc_qysxbzxr_casecode', '案件编号', 'tyc_qysxbzxr', 5, '0013.0005', 'tyc_qysxbzxr.tyc_qysxbzxr_casecode', '', 0, 'ANJIANBIANHAO AJBH', 'casecode');
INSERT INTO `common_dictionary` VALUES ('0GD3V57XFVJ3K3Q8IMVY', 200050, 'tyc_qysxbzxr_regdate', '立案日期', 'tyc_qysxbzxr', 7, '0013.0007', 'tyc_qysxbzxr.tyc_qysxbzxr_regdate', '', 0, 'LIANRIQI LARQ', 'regdate');
INSERT INTO `common_dictionary` VALUES ('0GD3V5QQ6443K3QKRO4M', 200050, 'tyc_qysxbzxr_gistunit', '执行法院', 'tyc_qysxbzxr', 9, '0013.0009', 'tyc_qysxbzxr.tyc_qysxbzxr_gistunit', '', 0, 'ZHIXINGFAYUAN ZXFY', 'gistunit');
INSERT INTO `common_dictionary` VALUES ('0GD3V66BEMW3K3QYS4PT', 200050, 'tyc_qysxbzxr_gistid', '执行依据文号', 'tyc_qysxbzxr', 11, '0013.0011', 'tyc_qysxbzxr.tyc_qysxbzxr_gistid', '', 0, 'ZHIXINGYIJUWENHAO ZXYJWH', 'gistid');
INSERT INTO `common_dictionary` VALUES ('0GD3V6SVQO73K3Q80LP7', 200050, 'tyc_qyxwyq', '企业新闻舆情', NULL, 13, '0013', 'tyc_qyxwyq', '', 0, 'QIYEXINWENYUQING QYXWYQ', '');
INSERT INTO `common_dictionary` VALUES ('0GD3V8WGLKR3K3QX5LHQ', 200050, 'tyc_qyxwyq_title', '新闻主题', 'tyc_qyxwyq', 1, '0013.0001', 'tyc_qyxwyq.tyc_qyxwyq_title', '', 0, 'XINWENZHUTI XWZT', 'title');
INSERT INTO `common_dictionary` VALUES ('0GD3V9JSECP3K3QKRF19', 200050, 'tyc_qyxwyq_website', '新闻来源', 'tyc_qyxwyq', 3, '0013.0003', 'tyc_qyxwyq.tyc_qyxwyq_website', '', 0, 'XINWENLAIYUAN XWLY', 'website');
INSERT INTO `common_dictionary` VALUES ('0GD3V9TV9UR3K3QS1GIT', 200050, 'tyc_qyxwyq_rtm', '发布时间', 'tyc_qyxwyq', 5, '0013.0005', 'tyc_qyxwyq.tyc_qyxwyq_rtm', '', 0, 'FABUSHIJIAN FBSJ', 'rtm');
INSERT INTO `common_dictionary` VALUES ('0GD3VAB3MZP3K3QRDZ1O', 200050, 'tyc_qyxwyq_uri', '新闻地址', 'tyc_qyxwyq', 7, '0013.0007', 'tyc_qyxwyq.tyc_qyxwyq_uri', '', 0, 'XINWENDIZHI XWDZ', 'uri');
INSERT INTO `common_dictionary` VALUES ('0GD3VB1IF043K3Q0DAXL', 200050, 'tyc_qyztb', '企业招投标信息', NULL, 9, '0009', 'tyc_qyztb', '', 0, 'QIYEZHAOTOUBIAOXINXI QYZTBXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3VBSAUMF3K3QD30G5', 200050, 'tyc_qyztb_title', '标题', 'tyc_qyztb', 1, '0009.0001', 'tyc_qyztb.tyc_qyztb_title', '', 0, 'BIAOTI BT', 'title');
INSERT INTO `common_dictionary` VALUES ('0GD3VYONSTQ3K3QG2ZY8', 200050, 'tyc_qyztb_bidAmount', '中标金额', 'tyc_qyztb', 3, '0009.0003', 'tyc_qyztb.tyc_qyztb_bidAmount', '', 0, 'ZHONGBIAOJINE ZBJE', 'bidAmount');
INSERT INTO `common_dictionary` VALUES ('0GD3VZAZRJ33K3QC7WB7', 200050, 'tyc_qyztb_bidAmountCompany', '中标金额单位', 'tyc_qyztb', 5, '0009.0005', 'tyc_qyztb.tyc_qyztb_bidAmountCompany', '', 0, 'ZHONGBIAOJINEDANWEI ZBJEDW', 'bidAmountCompany');
INSERT INTO `common_dictionary` VALUES ('0GD3VZV29CZ3K3QHWGK7', 200050, 'tyc_qyztb_purchaser', '采购人', 'tyc_qyztb', 7, '0009.0007', 'tyc_qyztb.tyc_qyztb_purchaser', '', 0, 'CAIGOUREN CGR', 'purchaser');
INSERT INTO `common_dictionary` VALUES ('0GD3W0800P83K3Q1I752', 200050, 'tyc_qyztb_supplier', '供应商', 'tyc_qyztb', 9, '0009.0009', 'tyc_qyztb.tyc_qyztb_supplier', '', 0, 'GONGYINGSHANG GYS', 'supplier');
INSERT INTO `common_dictionary` VALUES ('0GD3W0QIYI53K3QU1JMP', 200050, 'tyc_qyztb_publishTime', '发布日期', 'tyc_qyztb', 11, '0009.0011', 'tyc_qyztb.tyc_qyztb_publishTime', '', 0, 'FABURIQI FBRQ', 'publishTime');
INSERT INTO `common_dictionary` VALUES ('0GD3W1GRWND3K3Q00PZD', 200050, 'tyc_qysjkzr', '企业实际控制人', NULL, 13, '0013', 'tyc_qysjkzr', '', 0, 'QIYESHIJIKONGZHIREN QYSJKZR', '');
INSERT INTO `common_dictionary` VALUES ('0GD3W2G83IY3K3QHUOII', 200050, 'tyc_qysjkzr_name', '控股企业名称', 'tyc_qysjkzr', 1, '0013.0001', 'tyc_qysjkzr.tyc_qysjkzr_name', '', 0, 'KONGGUQIYEMINGCHENG KGQYMC', 'name');
INSERT INTO `common_dictionary` VALUES ('0GD3W44I7EQ3K3QCYBHD', 200050, 'tyc_qysjkzr_regStatus', '经营状态', 'tyc_qysjkzr', 3, '0013.0003', 'tyc_qysjkzr.tyc_qysjkzr_regStatus', '', 0, 'JINGYINGZHUANGTAI JYZT', 'regStatus');
INSERT INTO `common_dictionary` VALUES ('0GD3W4SG5X43K3QE4S55', 200050, 'tyc_qysjkzr_regCapital', '投资金额', 'tyc_qysjkzr', 5, '0013.0005', 'tyc_qysjkzr.tyc_qysjkzr_regCapital', '', 0, 'TOUZIJINE TZJE', 'regCapital');
INSERT INTO `common_dictionary` VALUES ('0GD3W58ET2G3K3QXVYFW', 200050, 'tyc_qysjkzr_percent', '控股比例', 'tyc_qysjkzr', 7, '0013.0007', 'tyc_qysjkzr.tyc_qysjkzr_percent', '', 0, 'KONGGUBILI KGBL', 'percent');
INSERT INTO `common_dictionary` VALUES ('0GD3XRGJ4EW3K3QYIOAD', 200050, 'tbl_enterprise', '企业基本信息', NULL, 9, '0009', 'tbl_enterprise', '', 0, 'QIYEJIBENXINXI QYJBXX', '');
INSERT INTO `common_dictionary` VALUES ('0GD3XSH9B6N3K3Q6V3Y2', 200050, 'tbl_enterprise_register_capital', '注册资本', 'tbl_enterprise', 1, '0009.0001', 'tbl_enterprise.tbl_enterprise_register_capital', '', 0, 'ZHUCEZIBEN ZCZB', 'register_capital');
INSERT INTO `common_dictionary` VALUES ('0GD3XTRWW5W3K3QG95CU', 200050, 'tbl_enterprise_pay_capital', '实缴资本', 'tbl_enterprise', 3, '0009.0003', 'tbl_enterprise.tbl_enterprise_pay_capital', '', 0, 'SHIJIAOZIBEN SJZB', 'pay_capital');
INSERT INTO `common_dictionary` VALUES ('0GD3XVKD1613K3QHLTDR', 200050, 'tbl_enterprise_register_address', '注册地址', 'tbl_enterprise', 5, '0009.0005', 'tbl_enterprise.tbl_enterprise_register_address', '', 0, 'ZHUCEDIZHI ZCDZ', 'register_address');
INSERT INTO `common_dictionary` VALUES ('0GD5ZKPTU993K3Q11M5X', 200001, '33', '有限责任公司分公司(自然人投资或控股)', '', 65, '0065', '', '', 0, 'YOUXIANZERENGONGSIFENGONGSI(ZIRANRENTOUZIHUOKONGGU) YXZRGSFGS(ZRRTZHKG)', '');
INSERT INTO `common_dictionary` VALUES ('0GD9FM2GGQN3K3QZTATQ', 200012, '1', '按征收率征收增值税小规模纳税人', '', 1, '0001', '', '', 0, 'ANZHENGSHOULVZHENGSHOUZENGZHISHUIXIAOGUIMONASHUIREN AZSLZSZZSXGMNSR', '');
INSERT INTO `common_dictionary` VALUES ('0GD9FMIJ54Y3K3Q9VAYU', 200012, '2', '增值税一般纳税人', '', 3, '0003', '', '', 0, 'ZENGZHISHUIYIBANNASHUIREN ZZSYBNSR', '');
INSERT INTO `common_dictionary` VALUES ('0GDA6G74IL53K3QX6L5K', 200007, '7', '高技术服务业', '', 13, '0013', '', '', 0, 'GAOJISHUFUWUYE GJSFWY', '');
INSERT INTO `common_dictionary` VALUES ('0GDA6GJQ2T33K3QJJJ4G', 200007, '8', '高端装备制造', '', 15, '0015', '', '', 0, 'GAODUANZHUANGBEIZHIZAO GDZBZZ', '');
INSERT INTO `common_dictionary` VALUES ('0GDA6H0VQUR3K3QWW6IN', 200007, '9', '节能环保', '', 17, '0017', '', '', 0, 'JIENENGHUANBAO JNHB', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGL2LOCN3K3QZZ150', 200060, '1', '科技企业孵化器', '', 1, '0001', '', '', 0, 'KEJIQIYEFUHUAQI KJQYFHQ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGL505J93K3Q3C4I7', 200060, '2', '众创空间', '', 3, '0003', '', '', 0, 'ZHONGCHUANGKONGJIAN ZCKJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGLB2WE33K3QA2TL9', 200060, '3', '大学科技园', '', 5, '0005', '', '', 0, 'DAXUEKEJIYUAN DXKJY', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGLJM9RS3K3QZ6ZID', 200061, '1', '国家级', '', 1, '0001', '', '', 0, 'GUOJIAJI GJJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGLOVPDY3K3QNOZRW', 200061, '2', '省级', '', 3, '0003', '', '', 0, 'SHENGJI SJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGLTCAM63K3QN6CHH', 200061, '3', '市级', '', 5, '0005', '', '', 0, 'SHIJI SJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAGLWQVZ73K3QI5KB3', 200061, '4', '区级', '', 7, '0007', '', '', 0, 'QUJI QJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAJ4V356W3K3Q81M93', 200033, '1', '规范性文件', '', 1, '0001', '', '', 0, 'GUIFANXINGWENJIAN GFXWJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAJ51Q2OO3K3QZXTGR', 200033, '2', '区政府文件', '', 2, '0002', '', '', 0, 'QUZHENGFUWENJIAN QZFWJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDAJ59CYQ03K3Q39DQE', 200033, '3', '其他文件', '', 3, '0003', '', '', 0, 'QITAWENJIAN QTWJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDB9Y1RMXB3K3QH6LWC', 200034, '1', '科技型中小企业', '', 1, '0001', '', '', 0, 'KEJIXINGZHONGXIAOQIYE KJXZXQY', '');
INSERT INTO `common_dictionary` VALUES ('0GDB9Y6RC5P3K3QFXBTF', 200034, '2', '国家高新技术企业', '', 2, '0002', '', '', 0, 'GUOJIAGAOXINJISHUQIYE GJGXJSQY', '');
INSERT INTO `common_dictionary` VALUES ('0GDB9YBMJK73K3QN5D8P', 200034, '3', '瞪羚企业', '', 3, '0003', '', '', 0, 'DENGLINGQIYE DLQY', '');
INSERT INTO `common_dictionary` VALUES ('0GDB9YMNB7M3K3QLUO3T', 200034, '5', '专精特新中小企业', '', 5, '0005', '', '', 0, 'ZHUANJINGTEXINZHONGXIAOQIYE ZJTXZXQY', '');
INSERT INTO `common_dictionary` VALUES ('0GDB9YWBVT93K3Q9NZOD', 200034, '4', '专精特新小巨人', '', 4, '0004', '', '', 0, 'ZHUANJINGTEXINXIAOJUREN ZJTXXJR', '');
INSERT INTO `common_dictionary` VALUES ('0GDB9ZVK1MG3K3Q6OE7R', 200034, '6', '制造业单项冠军', '', 6, '0006', '', '', 0, 'ZHIZAOYEDANXIANGGUANJUN ZZYDXGJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA05FWMK3K3QX7ZQW', 200034, '7', '其他', '', 7, '0007', '', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA6M23BS3K3QTERMM', 200035, '1', 'I类', '', 1, '0001', '', '', 0, 'ILEI IL', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA6Q330Z3K3QWRF7Y', 200035, '2', 'II类', '', 2, '0002', '', '', 0, 'IILEI IIL', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA6VXPM43K3QIFNJF', 200035, '3', '其他', '', 3, '0003', '', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA7RDZBY3K3QASLN2', 200036, '1', '中青年科技创新领军人才', '', 1, '0001', '', '', 0, 'ZHONGQINGNIANKEJICHUANGXINLINGJUNRENCAI ZQNKJCXLJRC', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA7WE14T3K3QKUHCN', 200036, '2', '科技创新创业人才', '', 2, '0002', '', '', 0, 'KEJICHUANGXINCHUANGYERENCAI KJCXCYRC', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA82DIVU3K3QGZCGT', 200036, '3', '青年科技新星', '', 3, '0003', '', '', 0, 'QINGNIANKEJIXINXING QNKJXX', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA874NU23K3Q9QYVB', 200036, '4', '科学家+工程师队伍', '', 4, '0004', '', '', 0, 'KEXUEJIA+GONGCHENGSHIDUIWU KXJ+GCSDW', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA8JCQ1S3K3QGK68R', 200036, '5', '硬科技创新人才', '', 5, '0005', '', '', 0, 'YINGKEJICHUANGXINRENCAI YKJCXRC', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA8QZPOW3K3QN2M1W', 200036, '6', '高校毕业生', '', 6, '0006', '', '', 0, 'GAOXIAOBIYESHENG GXBYS', '');
INSERT INTO `common_dictionary` VALUES ('0GDBA8W68XU3K3QWDMJ1', 200036, '7', '其他', '', 7, '0007', '', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GDCDWDOCN13K3QBL84Y', 200040, '6', '政策申报系统', '', 11, '0011', '', '', 0, 'ZHENGCESHENBAOXITONG ZCSBXT', '');
INSERT INTO `common_dictionary` VALUES ('0GDJD8JF54O3K3Q7EZ06', 200037, '1', '经营场所公示', '', 1, '0001', '', '', 0, 'JINGYINGCHANGSUOGONGSHI JYCSGS', '');
INSERT INTO `common_dictionary` VALUES ('0GDJE2IUSAM3K3QIVBPH', 200037, '2', '认定结果公示', '', 3, '0003', '', '', 0, 'RENDINGJIEGUOGONGSHI RDJGGS', '');
INSERT INTO `common_dictionary` VALUES ('0GDJE2N087J3K3QRWIFL', 200037, '3', '注销公示', '', 5, '0005', '', '', 0, 'ZHUXIAOGONGSHI ZXGS', '');
INSERT INTO `common_dictionary` VALUES ('0GDKDL7B6IT3K3QCOQG1', 200038, '1', '企业发展基本情况表', '', 1, '0001', '', '', 0, 'QIYEFAZHANJIBENQINGKUANGBIAO QYFZJBQKB', '');
INSERT INTO `common_dictionary` VALUES ('0GDKDLHMEIS3K3QG948L', 200038, '2', '技术合同登记奖励申请', '', 2, '0002', '', '', 0, 'JISHUHETONGDENGJIJIANGLISHENQING JSHTDJJLSQ', '');
INSERT INTO `common_dictionary` VALUES ('0GDKDLQG4623K3QK3JWF', 200038, '3', '省重点研发计划项目（科技创新助企纾困类）', '', 3, '0003', '', '', 0, 'SHENGZHONGDIANYANFAJIHUAXIANGMU（KEJICHUANGXINZHUQISHUKUNLEI） SZDYFJHXM（KJCXZQSKL）', '');
INSERT INTO `common_dictionary` VALUES ('0GDKDM268OW3K3Q5741B', 200038, '4', '高新技术企业认定奖励资金申请表', '', 4, '0004', '', '', 0, 'GAOXINJISHUQIYERENDINGJIANGLIZIJINSHENQINGBIAO GXJSQYRDJLZJSQB', '');
INSERT INTO `common_dictionary` VALUES ('0GDLF6RV3DT3K3QVE60D', 200070, '1', '重大科技基础设施', '', 1, '0001', '', '', 0, 'ZHONGDAKEJIJICHUSHESHI ZDKJJCSS', '');
INSERT INTO `common_dictionary` VALUES ('0GDLF6VRZ4Q3K3QG1KHN', 200070, '2', '国家级创新中心', '', 3, '0003', '', '', 0, 'GUOJIAJICHUANGXINZHONGXIN GJJCXZX', '');
INSERT INTO `common_dictionary` VALUES ('0GDLF6Z28W23K3Q8WCNB', 200070, '3', '湖北实验室', '', 5, '0005', '', '', 0, 'HUBEISHIYANSHI HBSYS', '');
INSERT INTO `common_dictionary` VALUES ('0GDLF7209PZ3K3QHKOTQ', 200070, '4', '产业技术研究院', '', 7, '0007', '', '', 0, 'CHANYEJISHUYANJIUYUAN CYJSYJY', '');
INSERT INTO `common_dictionary` VALUES ('0GDLF75E5UJ3K3QBDI2N', 200070, '5', '中试平台', '', 9, '0009', '', '', 0, 'ZHONGSHIPINGTAI ZSPT', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQ8UYHBI3K3QSOJ16', 200039, '1', '万元', '', 1, '0001', '', '', 0, 'WANYUAN WY', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQ8ZMYXY3K3QMBRTW', 200039, '2', '兆', '', 2, '0002', '', '', 0, 'ZHAO Z', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQ945Q9H3K3QII5Y8', 200039, '3', '秒', '', 3, '0003', '', '', 0, 'MIAO M', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQ9C0A9X3K3QCFR4N', 200039, '4', '米', '', 4, '0004', '', '', 0, 'MI M', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQ9H6CXG3K3QQ2SI0', 200039, '5', '千克', '', 5, '0005', '', '', 0, 'QIANKE QK', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQOYMBRN3K3QGHY7I', 200044, '1', '创业者', '', 1, '0001', '', '', 0, 'CHUANGYEZHE CYZ', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQP4ITWO3K3Q7432E', 200044, '2', '服务机构', '', 2, '0002', '', '', 0, 'FUWUJIGOU FWJG', '');
INSERT INTO `common_dictionary` VALUES ('0GDOQPAB7M63K3Q1UZ51', 200044, '3', '投资机构', '', 3, '0003', '', '', 0, 'TOUZIJIGOU TZJG', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU2XZQY93K3QL0PCR', 200062, '1', '毛坯', '', 1, '0001', '', '', 0, 'MAOPI MP', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU3225XW3K3QXTR74', 200062, '2', '简装', '', 3, '0003', '', '', 0, 'JIANZHUANG JZ', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU3A6QBK3K3Q7CEPY', 200062, '3', '拎包入住', '', 5, '0005', '', '', 0, 'LINBAORUZHU LBRZ', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU3I7ERV3K3QOD7JP', 200063, '1', '100㎡以下', '', 1, '0001', '', '', 0, '100㎡YIXIA 100㎡YX', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU3OY2UG3K3QS3TJQ', 200063, '2', '100㎡-300㎡', '', 3, '0003', '', '', 0, '100㎡-300㎡', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU3S5BQK3K3Q7FRP7', 200063, '3', '300㎡-500㎡', '', 5, '0005', '', '', 0, '300㎡-500㎡', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU3VN7VA3K3Q84JUV', 200063, '4', '500㎡-1000㎡', '', 7, '0007', '', '', 0, '500㎡-1000㎡', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU40D4UN3K3QTWSFD', 200063, '5', '1000㎡以上', '', 9, '0009', '', '', 0, '1000㎡YISHANG 1000㎡YS', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU48VOAM3K3QYISEO', 200064, '1', '50元/月/平以内', '', 1, '0001', '', '', 0, '50YUAN/YUE/PINGYINEI 50Y/Y/PYN', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU4CKJVY3K3QEGW1N', 200064, '2', '50元/月/平~70元/月/平', '', 3, '0003', '', '', 0, '50YUAN/YUE/PING~70YUAN/YUE/PING 50Y/Y/P~70Y/Y/P', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU4FWAEJ3K3QZLI59', 200064, '3', '70元/月/平以上-90元/月/平', '', 5, '0005', '', '', 0, '70YUAN/YUE/PINGYISHANG-90YUAN/YUE/PING 70Y/Y/PYS-90Y/Y/P', '');
INSERT INTO `common_dictionary` VALUES ('0GDRU4MHLUD3K3QTHKIS', 200064, '4', '90元/月/平以上', '', 7, '0007', '', '', 0, '90YUAN/YUE/PINGYISHANG 90Y/Y/PYS', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF1HHF3K3QK5Z5F', 2001001, '0', '生物医药产业', '', 1, '0001', '0', '', 0, 'SHENGWUYIYAOCHANYE SWYYCY', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF1Q7I3K3QVGDFR', 2001001, '001', '生物医药', '0', 1, '0001.0001', '0.001', '', 0, 'SHENGWUYIYAO SWYY', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF1YGH3K3QPT7SD', 2001001, '001001', '医药研发', '001', 1, '0001.0001.0001', '0.001.001001', '', 0, 'YIYAOYANFA YYYF', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF263C3K3Q0IRLE', 2001001, '001002', '免疫医疗', '001', 3, '0001.0001.0003', '0.001.001002', '', 0, 'MIANYIYILIAO MYYL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF2ED03K3QG59CW', 2001001, '001003', '精准医疗', '001', 5, '0001.0001.0005', '0.001.001003', '', 0, 'JINGZHUNYILIAO JZYL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF2NUV3K3QU71UN', 2001001, '001004', '基因', '001', 7, '0001.0001.0007', '0.001.001004', '', 0, 'JIYIN JY', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF2W8Y3K3QGNKRO', 2001001, '001005', '组学', '001', 9, '0001.0001.0009', '0.001.001005', '', 0, 'ZUXUE ZX', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF34XB3K3QE1UXS', 2001001, '001006', 'CRO服务', '001', 11, '0001.0001.0011', '0.001.001006', '', 0, 'CROFUWU CROFW', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF3DHA3K3Q7LDVY', 2001001, '002', '医疗器械', '0', 3, '0001.0003', '0.002', '', 0, 'YILIAOQIXIE YLQX', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF3LE83K3Q96V62', 2001001, '002001', '诊断试剂', '002', 1, '0001.0003.0001', '0.002.002001', '', 0, 'ZHENDUANSHIJI ZDSJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF3TKY3K3Q5I702', 2001001, '002002', '诊断设备', '002', 3, '0001.0003.0003', '0.002.002002', '', 0, 'ZHENDUANSHEBEI ZDSB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF41R03K3QZSQA8', 2001001, '002003', '治疗设备', '002', 5, '0001.0003.0005', '0.002.002003', '', 0, 'ZHILIAOSHEBEI ZLSB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF4BDO3K3QENNEX', 2001001, '002004', '医用新材料', '002', 7, '0001.0003.0007', '0.002.002004', '', 0, 'YIYONGXINCAILIAO YYXCL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF4KW43K3QTKEF3', 2001001, '003', '其他', '0', 5, '0001.0005', '0.003', '', 0, 'QITA QT', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF4VLE3K3QF2WUX', 2001001, '003001', '互联网+医疗', '003', 1, '0001.0005.0001', '0.003.003001', '', 0, 'HULIANWANG+YILIAO HLW+YL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF54K63K3QLQW59', 2001001, '003002', '医疗大数据', '003', 3, '0001.0005.0003', '0.003.003002', '', 0, 'YILIAODASHUJU YLDSJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF5DRN3K3QAC6U2', 2001001, '003003', '生物农业', '003', 5, '0001.0005.0005', '0.003.003003', '', 0, 'SHENGWUNONGYE SWNY', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF5NVS3K3QETXBJ', 2001001, '003004', '保健品', '003', 7, '0001.0005.0007', '0.003.003004', '', 0, 'BAOJIANPIN BJP', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF5X5W3K3Q59NKC', 2001001, '003005', '医药流通', '003', 9, '0001.0005.0009', '0.003.003005', '', 0, 'YIYAOLIUTONG YYLT', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF66LP3K3QJJPXF', 2001001, '003006', '专用服务', '003', 11, '0001.0005.0011', '0.003.003006', '', 0, 'ZHUANYONGFUWU ZYFW', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF6FJL3K3Q2F8X8', 2001001, '1', '光电子产业', '', 3, '0003', '1', '', 0, 'GUANGDIANZICHANYE GDZCY', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF6O073K3Q45PV5', 2001001, '101', '芯', '1', 1, '0003.0001', '1.101', '', 0, 'XIN X', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF6YPS3K3QAJIZ1', 2001001, '101001', '材料、设备', '101', 1, '0003.0001.0001', '1.101.101001', '', 0, 'CAILIAO、SHEBEI CL、SB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF78LB3K3QOMDNV', 2001001, '101002', 'IC设计', '101', 3, '0003.0001.0003', '1.101.101002', '', 0, 'ICSHEJI ICSJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF7IYF3K3QRG64Y', 2001001, '101003', 'IC制造', '101', 5, '0003.0001.0005', '1.101.101003', '', 0, 'ICZHIZAO ICZZ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF7TWJ3K3QKDK7P', 2001001, '101004', '封装测试', '101', 7, '0003.0001.0007', '1.101.101004', '', 0, 'FENGZHUANGCESHI FZCS', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF840Y3K3QW7DIA', 2001001, '102', '屏', '1', 3, '0003.0003', '1.102', '', 0, 'PING P', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF8FJD3K3QMQIIM', 2001001, '102001', '生产设备', '102', 1, '0003.0003.0001', '1.102.102001', '', 0, 'SHENGCHANSHEBEI SCSB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF8OLH3K3QWJT2Q', 2001001, '102002', '基础材料', '102', 3, '0003.0003.0003', '1.102.102002', '', 0, 'JICHUCAILIAO JCCL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF8YII3K3Q9BHXI', 2001001, '102003', '显示屏制造', '102', 5, '0003.0003.0005', '1.102.102003', '', 0, 'XIANSHIPINGZHIZAO XSPZZ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF99233K3Q5ZA2E', 2001001, '102004', '显示屏检测', '102', 7, '0003.0003.0007', '1.102.102004', '', 0, 'XIANSHIPINGJIANCE XSPJC', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF9IUO3K3QAC8EN', 2001001, '103', '端', '1', 5, '0003.0005', '1.103', '', 0, 'DUAN D', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLF9SXR3K3Q461H9', 2001001, '103001', '工业物联网', '103', 1, '0003.0005.0001', '1.103.103001', '', 0, 'GONGYEWULIANWANG GYWLW', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFA2XU3K3QYAM3Y', 2001001, '103002', '智慧城市', '103', 3, '0003.0005.0003', '1.103.103002', '', 0, 'ZHIHUICHENGSHI ZHCS', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFACTP3K3QAUW1H', 2001001, '103003', '智能网联汽车', '103', 5, '0003.0005.0005', '1.103.103003', '', 0, 'ZHINENGWANGLIANQICHE ZNWLQC', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFANMO3K3QWX5CL', 2001001, '103004', '机器人', '103', 7, '0003.0005.0007', '1.103.103004', '', 0, 'JIQIREN JQR', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFAY7J3K3QABT4Y', 2001001, '103005', '智能装备', '103', 9, '0003.0005.0009', '1.103.103005', '', 0, 'ZHINENGZHUANGBEI ZNZB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFB8HR3K3QW0E77', 2001001, '103006', '专用装备', '103', 11, '0003.0005.0011', '1.103.103006', '', 0, 'ZHUANYONGZHUANGBEI ZYZB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFBIVX3K3QQSGFF', 2001001, '104', '网', '1', 7, '0003.0007', '1.104', '', 0, 'WANG W', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFBT2Q3K3QBKGVF', 2001001, '104001', '大数据', '104', 1, '0003.0007.0001', '1.104.104001', '', 0, 'DASHUJU DSJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFC3EG3K3QC8US7', 2001001, '104002', '云计算', '104', 3, '0003.0007.0003', '1.104.104002', '', 0, 'YUNJISUAN YJS', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFCEHU3K3QQ47TR', 2001001, '104003', '人工智能', '104', 5, '0003.0007.0005', '1.104.104003', '', 0, 'RENGONGZHINENG RGZN', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFCPB03K3QG3BIX', 2001001, '104004', '网络信息安全', '104', 7, '0003.0007.0007', '1.104.104004', '', 0, 'WANGLUOXINXIANQUAN WLXXAQ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFCZPY3K3QMLQ6Q', 2001001, '104005', '互联网+', '104', 9, '0003.0007.0009', '1.104.104005', '', 0, 'HULIANWANG+ HLW+', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFDAJF3K3QY503G', 2001001, '104006', '电子商务', '104', 11, '0003.0007.0011', '1.104.104006', '', 0, 'DIANZISHANGWU DZSW', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFDLWH3K3Q3T16X', 2001001, '104007', '数字创意', '104', 13, '0003.0007.0013', '1.104.104007', '', 0, 'SHUZICHUANGYI SZCY', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFDVX73K3QVTQ7X', 2001001, '104008', '软件信息', '104', 15, '0003.0007.0015', '1.104.104008', '', 0, 'RUANJIANXINXI RJXX', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFE5SD3K3QOSLCA', 2001001, '105', '光通信', '1', 9, '0003.0009', '1.105', '', 0, 'GUANGTONGXIN GTX', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFEGQK3K3QBC8J0', 2001001, '105001', '光纤光缆', '105', 1, '0003.0009.0001', '1.105.105001', '', 0, 'GUANGXIANGUANGLAN GXGL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFES093K3QAUC44', 2001001, '105002', '光器件', '105', 3, '0003.0009.0003', '1.105.105002', '', 0, 'GUANGQIJIAN GQJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFF36A3K3QLGDAO', 2001001, '105003', '系统设备', '105', 5, '0003.0009.0005', '1.105.105003', '', 0, 'XITONGSHEBEI XTSB', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFFE043K3QTRL6A', 2001001, '105004', '运营服务', '105', 7, '0003.0009.0007', '1.105.105004', '', 0, 'YUNYINGFUWU YYFW', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFFOXC3K3QGEAFK', 2001001, '106', '激光', '1', 11, '0003.0011', '1.106', '', 0, 'JIGUANG JG', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFG0A83K3QRAE2L', 2001001, '106001', '激光器', '106', 1, '0003.0011.0001', '1.106.106001', '', 0, 'JIGUANGQI JGQ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFGAPC3K3Q5OHGZ', 2001001, '106002', '设备集成', '106', 3, '0003.0011.0003', '1.106.106002', '', 0, 'SHEBEIJICHENG SBJC', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFGNL83K3QT5F7C', 2001001, '106003', '应用服务', '106', 5, '0003.0011.0005', '1.106.106003', '', 0, 'YINGYONGFUWU YYFW', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFGZJB3K3Q3UG49', 2001001, '106004', '材料元器件', '106', 7, '0003.0011.0007', '1.106.106004', '', 0, 'CAILIAOYUANQIJIAN CLYQJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFHAXT3K3Q51MP7', 2001001, '107', '地球空间信息', '1', 13, '0003.0013', '1.107', '', 0, 'DIQIUKONGJIANXINXI DQKJXX', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFHN683K3QEA85S', 2001001, '107001', '数据采集', '107', 1, '0003.0013.0001', '1.107.107001', '', 0, 'SHUJUCAIJI SJCJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFHYIM3K3QJN08J', 2001001, '107002', '数据处理', '107', 3, '0003.0013.0003', '1.107.107002', '', 0, 'SHUJUCHULI SJCL', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFIA0W3K3QA0ILC', 2001001, '107003', '地图导航', '107', 5, '0003.0013.0005', '1.107.107003', '', 0, 'DITUDAOHANG DTDH', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFIO4F3K3QATTZO', 2001001, '107004', '测绘', '107', 7, '0003.0013.0007', '1.107.107004', '', 0, 'CEHUI CH', '');
INSERT INTO `common_dictionary` VALUES ('0GDWHLFIZQ83K3QNNDWQ', 2001001, '107005', '行业应用', '107', 9, '0003.0013.0009', '1.107.107005', '', 0, 'XINGYEYINGYONG XYYY', '');
INSERT INTO `common_dictionary` VALUES ('0GDXKOKXDJ43K3Q57RJ2', 200045, '1', '027-67886052', '', 1, '0001', '', '', 0, '027-67886052', '');
INSERT INTO `common_dictionary` VALUES ('0GDXKOVJK9H3K3QDASN9', 200046, '1', '暂无', '', 1, '0001', '', '', 0, 'ZANWU ZW', '');
INSERT INTO `common_dictionary` VALUES ('0GDYROUJISS3K3QTAULJ', 200047, '1', '同意审批', '', 1, '0001', '', '', 0, 'TONGYISHENPI TYSP', '');
INSERT INTO `common_dictionary` VALUES ('0GDYRP0Q6NO3K3Q2HCNM', 200047, '2', '资料上传不完成，补充资料再提交', '', 2, '0002', '', '', 0, 'ZILIAOSHANGCHUANBUWANCHENG，BUCHONGZILIAOZAITIJIAO ZLSCBWC，BCZLZTJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDYRP7FJJF3K3QNX7RV', 200047, '3', '不满足申报条件', '', 3, '0003', '', '', 0, 'BUMANZUSHENBAOTIAOJIAN BMZSBTJ', '');
INSERT INTO `common_dictionary` VALUES ('0GDYRPDZYNW3K3Q95585', 200047, '4', '资料信息有误', '', 4, '0004', '', '', 0, 'ZILIAOXINXIYOUWU ZLXXYW', '');
INSERT INTO `common_dictionary` VALUES ('251E3BE4AF1D4397BDF4', 3101, '60', '雷视设备', NULL, 1, '0018', '11', NULL, 0, 'LEISHISHEBEI LSSB', NULL);
INSERT INTO `common_dictionary` VALUES ('36D67F66AEBF4DF481C9', 3101, '6002', '雷视', '60', 2, '0018.0002', '11.1102', NULL, 0, 'SHIJUE SJ', NULL);
INSERT INTO `common_dictionary` VALUES ('6284D2496D234CC386D3', 3101, '6001', '雷达', '60', 1, '0018.0001', '11.1101', NULL, 0, 'LEIDA LD', NULL);
INSERT INTO `common_dictionary` VALUES ('65D15AA1FB9747CFA911', 3101, '70', '边缘计算', NULL, 1, '0019', '12', NULL, 0, 'BIANYUANJISUAN BYJS', NULL);
INSERT INTO `common_dictionary` VALUES ('AD323A50E90B4BB0ACE0', 3101, '0960', '移动设备', '09', 6, '0001.0006', '09.0960', NULL, 0, 'YIDONGSHEBEI YDSB', NULL);
INSERT INTO `common_dictionary` VALUES ('KFHDJ3G4CK31XTUHT0FQ', 3013, '1', '视频结构化', NULL, 1, '0001', '', NULL, 0, 'SHIPINJIEGOUHUA SPJGH', NULL);
INSERT INTO `common_dictionary` VALUES ('KFHDJ3L10JT1XTURX3CG', 3013, '3', '交通事件和违法', NULL, 3, '0003', '', NULL, 0, 'JIAOTONGSHIJIANHEWEIFA JTSJHWF', NULL);
INSERT INTO `common_dictionary` VALUES ('KG7T0BLVPI31XTUSAJN1', 3013, '2', '以图检索', '', 2, '0002', '', '', 0, 'YITUJIANSUO YTJS', '');

-- ----------------------------
-- Table structure for common_dictionary_category
-- ----------------------------
DROP TABLE IF EXISTS `common_dictionary_category`;
CREATE TABLE IF NOT EXISTS `common_dictionary_category`  (
  `CATEGORYID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分类id-主键',
  `CATEGORYNAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类名称',
  `SHOWORDER` decimal(8, 0) NULL DEFAULT NULL COMMENT '显示顺序',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `BOPOMOFO` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拼音',
  PRIMARY KEY (`CATEGORYID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '字典分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of common_dictionary_category
-- ----------------------------
INSERT INTO `common_dictionary_category` VALUES ('0GAIAWTSUJU1XTUDSU7E', '企业创新积分', 26, 'admin', '2022-06-07 20:25:13', NULL, NULL, '东湖高新科创局-企业创新积分系统', 'QIYECHUANGXINJIFEN QYCXJF');
INSERT INTO `common_dictionary_category` VALUES ('0GB0RTW9J141XTUTAILY', '创新券系统', 28, 'liuy', '2022-06-24 14:28:16', NULL, NULL, NULL, 'CHUANGXINQUANXITONG CXQXT');

-- ----------------------------
-- Table structure for common_dictionary_type
-- ----------------------------
DROP TABLE IF EXISTS `common_dictionary_type`;
CREATE TABLE IF NOT EXISTS `common_dictionary_type`  (
  `DICTIONARYTYPEID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典类型id-主键',
  `CATEGORYID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典分类id',
  `DICTIONARYTYPENAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典类型名称',
  `KIND` decimal(8, 0) NOT NULL COMMENT '字典枚举（与字典表 kind 内容一致），以此字段来区分不同的字典类型',
  `SHOWORDER` decimal(8, 0) NULL DEFAULT NULL COMMENT '显示顺序',
  `SHOWTYPE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'grid' COMMENT '字典展示类型 grid：列表 tree：树形结构',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `BOPOMOFO` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拼音',
  PRIMARY KEY (`DICTIONARYTYPEID`) USING BTREE,
  UNIQUE INDEX `IX_KIND`(`KIND`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of common_dictionary_type
-- ----------------------------
INSERT INTO `common_dictionary_type` VALUES ('0GAJ0HEIIQ71XTUP6PI3', '0GAIAWTSUJU1XTUDSU7E', '企业类型', 200001, 1, 'grid', 'admin', '2022-06-08 11:52:57', NULL, NULL, '企业类型', 'QIYELEIXING QYLX');
INSERT INTO `common_dictionary_type` VALUES ('0GAJ6PJFUVC1XTU0I133', '0GAIAWTSUJU1XTUDSU7E', '行业类型', 200002, 2, 'grid', 'admin', '2022-06-08 15:38:49', NULL, NULL, '行业类型', 'XINGYELEIXING XYLX');
INSERT INTO `common_dictionary_type` VALUES ('0GAJ6W26JRH1XTUMN57N', '0GAIAWTSUJU1XTUDSU7E', '登记状态', 200003, 3, 'grid', 'admin', '2022-06-08 15:45:24', NULL, NULL, '登记状态', 'DENGJIZHUANGTAI DJZT');
INSERT INTO `common_dictionary_type` VALUES ('0GAJ70431N81XTUXCTG8', '0GAIAWTSUJU1XTUDSU7E', '成长阶段', 200004, 4, 'grid', 'admin', '2022-06-08 15:49:29', NULL, NULL, '成长阶段', 'CHENGZHANGJIEDUAN CZJD');
INSERT INTO `common_dictionary_type` VALUES ('0GAK2D6TEUT1XTUIA5HW', '0GAIAWTSUJU1XTUDSU7E', '科创属性', 200005, 5, 'grid', 'admin', '2022-06-09 10:47:20', NULL, NULL, '科创属性', 'KECHUANGSHUXING KCSX');
INSERT INTO `common_dictionary_type` VALUES ('0GAK3N4JH741XTU33HYD', '0GAIAWTSUJU1XTUDSU7E', '指标内容', 200006, 6, 'grid', 'liuy', '2022-06-09 11:33:37', NULL, NULL, '指标内容', 'ZHIBIAONEIRONG ZBNR');
INSERT INTO `common_dictionary_type` VALUES ('0GAPZBU6NG41XTUOW3IL', '0GAIAWTSUJU1XTUDSU7E', '企业详情头部信息', 200000, 7, 'tree', 'admin', '2022-06-14 19:33:33', NULL, NULL, '企业详情头部信息', 'QIYEXIANGQINGTOUBUXINXI QYXQTBXX');
INSERT INTO `common_dictionary_type` VALUES ('0GAQPGOFC8R1XTUCCJ7N', '0GAIAWTSUJU1XTUDSU7E', '融资信息', 200008, 8, 'grid', 'admin', '2022-06-15 11:21:42', NULL, NULL, '融资信息', 'RONGZIXINXI RZXX');
INSERT INTO `common_dictionary_type` VALUES ('0GAQPUH6ZXQ1XTUHX0YU', '0GAIAWTSUJU1XTUDSU7E', '上市状态', 200009, 9, 'grid', 'admin', '2022-06-15 11:35:36', NULL, NULL, '上市状态', 'SHANGSHIZHUANGTAI SSZT');
INSERT INTO `common_dictionary_type` VALUES ('0GB0RUXQYIM1XTUNPO1L', '0GB0RTW9J141XTUTAILY', '额度配置', 2001301, 1, 'grid', 'liuy', '2022-06-24 14:29:19', NULL, NULL, '额度配置', 'EDUPEIZHI EDPZ');
INSERT INTO `common_dictionary_type` VALUES ('0GB47SK8XXO1XTUMB83S', '0GAIAWTSUJU1XTUDSU7E', '产业领域', 200007, 10, 'grid', 'admin', '2022-06-27 17:25:36', NULL, NULL, '200007', 'CHANYELINGYU CYLY');
INSERT INTO `common_dictionary_type` VALUES ('0GB5CTUFV071XTU82QKL', '0GB0RTW9J141XTUTAILY', '服务项目-服务类别', 2001302, 2, 'grid', 'admin', '2022-06-28 18:14:22', NULL, NULL, '服务项目-服务类别', 'FUWUXIANGMU-FUWULEIBIE FWXM-FWLB');
INSERT INTO `common_dictionary_type` VALUES ('0GB5CU5RZ1O1XTU9M2ST', '0GB0RTW9J141XTUTAILY', '服务项目-服务范围', 2001303, 3, 'grid', 'admin', '2022-06-28 18:14:41', NULL, NULL, '服务项目-服务范围', 'FUWUXIANGMU-FUWUFANWEI FWXM-FWFW');
INSERT INTO `common_dictionary_type` VALUES ('0GB7FPCWXTZ1XTUL8XCE', '0GB0RTW9J141XTUTAILY', '机构类型', 2001304, 4, 'grid', 'liuy', '2022-06-30 15:30:49', NULL, NULL, '', 'JIGOULEIXING JGLX');
INSERT INTO `common_dictionary_type` VALUES ('0GBJOYLDPV61XTUSHWMM', '0GAIAWTSUJU1XTUDSU7E', '所属园区', 200010, 11, 'grid', 'admin', '2022-07-11 18:19:29', NULL, NULL, '', 'SUOSHUYUANQU SSYQ');
INSERT INTO `common_dictionary_type` VALUES ('0GBUQP0M8N61XTUF9PTS', '0GAIAWTSUJU1XTUDSU7E', '银行机构LOGO', 2001401, 12, 'grid', 'chenl', '2022-07-21 18:49:09', NULL, NULL, '银行机构LOGO', 'YINXINGJIGOULOGO YXJGLOGO');
INSERT INTO `common_dictionary_type` VALUES ('0GCA6V7H5QT1XTUDHMNQ', '0GAIAWTSUJU1XTUDSU7E', '政策服务-政策地域', 200030, 13, 'grid', 'admin', '2022-08-04 19:06:54', NULL, NULL, '', 'ZHENGCEFUWU-ZHENGCEDIYU ZCFW-ZCDY');
INSERT INTO `common_dictionary_type` VALUES ('0GCA6VP1MNT1XTUH4QLK', '0GAIAWTSUJU1XTUDSU7E', '政策服务-行业分类', 200031, 14, 'grid', 'admin', '2022-08-04 19:07:24', NULL, NULL, '', 'ZHENGCEFUWU-XINGYEFENLEI ZCFW-XYFL');
INSERT INTO `common_dictionary_type` VALUES ('0GCA6VZX1XQ1XTUEIMO4', '0GAIAWTSUJU1XTUDSU7E', '政策服务-发布单位', 200032, 15, 'grid', 'admin', '2022-08-04 19:07:42', NULL, NULL, '', 'ZHENGCEFUWU-FABUDANWEI ZCFW-FBDW');
INSERT INTO `common_dictionary_type` VALUES ('0GCGO6XO1231XTUP6QTL', '0GAIAWTSUJU1XTUDSU7E', '企业报表指标-数据来源', 200040, 16, 'grid', 'chenl', '2022-08-10 16:11:54', NULL, NULL, '', 'QIYEBAOBIAOZHIBIAO-SHUJULAIYUAN QYBBZB-SJLY');
INSERT INTO `common_dictionary_type` VALUES ('0GCGO7FEJ9Q1XTUAOJS2', '0GAIAWTSUJU1XTUDSU7E', '企业报表指标-企业经营数据', 200041, 17, 'grid', 'chenl', '2022-08-10 16:12:24', NULL, NULL, '', 'QIYEBAOBIAOZHIBIAO-QIYEJINGYINGSHUJU QYBBZB-QYJYSJ');
INSERT INTO `common_dictionary_type` VALUES ('0GCGO7OMLJP1XTUZBHJS', '0GAIAWTSUJU1XTUDSU7E', '企业报表指标-企业创新数据', 200042, 18, 'grid', 'chenl', '2022-08-10 16:12:39', NULL, NULL, '', 'QIYEBAOBIAOZHIBIAO-QIYECHUANGXINSHUJU QYBBZB-QYCXSJ');
INSERT INTO `common_dictionary_type` VALUES ('0GCGO7ZK3EL1XTUJBGDY', '0GAIAWTSUJU1XTUDSU7E', '企业报表指标-企业人员数据', 200043, 19, 'grid', 'chenl', '2022-08-10 16:12:57', NULL, NULL, '', 'QIYEBAOBIAOZHIBIAO-QIYERENYUANSHUJU QYBBZB-QYRYSJ');
INSERT INTO `common_dictionary_type` VALUES ('0GCHK1E9J0A1XTU2PZWW', '0GB0RTW9J141XTUTAILY', '兑付状态', 2001305, 5, 'grid', 'liuy', '2022-08-11 11:27:16', NULL, NULL, '', 'DUIFUZHUANGTAI DFZT');
INSERT INTO `common_dictionary_type` VALUES ('0GCW6EY5JF01XTUJAKXK', '0GAIAWTSUJU1XTUDSU7E', '企业性质', 200011, 12, 'grid', 'liuy', '2022-08-24 17:44:03', NULL, NULL, '', 'QIYEXINGZHI QYXZ');
INSERT INTO `common_dictionary_type` VALUES ('0GCZCC154F51XTUH3WGO', '0GB0RTW9J141XTUTAILY', '公示类型', 2001306, 6, 'grid', 'liuy', '2022-08-27 14:37:00', NULL, NULL, '', 'GONGSHILEIXING GSLX');
INSERT INTO `common_dictionary_type` VALUES ('0GD2Q4UW3H91XTU599LO', '0GAIAWTSUJU1XTUDSU7E', '企业监控-企业分类', 200050, 21, 'tree', 'liuy', '2022-08-30 16:15:53', NULL, NULL, '', 'QIYEJIANKONG-QIYEFENLEI QYJK-QYFL');
INSERT INTO `common_dictionary_type` VALUES ('0GD9FHU3WDV3K3QZC16Y', '0GAIAWTSUJU1XTUDSU7E', '纳税人资质', 200012, 12, 'grid', 'liuy', '2022-09-05 18:12:23', NULL, NULL, '', 'NASHUIRENZIZHI NSRZZ');
INSERT INTO `common_dictionary_type` VALUES ('0GDAGIRTOX03K3QYI7JR', '0GAIAWTSUJU1XTUDSU7E', '双创空间-场地类型', 200060, 23, 'grid', 'liuy', '2022-09-06 16:35:40', NULL, NULL, '', 'SHUANGCHUANGKONGJIAN-CHANGDILEIXING SCKJ-CDLX');
INSERT INTO `common_dictionary_type` VALUES ('0GDAGJTLLDS3K3QBEAKN', '0GAIAWTSUJU1XTUDSU7E', '双创空间-场地级别', 200061, 24, 'grid', 'liuy', '2022-09-06 16:36:44', NULL, NULL, '', 'SHUANGCHUANGKONGJIAN-CHANGDIJIBIE SCKJ-CDJB');
INSERT INTO `common_dictionary_type` VALUES ('0GDAJ4F39A13K3QJRAUG', '0GAIAWTSUJU1XTUDSU7E', '政策服务-政策类型', 200033, 25, 'grid', 'liuy', '2022-09-06 18:10:03', NULL, NULL, '', 'ZHENGCEFUWU-ZHENGCELEIXING ZCFW-ZCLX');
INSERT INTO `common_dictionary_type` VALUES ('0GDB9WE41HL3K3QGGYJF', '0GAIAWTSUJU1XTUDSU7E', '政策匹配-企业资质', 200034, 26, 'grid', 'liuy', '2022-09-07 10:21:30', NULL, NULL, '', 'ZHENGCEPIPEI-QIYEZIZHI ZCPP-QYZZ');
INSERT INTO `common_dictionary_type` VALUES ('0GDBA559O873K3QI2FKI', '0GAIAWTSUJU1XTUDSU7E', '知识产权', 200035, 27, 'grid', 'liuy', '2022-09-07 10:30:20', NULL, NULL, '', 'ZHISHICHANQUAN ZSCQ');
INSERT INTO `common_dictionary_type` VALUES ('0GDBA7K8LKT3K3QCZ8P0', '0GAIAWTSUJU1XTUDSU7E', '政策匹配-人才资质', 200036, 28, 'grid', 'liuy', '2022-09-07 10:32:46', NULL, NULL, '', 'ZHENGCEPIPEI-RENCAIZIZHI ZCPP-RCZZ');
INSERT INTO `common_dictionary_type` VALUES ('0GDJD7VC8JO3K3QTA7G7', '0GAIAWTSUJU1XTUDSU7E', '政策通知-过滤字段', 200037, 30, 'grid', 'liuy', '2022-09-14 18:30:28', NULL, NULL, '', 'ZHENGCETONGZHI-GUOLVZIDUAN ZCTZ-GLZD');
INSERT INTO `common_dictionary_type` VALUES ('0GDKDKN79XB3K3QIS1UH', '0GAIAWTSUJU1XTUDSU7E', '政策申报-表单管理', 200038, 31, 'grid', 'liuy', '2022-09-15 16:29:25', NULL, NULL, '', 'ZHENGCESHENBAO-BIAODANGUANLI ZCSB-BDGL');
INSERT INTO `common_dictionary_type` VALUES ('0GDLF68TDQ03K3Q1D938', '0GAIAWTSUJU1XTUDSU7E', '科技创新平台-平台类型', 200070, 24, 'grid', 'liuy', '2022-09-16 15:13:32', NULL, NULL, '', 'KEJICHUANGXINPINGTAI-PINGTAILEIXING KJCXPT-PTLX');
INSERT INTO `common_dictionary_type` VALUES ('0GDOQ8EG11D3K3QSDS95', '0GAIAWTSUJU1XTUDSU7E', '政策申报-计量单位', 200039, 32, 'grid', 'liuy', '2022-09-19 15:12:59', NULL, NULL, '', 'ZHENGCESHENBAO-JILIANGDANWEI ZCSB-JLDW');
INSERT INTO `common_dictionary_type` VALUES ('0GDOQONC1NA3K3Q7OHKO', '0GAIAWTSUJU1XTUDSU7E', '政策匹配-支持对象', 200044, 33, 'grid', 'liuy', '2022-09-19 15:29:22', NULL, NULL, '', 'ZHENGCEPIPEI-ZHICHIDUIXIANG ZCPP-ZCDX');
INSERT INTO `common_dictionary_type` VALUES ('0GDRTWDXMOI3K3QRC0LM', '0GAIAWTSUJU1XTUDSU7E', '双创空间需求-装修需求', 200062, 34, 'grid', 'liuy', '2022-09-22 10:44:12', NULL, NULL, '', 'SHUANGCHUANGKONGJIANXUQIU-ZHUANGXIUXUQIU SCKJXQ-ZXXQ');
INSERT INTO `common_dictionary_type` VALUES ('0GDRTWXQAN03K3Q1AINJ', '0GAIAWTSUJU1XTUDSU7E', '双创空间需求-面积需求', 200063, 35, 'grid', 'liuy', '2022-09-22 10:44:46', NULL, NULL, '', 'SHUANGCHUANGKONGJIANXUQIU-MIANJIXUQIU SCKJXQ-MJXQ');
INSERT INTO `common_dictionary_type` VALUES ('0GDRTXII9WW3K3QA8BJV', '0GAIAWTSUJU1XTUDSU7E', '双创空间需求-价格需求', 200064, 36, 'grid', 'liuy', '2022-09-22 10:45:21', NULL, NULL, '', 'SHUANGCHUANGKONGJIANXUQIU-JIAGEXUQIU SCKJXQ-JGXQ');
INSERT INTO `common_dictionary_type` VALUES ('0GDRU7U41BB3K3QT6RUO', '0GAIAWTSUJU1XTUDSU7E', '政策申报-咨询热线 ', 200045, 37, 'grid', 'liuy', '2022-09-22 10:55:45', NULL, NULL, '', 'ZHENGCESHENBAO-ZIXUNREXIAN  ZCSB-ZXRX ');
INSERT INTO `common_dictionary_type` VALUES ('0GDRU8203BN3K3QY0N3Y', '0GAIAWTSUJU1XTUDSU7E', '政策申报-咨询QQ', 200046, 38, 'grid', 'liuy', '2022-09-22 10:55:58', NULL, NULL, '', 'ZHENGCESHENBAO-ZIXUNQQ ZCSB-ZXQQ');
INSERT INTO `common_dictionary_type` VALUES ('0GDWGM8YUJT3K3QWNOLH', '0GAIAWTSUJU1XTUDSU7E', '产业链-产业链类型', 2001001, 39, 'tree', 'liuy', '2022-09-26 15:32:42', NULL, NULL, '', 'CHANYELIANLEIXING CYLLX');

-- ----------------------------
-- Table structure for common_userconfig
-- ----------------------------
DROP TABLE IF EXISTS `common_userconfig`;
CREATE TABLE IF NOT EXISTS `common_userconfig`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `USERCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户code',
  `TYPE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置项分类',
  `PROFILE` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置项值',
  `EXT` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '拓展字段',
  `EXT1` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '拓展字段1',
  `CREATEDTIME` datetime(0) NOT NULL DEFAULT current_timestamp(0) COMMENT '创建时间',
  `REMARK` varchar(400) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `SORTCODE` decimal(5, 0) NULL DEFAULT 1 COMMENT '排序编码',
  `NAME` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IX_USERCONFIG_CODE_TYPE`(`TYPE`, `USERCODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户个性化配置信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of common_userconfig
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_app
-- ----------------------------
DROP TABLE IF EXISTS `oauth_app`;
CREATE TABLE IF NOT EXISTS `oauth_app`  (
  `APPID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用Id',
  `APPKEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用密钥',
  `APPNAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用名称',
  `APPURL` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '提供方首页',
  `CALLBACKURL` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '网站回调域 多个以逗号隔开',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用描述',
  `PROVIDER` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用提供方',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`APPID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '应用接入表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of oauth_app
-- ----------------------------
INSERT INTO `oauth_app` VALUES ('0GD2RGKG3UR3K3QZF7D5', '6c288e98530448ee9dcebb865377a3c9', '统一认证登录', 'http://innovc.wehdz.gov.cn/', 'http://innovc.wehdz.gov.cn/', '武汉政务网统一认证登录', '武汉政务网统一认证登录', 'liuy', '2022-08-30 17:03:58', NULL, NULL);

-- ----------------------------
-- Table structure for oauth_token_app
-- ----------------------------
DROP TABLE IF EXISTS `oauth_token_app`;
CREATE TABLE IF NOT EXISTS `oauth_token_app`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `ACCESS_TOKEN` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'access token信息',
  `EXPIRES_TIME` datetime(0) NULL DEFAULT NULL COMMENT '过期时间',
  `REFRESH_TOKEN` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'refresh_token',
  `APPNO` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用编号',
  `USERCODE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '绑定用户',
  `THIRDUSERCODE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方应用账号',
  `THIRDUSERNAME` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方应用账号名称',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IDX_OUATH_APPNO_USERGUID`(`USERCODE`, `APPNO`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '第三方应用对应oauth token信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of oauth_token_app
-- ----------------------------

-- ----------------------------
-- Table structure for oauth_token_store
-- ----------------------------
DROP TABLE IF EXISTS `oauth_token_store`;
CREATE TABLE IF NOT EXISTS `oauth_token_store`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `CODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'code信息',
  `EXPIRES_TIME` datetime(0) NOT NULL COMMENT '过期时间',
  `CATEGORY` varchar(501) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'access_token,authorization_code',
  `USERGUID` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '绑定用户',
  `CODEEXT` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'code对应json',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IDX_OUATHSTORE_CODE_CATEGORY`(`CATEGORY`, `CODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'token code存储表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of oauth_token_store
-- ----------------------------

-- ----------------------------
-- Table structure for sys_action
-- ----------------------------
DROP TABLE IF EXISTS `sys_action`;
CREATE TABLE IF NOT EXISTS `sys_action`  (
  `ACTIONGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '动作GUID',
  `FUNCTIONCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能代码',
  `ACTIONCODE` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '动作代码',
  `ACTIONNAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '动作名称',
  `COMMENTS` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '说明',
  PRIMARY KEY (`ACTIONGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '动作表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_action
-- ----------------------------
INSERT INTO `sys_action` VALUES ('0F4455Q1T6M2FORU3GC3', '00010604', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F4456481XM2FORSNSLD', '00010605', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F450JO4FHL2FORQ6BT9', '000103', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F450JO4FHR2FORDU8T5', '000103', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0F450JO4FHS2FORN501', '000103', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0F450JO4FHU2FORP9Z02', '000103', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0F450KZF3L42FORV6LM7', '000101', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F450KZF3LA2FORLJ856', '000101', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0F450KZF3LB2FOR03M5I', '000101', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0F450KZF3LD2FORFKGPE', '000101', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0F450LJYSG32FORHKOUE', '000105', '01', '新增字典项', NULL);
INSERT INTO `sys_action` VALUES ('0F450LJYSG42FOR8TCQ4', '000105', '02', '编辑字典项', NULL);
INSERT INTO `sys_action` VALUES ('0F450LJYSG62FORWCN5', '000105', '03', '删除字典项', NULL);
INSERT INTO `sys_action` VALUES ('0F4RAF551WV2FORKWOBN', '000105', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F5SHOTCAU23275GVIEP', '000107', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F677XP1CFH3275E5AAF', '000108', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F6Q5FL7XFS3275K4UQR', '0014001', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F6Q5GSIZL132754V8OC', '0014002', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F6Q5I7E0JR3275JFLTS', '0014003', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F6V6QZTJTOAD3AH9532', '00010901', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0F6V6RALO9EAD3A7XCVR', '00010902', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FAYXV5ISJA9TZSLUDIT', '001505', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FB5GW9PIAL9TZSYOM5P', '000102', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FB5GW9PIBO9TZSODAUQ', '000102', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FB5GW9PIBP9TZS09IPE', '000102', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FB5GW9PIBT9TZS6ID17', '000102', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FBC4X8V9VG9TZSO658M', '000102', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FBJ1KO1IJR9TZSTUNBP', '000401', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FBJ1KO1IJU9TZSP624V', '000401', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FBJ1KO1IJV9TZS0QVDE', '000401', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FBJ1KO1IJW9TZS7ZAT2', '000401', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FD3B4TYVZD18WBZVOQB', '001505', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FDM27YEVQW3ZJ2T6E6V', '1111111111111111', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FET4PHESU781SG7NJPX', '00100201', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FET4QESWJ781SGP87EV', '00100201', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FET4QESWJB81SG3E1QX', '00100201', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FET4QESWJC81SGREQG0', '00100201', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FET4QESWJD81SGXRDCP', '00100201', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FET4QR9IDY81SGZ6W2Z', '00100202', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLCVH184J1XTUNKEXF', '00120201', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLCWBS1IG1XTURRU3Q', '00120202', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLCWSJ4QW1XTUVLLMS', '00120203', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLCYOIYM71XTUJ8HEM', '00120204', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLD1SYAZE1XTUAJLO0', '001204', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLD332DCC1XTUNCUFJ', '00120401', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLD3CVEFO1XTUTRXC6', '00120402', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLDLTE3Y91XTUJJKSJ', '001201', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFLDMIDBLD1XTUMOGE6', '001203', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FFVNX2NQ3I1XTUTE1DF', '001301', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FG3AKZW5A61XTU2DXDP', '000111', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FG6NDUNQGX1XTUCCYUU', '000107', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG6NDUNQH01XTU66DDV', '000107', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FG6NDUNQH11XTU2K3MN', '000107', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG6NDUNQH21XTUGKEII', '000107', '04', '生成SQL', NULL);
INSERT INTO `sys_action` VALUES ('0FG8IYI63HY1XTUP6V03', '000108', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8IYI63I11XTU6PJVT', '000108', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FG8IYI63I21XTUZ5P03', '000108', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8J4XFLRM1XTUIN0VF', '000101', '04', '生成SQL', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YTTM1UI1XTUOX4NE', '001201', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YTTM1UM1XTUOXKCO', '001201', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YTTM1UN1XTUWYNOF', '001201', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YTTM1UO1XTUY9G26', '001201', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YTTM1UP1XTUPNHM5', '001201', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUJ3WJE1XTUMAQDX', '000103', '04', '新增成员', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUJ3WJI1XTUIY19E', '000103', '05', '删除成员', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUTRQKE1XTU8NVSZ', '00120201', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUTRQKH1XTUHK6VZ', '00120201', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUTRQKI1XTUNYLWR', '00120201', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUTRQKJ1XTU2LFA6', '00120201', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YUTRQKK1XTUV6D07', '00120201', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YVSCM5H1XTU1U3VK', '000103', '06', '权限设置', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YX97P651XTU6WWHM', '00120202', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YX97P691XTUN88M9', '00120202', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YX97P6A1XTUQJDY2', '00120202', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YX97P6B1XTUNINFG', '00120202', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YX97P6C1XTU2AJ3B', '00120202', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YXXEXHF1XTUR7TCM', '00120203', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YXXEXHI1XTUCQYEI', '00120203', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YXXEXHJ1XTU8IX2N', '00120203', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YXXEXHK1XTUOP4VK', '00120203', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YXXEXHL1XTUQUL9Q', '00120203', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YZ9F81T1XTUC0SFN', '00120204', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YZ9F81W1XTU9Z80X', '00120204', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YZ9F81X1XTUL6YS4', '00120204', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YZ9F81Y1XTUOKHHX', '00120204', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FG8YZ9F81Z1XTU44RQX', '00120204', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG8Z1GEEU01XTU0FBYU', '001203', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG8Z1GEEU31XTU2L779', '001203', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG8Z1GEEU41XTUECET2', '001203', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG8Z1GEEU51XTUNAE3H', '001203', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FG8Z1GEEU61XTU8EZ93', '001203', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG90JR0UZH1XTUQC7GD', '000111', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FG90L7KJIY1XTUT8O99', '000105', '04', '新增大类', NULL);
INSERT INTO `sys_action` VALUES ('0FG90LN240M1XTU3F3UP', '000105', '05', '新增类型', NULL);
INSERT INTO `sys_action` VALUES ('0FG90OA607H1XTUPM2UA', '000105', '06', '生成SQL', NULL);
INSERT INTO `sys_action` VALUES ('0FG90TG45FH1XTUSUGKG', '00010902', '03', '移除绑定', NULL);
INSERT INTO `sys_action` VALUES ('0FG90XCBNJN1XTUF45RJ', '00010901', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG90XCBNJQ1XTU54BK2', '00010901', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FG90XCBNJS1XTU1EHBU', '00010901', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FG9RZYLY8Y1XTULD4X7', '001505', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FG9RZYLY911XTURS95Q', '001505', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FG9RZYLY921XTUN51Y2', '001505', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FGQCEK3LZF1XTUJQF0X', '001401', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FGQCH8ZGPJ1XTU18PV8', '001403', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FGQCIEK0MM1XTUFCARI', '001403', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FGQCIEK0MQ1XTUM1D0D', '001403', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FGQCIEK0MR1XTUYMLER', '001403', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FH3PZQYXQV1XTUKPN6A', '000210', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FH3PZQYXQW1XTUSFDNG', '000210', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FH3PZQYXQX1XTUQAYR8', '000210', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FH3PZQYXQY1XTUGYUTF', '000210', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FH3PZQYXQZ1XTUBGJJQ', '000210', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FHFJ3NTGY41XTU6UORZ', '001601', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHFJ411ULT1XTU124EH', '001602', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHFJ4KZQV81XTUXF3J2', '001603', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHFJ4ZQIPL1XTUH39U1', '001604', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHFJ5FUPB71XTUTZXB4', '001605', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHGW33G2HM1XTUOP0HK', '001901', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHMCNV6TT11XTUMKAH1', '00160601', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHMDDRFMKQ1XTUH5LZJ', '00160602', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHTRXL6AFX1XTU44L87', '001510', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FHYOAOKKKM1XTUF3J1A', '00100201', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FHYOBDXVJM1XTUWOQYS', '00100202', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FHYOBDXVJQ1XTUPC2G7', '00100202', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0FHYOBDXVJR1XTUUD93J', '00100202', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FHYOBDXVJS1XTUEL22N', '00100202', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FI63HNWKLL1XTUEEGX4', '002001', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FI63IPJDV31XTU185K1', '002002', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FI63JRMSV41XTULNK2R', '0020021', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FI63K9NQH51XTUGZLBM', '0020022', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FI63L223AW1XTUDIVG7', '002003', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FI63LTT44K1XTUAM2FZ', '002004', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FI63MF0F9E1XTULK77H', '002005', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FIQ3692DBQ1XTU8YF5Q', '000210', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FJC26685LM1XTU0YPJL', '001505', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0FJC5D9EMPQ1XTUKUHBL', '00011101', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FJC5DLUPHC1XTUE4H72', '00011101', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FJC5E8RNQR1XTU1HM8W', '00011102', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FJC5E8RNQY1XTUPAP4U', '00011102', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FLYPGSJSHD1XTUNOBBW', '00011201', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FLYPH3J5SZ1XTUY5REO', '00011202', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FLYX9SKKKA1XTUUYVQM', '00011201', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FLYX9SKKKL1XTUJKNUB', '00011201', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FLYX9SKKKO1XTU9RTH4', '00011201', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FLYX9SKKKQ1XTUY3ACV', '00011201', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FM3FTYA8YRBU6S9EY9Y', '00011202', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0FM3FTYA8YZBU6SB4A9U', '00011202', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0FM3FTYA8Z0BU6SF9LZI', '00011202', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0FM3FTYA8Z1BU6SWB9EQ', '00011202', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0FNK7ZSDNKJ1XTUMR3UB', '003201', '00', '查询', '条件查询，查询总数');
INSERT INTO `sys_action` VALUES ('0FO6APQZZ4Y1XTUK4YGY', '003201', '01', '查询', '条件查询勤务排班信息，分页');
INSERT INTO `sys_action` VALUES ('0FO6APQZZ511XTUP6NZB', '003201', '02', '查询', '勤务排班信息详情');
INSERT INTO `sys_action` VALUES ('0FO6APQZZ521XTU5F09C', '003201', '03', '新增', '保存勤务排班信息');
INSERT INTO `sys_action` VALUES ('0FO6APQZZ531XTULTJ8Q', '003201', '04', '编辑', '修改勤务排班信息');
INSERT INTO `sys_action` VALUES ('0FO6APQZZ541XTU8TI9N', '003201', '05', '删除', '删除勤务排班信息');
INSERT INTO `sys_action` VALUES ('0FOUJ95KFEW1XTU38NW0', '003203', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FP6OBTX2U51XTUOV5CD', '003204', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FQCSJWZ20H1XTU844PM', '001405', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0FS3FT0WRF43EWNZ4OJZ', '000102', '130', '移动', NULL);
INSERT INTO `sys_action` VALUES ('0FYQQMDP9A33EWNG4XTU', '000102', '91', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0G566IQR57N1XTU07W5U', '000113', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0G5863VIIAI1XTUDV5ZC', '000113', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0G5863VIIAM1XTUZ13KV', '000113', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0G5863VIIAN1XTU8CORL', '000113', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0G5T5BBGJN61XTUQH1YP', '003905', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GA4K6EOMW31XTU9YPTS', '00010401', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GA4K9GXVPG1XTUG2QTI', '00010402', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GA508298481XTUOOFRB', '00010402', '90', '审核', NULL);
INSERT INTO `sys_action` VALUES ('0GACKYNAU3V8ZXK17ZYE', '00010402', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACU29K8ZXKX096B', '00010401', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG498ZXKWLDGA', '00010401', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG4A8ZXKS1GHD', '00010401', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG4B8ZXKAWU00', '00010401', '04', 'IP绑定', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG4C8ZXKHJ24T', '00010401', '05', '锁定/解锁账号', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG4D8ZXKEJQFK', '00010401', '06', '禁用/启用账号', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG4E8ZXKJW5IE', '00010401', '07', '更改密码', NULL);
INSERT INTO `sys_action` VALUES ('0GACPACUG4F8ZXKY3GYZ', '00010401', '92', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0GACPD8XIS98ZXKQS1V8', '00010402', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GAGT5VKZ458ZXKCQARP', '00010402', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0GBF4VLMRMG1XTUNF0GU', '200301', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF52RLTPG1XTUZLUWU', '200302', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF55RVX4R1XTUQ6ZHW', '200303', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF57HE0W21XTUXHGWU', '20030201', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF599Z7GB1XTUHMSRF', '200304', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF5ACX00G1XTU0DCEM', '200305', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF5C1Z4JR1XTU56W2J', '200306', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBF5EACPYC1XTUIQ6QS', '200307', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBH77577XM1XTUB64SD', '20030101', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBH77577XW1XTUOML69', '20030101', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBH77577XX1XTUGOKMO', '20030101', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBH79NA3561XTUEJK76', '20030202', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBH7I9CLLI1XTU75W99', '20030203', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA1EH8211XTUZIE0W', '20030203', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA1EH82C1XTUEA3PZ', '20030203', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA1EH82D1XTUP1AU8', '20030203', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA1EH82E1XTU5XWB1', '20030203', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA9SF7161XTU751KB', '20030301', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA9SF71E1XTU4MESV', '20030301', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA9SF71G1XTU7GE5C', '20030301', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA9SF71H1XTU0IPQQ', '20030301', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GBHA9SF71I1XTU0Q67O', '20030301', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAC3OQAX1XTUNMB9W', '20030302', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAC3OQB71XTURJBV8', '20030302', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAC3OQB81XTUT981G', '20030302', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAC3OQBA1XTURP1TM', '20030302', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAC3OQBB1XTU31W0J', '20030302', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAHM7CL31XTU0Q99A', '20030303', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAHM7CLC1XTU5EKS7', '20030303', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAHM7CLE1XTU61NRV', '20030303', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAHM7CLG1XTUB7GPU', '20030303', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAHM7CLH1XTUP3IAG', '20030303', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAME8TAL1XTUIJU00', '20030401', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAME8TAT1XTULDN1S', '20030401', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAME8TAU1XTUEK7FX', '20030401', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAME8TAV1XTUFHF4I', '20030401', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAME8TAW1XTU0UPIS', '20030401', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAOPA86R1XTU6OTWJ', '20030402', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAOPA8721XTUWHQAQ', '20030402', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAOPA8731XTU74XJT', '20030402', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAOPA8751XTUL9COS', '20030402', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAOPA8761XTU6XR2N', '20030402', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GBHATB0MZV1XTU324TV', '2003020101', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAWFM0BN1XTUHDOJ8', '2003020102', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAWFM0BU1XTU2ZFRY', '2003020102', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAWFM0BV1XTUF4KEC', '2003020102', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAZUZR031XTUYTEE9', '2003030101', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHAZUZR0A1XTU5E8YB', '2003030101', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHB1I1YGV1XTUSLU9S', '2003030102', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHB1I1YH31XTU40F1D', '2003030102', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBHB3DKGW01XTUJPP0U', '2003030301', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHB3DKGW71XTUJVMTU', '2003030301', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GBHB4VKVAX1XTU02EEY', '2003030302', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHB94N7PE1XTUK8LET', '2003030103', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHBBG7D8B1XTUFCNKT', '2003030104', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHBE86RYG1XTUJDI7Z', '2003030105', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHBMP2NVA1XTUNARAI', '2003020103', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHBS53Y6E1XTU8BFWS', '2003020104', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBHFSO0PMA1XTUHZZ13', '20030701', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GBKOW07A8P1XTUDHOO0', '20030403', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GBKP9F0DX51XTU2U0WL', '200308', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBKVLBJHLC1XTUQ1LT9', '2003040301', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBLKQ9RD1J1XTUQ0TA7', '20030503', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GBLKT4UAL01XTUL7VUD', '20030502', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GBLKUSK8M91XTUNOSPF', '20030501', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBOWBUX1X11XTUIT955', '200309', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GBS7M7NKH61XTU4BSZQ', '20030601', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GBUC3ZR1VP1XTUKYRCA', '20030602', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBUC3ZR1VX1XTU6N4D3', '20030602', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBUCZVICVY1XTUP6C6J', '200310', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBUEPRZHFM1XTUJMT6N', '20031001', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBUEPRZHGI1XTU1KPSC', '20031001', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GBWKYWZWEO1XTUSLCC0', '200311', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBWL2W8D3C1XTUVXBL5', '20031101', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBZ2RTA62W1XTUI54CW', '2003110101', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GBZ7BEN38F1XTU4BAE8', '20030901', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GC24D7V5761XTUUVKXJ', '20030902', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GC24VXW3OP1XTUSGOSQ', '20030903', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GC8WBXLLLB1XTUUSCBM', '20030202', '01', '新增企业', NULL);
INSERT INTO `sys_action` VALUES ('0GC8WBXLLLL1XTUQERKG', '20030202', '02', '编辑', NULL);
INSERT INTO `sys_action` VALUES ('0GC8WBXLLLN1XTU10JU6', '20030202', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GC8WBXLLLO1XTUFW0ZM', '20030202', '04', '查看详情', NULL);
INSERT INTO `sys_action` VALUES ('0GCE69GAOE01XTUM6F3X', '200312', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GCFIQB1BMF1XTUVMYFR', '200313', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCFIRS0GYQ1XTUB7C5J', '20031301', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCFISBGYPS1XTUXJQTX', '20031301', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GCN2IV6MFB1XTU0AYDG', '200314', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCN2KWN2AL1XTU731T8', '20031401', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCQDA1CM361XTUPK7KR', '2003020105', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GCQNHVWLQ21XTUKVB28', '20031302', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQ9Z5Y7B1XTUNBLLM', '20030404', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQ9Z5Y7P1XTUI3JHB', '20030404', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQ9Z5Y7R1XTU8G551', '20030404', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQ9Z5Y7T1XTURF8HN', '20030404', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQ9Z5Y8G1XTU6SXX3', '20030404', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQBTBBKS1XTULM4ZN', '2003040401', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQBTBBL11XTUJ8ECO', '2003040401', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GCUQBTBBL41XTUO1977', '2003040401', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA7A8I241XTUB09ZA', '20030405', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA7A8I2C1XTUZGNCQ', '20030405', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA7A8I2E1XTUYWKF7', '20030405', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA7A8I2G1XTUCBDJK', '20030405', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA7A8I2H1XTU7WL5S', '20030405', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA9KRCL31XTUZPWZ7', '2003040501', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA9KRCLB1XTU2MVGC', '2003040501', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA9KRCLC1XTUC1XFM', '2003040501', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA9KRCLE1XTU1XDE1', '2003040501', '03', '删除', NULL);
INSERT INTO `sys_action` VALUES ('0GCWA9KRCLF1XTUQ264T', '2003040501', '04', '查详情', NULL);
INSERT INTO `sys_action` VALUES ('0GCY3CXF7671XTU7UHJ2', '20031102', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCY3MBKODJ1XTUH0GOI', '2003110201', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCY3P2W96H1XTU8GHSH', '20030406', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GCY3S44QTW1XTUGKZVH', '2003040601', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GD5RDV8IOA3K3Q9C4VD', '20031103', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GD9F8O4F2U3K3Q794EJ', '200315', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GD9F9PUNIN3K3QXB24W', '20031501', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GD9FTDK9Z93K3Q9WJNC', '200316', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GD9FW040MF3K3QBOVO4', '20031601', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GDA3WULHKT3K3Q2C3MQ', '20031502', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDCLBG9IZV3K3Q855XQ', '2003150201', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDDTK4AE3Z3K3Q6XA5U', '200317', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GDDTOD04DY3K3QTBKVF', '20031701', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDDTPQSSHB3K3QCPX0O', '2003170101', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDDTQTI7YG3K3QLC4RJ', '2003170102', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDHUOMBLGW3K3QBOX5Y', '20031702', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GDI3R5OE6Z3K3QXVJD8', '2003020101', '05', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0GDI58OKLS23K3QHMRZJ', '2003020102', '03', '企业报表', NULL);
INSERT INTO `sys_action` VALUES ('0GDI5JPRVHR3K3QBYFUV', '20030202', '05', '导入', NULL);
INSERT INTO `sys_action` VALUES ('0GDI5JPRVHZ3K3Q9CYJ9', '20030202', '06', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0GDI5JPRVI13K3Q4L7YG', '20030202', '07', '查看积分', NULL);
INSERT INTO `sys_action` VALUES ('0GDI5UA38X83K3Q8BO9P', '20030203', '07', '批量授权', NULL);
INSERT INTO `sys_action` VALUES ('0GDI63DH4BI3K3QR4N61', '20030301', '05', '导出', NULL);
INSERT INTO `sys_action` VALUES ('0GDI63DH4BO3K3QF70MD', '20030301', '06', '复制', NULL);
INSERT INTO `sys_action` VALUES ('0GDI63DH4BQ3K3QE6NR0', '20030301', '07', '评分结果', NULL);
INSERT INTO `sys_action` VALUES ('0GDI6VNR2U53K3QOYS2H', '20031101', '01', '新增', NULL);
INSERT INTO `sys_action` VALUES ('0GDI6WS2KNR3K3Q08BS2', '20031101', '02', '修改', NULL);
INSERT INTO `sys_action` VALUES ('0GDIAVGC5VJ3K3QDNOR1', '2003020102', '04', '企业画像', '搜索、企业画像、下载、导出');
INSERT INTO `sys_action` VALUES ('0GDPKFQX36Z3K3QGMEK8', '2003030103', '04', '详情', NULL);
INSERT INTO `sys_action` VALUES ('0GDPKFQX3763K3QA1ZZV', '2003030103', '05', '历史评分', NULL);
INSERT INTO `sys_action` VALUES ('0GDPKL40LWW3K3QKRU05', '20031701', '01', '新增场地', NULL);
INSERT INTO `sys_action` VALUES ('0GDPN5RAOKB3K3QV51WQ', '20030403', '01', '新增机构列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDPO2M6F3Q3K3QBFJ54', '20031502', '01', '添加监控企业', NULL);
INSERT INTO `sys_action` VALUES ('0GDPO2M6F3X3K3QOKKJJ', '20031502', '06', '批量导入监控企业', NULL);
INSERT INTO `sys_action` VALUES ('0GDPO5QPJ0L3K3QF53O5', '20031502', '07', '跳转查看规则页面', NULL);
INSERT INTO `sys_action` VALUES ('0GDPUUNB9D83K3Q8GOF0', '20031602', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GDRZN6VXVC3K3Q4XZF1', '20031002', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDS7WEJPCF3K3QEEZ0G', '20031703', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GDXI6AYUHX3K3QIXC2X', '20031603', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GDXI7LHJMI3K3QWQA42', '20031604', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GDZZUK6VED3K3QRNHFI', '200318', '00', '查询列表', NULL);
INSERT INTO `sys_action` VALUES ('0GE0OTWIPN63K3QQ8JPT', '20031605', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GE9G8NOJSY3K3Q5MJNP', '20031606', '00', '查询', NULL);
INSERT INTO `sys_action` VALUES ('0GE9P13Z9B23K3QKY2K0', '200319', '00', '查询列表', NULL);

-- ----------------------------
-- Table structure for sys_app
-- ----------------------------
DROP TABLE IF EXISTS `sys_app`;
CREATE TABLE IF NOT EXISTS `sys_app`  (
  `APPID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'appId',
  `APPNO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'app编号',
  `APPNAME` varchar(400) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'app名称',
  `APPENNAME` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'app英文名称',
  `CATEGORY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用分类 internal：内部应用 third:第三方应用 virtual:虚拟应用',
  `FUNCGROUP` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '01' COMMENT '功能分组',
  `SORT` decimal(10, 0) NOT NULL COMMENT '排序',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `LOGOURL` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '应用图标',
  `INDEXURL` varchar(4000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方应用首页url地址',
  `AUTHMODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方应用集成登录方式 none:无需登录 oauth2：Oauth2.0协议登录',
  `AUTHEXT` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '第三方应用认证信息 json',
  `ISDISABLED` decimal(10, 0) NULL DEFAULT 0 COMMENT '是否禁用 0:启用 1：禁用',
  `MANAGEFUNCTION` decimal(1, 0) NULL DEFAULT 0 COMMENT '第三方应用是否允许录入功能定义 0：否 1：是 默认否',
  `IMG` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '应用图标base64',
  `LOGOTYPE` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '图标类型',
  `iSPortalMode` decimal(1, 0) NOT NULL COMMENT '是否以门户模式显示子系统下菜单 0:否 1：是',
  `portalHomePage` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '门户首页地址，菜单布局方式为门户模式时需填写',
  PRIMARY KEY (`APPID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '动作表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_app
-- ----------------------------
INSERT INTO `sys_app` VALUES ('0F6Q5CO5KSH3275M2NMT', 'smw', '系统管理', 'SYSTEM CONFIG', 'internal', '01', 1, NULL, 'icon-xitongguanli1', NULL, NULL, NULL, 0, 0, NULL, '3', 0, NULL);
INSERT INTO `sys_app` VALUES ('0F6Q6CO5KSH3275M2NMT', 'AIF', '集成框架', 'AIF', 'virtual', '01', 8, NULL, 'staticiconlogo.png', NULL, NULL, NULL, 0, 0, NULL, '2', 0, NULL);
INSERT INTO `sys_app` VALUES ('0FGQCAVFEDK1XTUXLEP0', 'mcm', '消息中心', 'MESSAGE CENTER', 'internal', '01', 30, NULL, 'icon-xiaoxizhongxin', NULL, NULL, NULL, 0, 0, NULL, '3', 0, NULL);
INSERT INTO `sys_app` VALUES ('0GAXH3B5CSC1XTUZNM6O', 'eipsw', '企业积分系统', 'Enterprise Innovation Points System', 'internal', '01', 2, '', '', NULL, NULL, NULL, 0, 0, '', '2', 0, NULL);

-- ----------------------------
-- Table structure for sys_appgroup
-- ----------------------------
DROP TABLE IF EXISTS `sys_appgroup`;
CREATE TABLE IF NOT EXISTS `sys_appgroup`  (
  `GROUPID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分组ID',
  `GROUPNAME` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分组名称',
  `GROUPENNAME` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组英文',
  `GROUPSORT` decimal(10, 0) NULL DEFAULT NULL COMMENT '分组顺序',
  `FUNCGROUP` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '01' COMMENT '功能分组',
  `GROUPANCHOR` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组锚点文字',
  `APPGROUPICON` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组图标',
  PRIMARY KEY (`GROUPID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '应用分组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_appgroup
-- ----------------------------
INSERT INTO `sys_appgroup` VALUES ('0GAI5SQ8DLJ1XTUTEO0I', '企业创新积分系统', 'Enterprise Innovation Points System', 5, '01', NULL, '');

-- ----------------------------
-- Table structure for sys_appgroup_detail
-- ----------------------------
DROP TABLE IF EXISTS `sys_appgroup_detail`;
CREATE TABLE IF NOT EXISTS `sys_appgroup_detail`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Id',
  `GROUPID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组id',
  `APPNO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '应用编号',
  `APPSORT` decimal(10, 0) NULL DEFAULT NULL COMMENT '应用顺序',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '应用分组明细' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_appgroup_detail
-- ----------------------------
INSERT INTO `sys_appgroup_detail` VALUES ('0FT7YKMFQKL1XTUOG1BZ', '0FT7YKMFO2D1XTU5AR40', 'csw', 1);
INSERT INTO `sys_appgroup_detail` VALUES ('0FT7YKMFQKN1XTUWA86L', '0FT7YKMFO2D1XTU5AR40', 'ftrw', 2);
INSERT INTO `sys_appgroup_detail` VALUES ('0GAXH48JW7T1XTUPOLC5', '0GAI5SQ8DLJ1XTUTEO0I', 'smw', 1);
INSERT INTO `sys_appgroup_detail` VALUES ('0GAXH48JW831XTU7OU96', '0GAI5SQ8DLJ1XTUTEO0I', 'eipsw', 2);

-- ----------------------------



-- ----------------------------
-- Table structure for sys_db_version
-- ----------------------------
DROP TABLE IF EXISTS `sys_db_version`;
CREATE TABLE IF NOT EXISTS `sys_db_version`  (
  `updatedId` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `apversion` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用程序发布版本信息',
  `sqlDescription` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数据库更新版本描述',
  `updatedTime` datetime(0) NULL DEFAULT current_timestamp(0) COMMENT '数据库SQL更新时间',
  PRIMARY KEY (`updatedId`) USING BTREE,
  UNIQUE INDEX `IX_SYS_DB_VERSION_APVER`(`apversion`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 289 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '数据库版本记录表' ROW_FORMAT = Dynamic;



-- ----------------------------
-- Table structure for sys_department
-- ----------------------------
DROP TABLE IF EXISTS `sys_department`;
CREATE TABLE IF NOT EXISTS `sys_department`  (
  `DEPARTMENTID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '部门Id',
  `BUNAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门名称',
  `BUFULLNAME` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门全称',
  `BUCODE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门代码',
  `PARENTID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级部门ID',
  `ISEND` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否末级 0：否 1：是',
  `BULEVEL` decimal(10, 0) NULL DEFAULT NULL COMMENT '部门层级',
  `AREACODE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域编码',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `HIERARCHYCODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '层级代码',
  `SORTCODE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序代码',
  `SORTHIERARCHYCODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序层级代码',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NOT NULL COMMENT '创建日期',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改日期',
  `LONGITUDE` decimal(10, 6) NULL DEFAULT NULL COMMENT '经度坐标值',
  `LATITUDE` decimal(10, 6) NULL DEFAULT NULL COMMENT '纬度坐标值',
  PRIMARY KEY (`DEPARTMENTID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '部门表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_department
-- ----------------------------
INSERT INTO `sys_department` VALUES ('5B3D8D8AD0BB8CE0E0530D01360B4F70', '全部组织', '全部组织', '341700000000', NULL, 0, 0, '420000', NULL, '341700000000', '0001', '0001', 'admin', '2014-08-28 15:23:59', 'admin', '2022-07-08 15:03:07', 117.499440, 30.632719);

-- ----------------------------
-- Table structure for sys_downloadcenter
-- ----------------------------
DROP TABLE IF EXISTS `sys_downloadcenter`;
CREATE TABLE IF NOT EXISTS `sys_downloadcenter`  (
  `DOWNID` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL COMMENT '主键',
  `APPNAME` varchar(500) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '应用名称',
  `APPICON` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '应用图标',
  `VERSION` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '版本号',
  `PACKGEPATH` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '安装包路径',
  `ISNEEDLOGIN` decimal(1, 0) NULL DEFAULT NULL COMMENT '下载是否需要登录',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '状态',
  `DESCRIPTION` varchar(500) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '描述',
  `CREATOR` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`DOWNID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = '下载中心表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_downloadcenter
-- ----------------------------

-- ----------------------------
-- Table structure for sys_function
-- ----------------------------
DROP TABLE IF EXISTS `sys_function`;
CREATE TABLE IF NOT EXISTS `sys_function`  (
  `FUNCTIONGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '功能GUID',
  `FUNCTIONCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能代码',
  `FUNCTIONNAME` varchar(400) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能名称',
  `HIERARCHYCODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '层级编码',
  `PARENTHIERARCHYCODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级层级编码',
  `SORTCODE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序代码',
  `SORTHIERARCHYCODE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序层级代码',
  `FUNCTIONLEVEL` decimal(8, 0) NULL DEFAULT NULL COMMENT '层级数',
  `ISLASTSTAGE` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否末级',
  `FUNCTIONICON` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图标',
  `FUNCTIONURL` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '页面地址',
  `COMMENTS` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '说明',
  `ISDISABLED` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否禁用',
  `PARENTFUNCTIONGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级GUID',
  `FUNCTIONTYPE` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能类型 1：菜单功能 2：虚拟功能（只做权限控制，不在菜单中显示）',
  `GROUPNO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组编号',
  `APPNO` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '应用程序编号',
  `ISOVERLOAD` decimal(1, 0) NULL DEFAULT NULL COMMENT '是否重载（1：禁用 0启用）',
  `ISHOMEPAGESEARCHMENU` int(11) NULL DEFAULT 0 COMMENT '是否作为首页搜索菜单(1:是  0:否)',
  PRIMARY KEY (`FUNCTIONGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统功能菜单定义表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_function
-- ----------------------------
INSERT INTO `sys_function` VALUES ('0F444XTZICM2FOR5Z840', '000104', '用户管理', '000104', '', '0004', '0004', 1, 0, NULL, '', NULL, 0, '', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F444YM2D5T2FORUGM8M', '000101', '功能定义', '000101', NULL, '0002', '0002', 1, 1, NULL, '/smw/#/sysconfig/function', NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F444Z1XN2L2FORRT1NC', '000105', '数据字典', '000105', NULL, '0006', '0006', 1, 1, NULL, '/smw/#/sysconfig/dict', NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F444ZLC8KZ2FORCW4RN', '000103', '角色管理', '000103', NULL, '0003', '0003', 1, 1, NULL, '/smw/#/sysconfig/role', NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F444ZTVPOI2FOR9NLHD', '000106', '配置中心', '000106', NULL, '0007', '0007', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F4455Q1T6W2FORTD0YH', '00010604', '参数配置', '000106.00010604', '000106', '0004', '0007.0004', 2, 1, NULL, '/smw/#/sysconfig/config/config', NULL, 0, '0F444ZTVPOI2FOR9NLHD', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F4456481Y52FORYO95M', '00010605', '变更日志', '000106.00010605', '000106', '0005', '0007.0005', 2, 1, NULL, '/smw/#/sysconfig/config/log', NULL, 1, '0F444ZTVPOI2FOR9NLHD', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F5SHOTCZ7N32751JZWC', '000107', '应用管理', '000107', NULL, '0008', '0008', 1, 1, NULL, '/smw/#/sysconfig/sysapp', NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F677XP1CGT3275ACB8P', '000108', '应用分组', '000108', NULL, '0013', '0013', 1, 1, NULL, '/smw/#/sysconfig/group', NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F6PPZT394Z3275HPEI8', '000109', 'OAuth2.0管理', '000109', '000109', '0023', '0023', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F6Q5FL8JZQ3275SRLTX', '0014001', '综合应用', '0014001', NULL, '0028', '0028', 1, 1, NULL, '#map', '武汉经济技术开发区（汉南区）公安视频应用平台\\nWuhan economic and Technological Development Zone (Hannan District) public security video application platform', 1, NULL, '1', NULL, 'AIF', 0, 0);
INSERT INTO `sys_function` VALUES ('0F6Q5I7E0L83275N5G4G', '0014003', '专项应用', '0014003', NULL, '0030', '0030', 1, 1, NULL, '/AIF/#/bigerScreen', '武汉经济技术开发区（汉南区）专项应用平台', 1, NULL, '1', NULL, 'AIF', 0, 0);
INSERT INTO `sys_function` VALUES ('0F6V6QZTJUAAD3AJM1QD', '00010901', '应用申请', '000109.00010901', '000109', '0001', '0023.0001', 2, 1, NULL, '/smw/#/sysconfig/oauth/app', NULL, 0, '0F6PPZT394Z3275HPEI8', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0F6V6RALOA5AD3AYNVU6', '00010902', '账号绑定', '000109.00010902', '000109', '0002', '0023.0002', 2, 1, NULL, '/smw/#/sysconfig/oauth/bind', NULL, 0, '0F6PPZT394Z3275HPEI8', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FAYXV5ISKB9TZS9MQ2J', '001505', '红名单管理', '001505', '', '0004', '0004', 1, 1, NULL, '/tmw/#/tmw/RedListManagement', NULL, 0, '', '1', NULL, 'hmd', 0, 0);
INSERT INTO `sys_function` VALUES ('0FB5GW9PIC59TZS84RNI', '000102', '组织架构', '000102', '', '0009', '0009', 1, 1, NULL, '/smw/#/sysconfig/organiza', NULL, 0, '', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FDM27YF8113ZJ2YVBTK', '1111111111111111', '首页', '1111111111111111', NULL, '0001', '0001', 1, 1, NULL, '/', NULL, 0, NULL, '1', NULL, 'jsmw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FET4PHESVG81SG0Q5OO', '00100201', '黑名单', '00100201', '', '0001', '0001', 1, 1, NULL, '/lpmw/#/lpmw/passConfiguration/blackList', NULL, 0, '', '1', NULL, 'hmdgl', 0, 0);
INSERT INTO `sys_function` VALUES ('0FET4QR9IF781SG1AW84', '00100202', '黑名单公司', '00100202', '', '0002', '0002', 1, 1, NULL, '/lpmw/#/lpmw/blacklistCompany/index', NULL, 0, '', '1', NULL, 'hmdgl', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLCRB1STG1XTUP7LVC', '001201', '平台管理', '001201', NULL, '0001', '0001', 1, 1, NULL, '/csw/#/csw/cloudsearchPlatformAccess', NULL, 0, NULL, '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLCSXLB0G1XTUVFG5W', '001202', '模板管理', '001202', NULL, '0002', '0002', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLCVH186P1XTUCW7UK', '00120201', '模块管理', '001202.00120201', '001202', '0001', '0002.0001', 2, 1, NULL, '/csw/#/csw/cloudsearchModule', NULL, 0, '0FFLCSXLB0G1XTUVFG5W', '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLCWBS1KH1XTUSIEH3', '00120202', '类型管理', '001202.00120202', '001202', '0002', '0002.0002', 2, 1, NULL, '/csw/#/csw/cloudsearchDataType', NULL, 0, '0FFLCSXLB0G1XTUVFG5W', '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLCWSJ4U31XTUAUHG7', '00120203', '字段管理', '001202.00120203', '001202', '0003', '0002.0003', 2, 1, NULL, '/csw/#/csw/cloudsearchDataTypeField', NULL, 0, '0FFLCSXLB0G1XTUVFG5W', '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLCYHW9I11XTUBO6RI', '00120204', '模板内容', '001202.00120204', '001202', '0004', '0002.0004', 2, 1, NULL, '/csw/#/csw/cloudsearchTemplateField', NULL, 0, '0FFLCSXLB0G1XTUVFG5W', '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLD15M8QK1XTUGZCXR', '001203', '关键词管理', '001203', NULL, '0003', '0003', 1, 1, NULL, '/csw/#/csw/cloudsearchKeyword', NULL, 1, NULL, '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLD1SYB2R1XTUGZXBW', '001204', '搜索管理', '001204', NULL, '0004', '0004', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLD332DEE1XTU1BGB4', '00120401', '云搜索', '001204.00120401', '001204', '0001', '0004.0001', 2, 1, NULL, '/csw/#/csw/cloudsearchPlatformKeyword', NULL, 0, '0FFLD1SYB2R1XTUGZXBW', '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFLD3CVEHO1XTUW4Y8W', '00120402', '搜索历史', '001204.00120402', '001204', '0002', '0004.0002', 2, 1, NULL, '/csw/#/csw/cloudsearchLog', NULL, 0, '0FFLD1SYB2R1XTUGZXBW', '1', NULL, 'csw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FFQ0QAUWZ81XTUS454A', '001301', '主页', '001301', NULL, '0001', '0001', 1, 1, NULL, '/ftrw/#/ftrw/searchCloud', NULL, 0, NULL, '1', NULL, 'ftrw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FG3AKZWTQC1XTUST09E', '000111', '日志管理', '000111', NULL, '0005', '0005', 1, 0, NULL, '/smw/#/sysconfig/operationLog', NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FGQCDG6VG31XTUJ6E58', '001401', '消息查询', '001401', NULL, '0001', '0001', 1, 1, NULL, '/mcm/#/mcm/msgList', NULL, 0, NULL, '1', NULL, 'mcm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FGQCH8ZGQJ1XTUKHRFE', '001403', '消息设置', '001403', NULL, '0003', '0003', 1, 1, NULL, '/mcm/#/mcm/msgConfig', NULL, 0, NULL, '1', NULL, 'mcm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FHFJ4KZQWD1XTUME0D6', '001603', '人员管理', '001603', NULL, '0003', '0003', 1, 1, NULL, '/egw/#/egw/staffManage', NULL, 0, NULL, '1', NULL, 'egw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FHFJ86WDS81XTU5BKLK', '001606', '日志管理', '001606', NULL, '0006', '0006', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'egw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FHGW33G2HY1XTUY114I', '001901', '历史轨迹', '001901', NULL, '0002', '0002', 1, 1, NULL, '/UAVW/#/uavw/historyTrack', NULL, 0, NULL, '1', NULL, 'UAVW', 0, 0);
INSERT INTO `sys_function` VALUES ('0FHMCNV6TTN1XTU0W8UR', '00160601', '门禁日志', '001606.00160601', '001606', '0001', '0006.0001', 2, 1, NULL, '/egw/#/egw/doorLog', NULL, 0, '0FHFJ86WDS81XTU5BKLK', '1', NULL, 'egw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FHMDDRFML41XTUC1A5G', '00160602', '采集日志', '001606.00160602', '001606', '0002', '0006.0002', 2, 1, NULL, '/egw/#/egw/collectionLog', NULL, 0, '0FHFJ86WDS81XTU5BKLK', '1', NULL, 'egw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63HNWKMY1XTU0ODZK', '002001', '主机管理', '002001', NULL, '0001', '0001', 1, 1, NULL, '/ftmm/#/ftmm/flinkHost', NULL, 0, NULL, '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63IPJDZI1XTUQGI0O', '002002', '参数管理', '002002', NULL, '0002', '0002', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63JRMSW81XTUDUGL4', '0020021', '参数分类', '002002.0020021', '002002', '0001', '0002.0001', 2, 1, NULL, '/ftmm/#/ftmm/flinkParamCategory', NULL, 0, '0FI63IPJDZI1XTUQGI0O', '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63K9NQII1XTUVKG35', '0020022', '运行参数', '002002.0020022', '002002', '0002', '0002.0002', 2, 1, NULL, '/ftmm/#/ftmm/flinkParam', NULL, 0, '0FI63IPJDZI1XTUQGI0O', '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63L223DF1XTU2A07S', '002003', '命令管理', '002003', NULL, '0003', '0003', 1, 1, NULL, '/ftmm/#/ftmm/flinkCommand', NULL, 0, NULL, '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63LTT46N1XTUDOERI', '002004', '任务管理', '002004', NULL, '0004', '0004', 1, 1, NULL, '/ftmm/#/ftmm/flinkTask', NULL, 0, NULL, '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FI63MF0FBE1XTUN35UR', '002005', '任务调度管理', '002005', NULL, '0005', '0005', 1, 1, NULL, '/ftmm/#/ftmm/flinkTaskDispatch', NULL, 0, NULL, '1', NULL, 'ftmm', 0, 0);
INSERT INTO `sys_function` VALUES ('0FJC5D9EMQ71XTUJWM1Y', '00011101', '操作日志', '000111.00011101', '000111', '0001', '0005.0001', 2, 1, NULL, '/smw/#/sysconfig/operationLog', NULL, 0, '0FG3AKZWTQC1XTUST09E', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FJC5E8RNRG1XTUE5S11', '00011102', '运行日志', '000111.00011102', '000111', '0002', '0005.0002', 2, 1, NULL, '/smw/#/sysconfig/appLog', NULL, 0, '0FG3AKZWTQC1XTUST09E', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FLYPG7J3IN1XTUO7RE2', '000112', '数据接入', '000112', NULL, '0024', '0024', 1, 0, NULL, NULL, NULL, 0, NULL, '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FLYPGSJSW11XTUFW68W', '00011201', '厂商管理', '000112.00011201', '000112', '0001', '0024.0001', 2, 1, NULL, '/smw/#/sysconfig/platform', NULL, 0, '0FLYPG7J3IN1XTUO7RE2', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FLYPH3J5U81XTU8FKYT', '00011202', '字段映射', '000112.00011202', '000112', '0002', '0024.0002', 2, 1, NULL, '/smw/#/sysconfig/mapping', NULL, 0, '0FLYPG7J3IN1XTUO7RE2', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FNK7ZSDVKE1XTUF71GB', '003201', '勤务排班', '003201', NULL, '0001', '0001', 1, 1, NULL, '/ssw/#/ssw/ServiceSchedule', NULL, 0, NULL, '1', NULL, 'ssw', 1, 0);
INSERT INTO `sys_function` VALUES ('0FOUJ95KFFE1XTUL3HC3', '003203', '报备记录', '003203', NULL, '0003', '0003', 1, 1, NULL, '/ssw/#/ssw/ReportRecord', NULL, 0, NULL, '1', NULL, 'ssw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FP6OB9PVL81XTU57WBQ', '003204', '勤务考核', '003204', NULL, '0004', '0004', 1, 1, NULL, '/ssw/#/ssw/ServiceCheck', NULL, 0, NULL, '1', NULL, 'ssw', 0, 0);
INSERT INTO `sys_function` VALUES ('0FQCSJWZ20Q1XTUDNUA7', '001405', '报警中心', '001405', NULL, '0002', '0002', 1, 1, NULL, '/mcm/#/mcm/alarmMsgList', NULL, 0, NULL, '1', NULL, 'mcm', 0, 0);
INSERT INTO `sys_function` VALUES ('0G1BE2CSGWQ1XTU2FRRA', '00011203', '首页看板', '00011203', '', '0015', '0015', 1, 1, NULL, '/smw/#/sysconfig/homePageBoard', NULL, 0, '', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0G566IQR5891XTU0JS1A', '000113', '下载中心', '000113', '', '0028', '0028', 1, 1, NULL, '/smw/#/sysconfig/downloadCenter', NULL, 0, '', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GA4K6EOMWR1XTUUKW7T', '00010401', '用户信息', '000104.00010401', '000104', '0001', '0004.0001', 2, 1, NULL, '/smw/#/sysconfig/user', NULL, 0, '0F444XTZICM2FOR5Z840', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GA4K9GXVPX1XTUWCTYA', '00010402', '注册审核', '000104.00010402', '000104', '0002', '0004.0002', 2, 1, NULL, '/smw/#/sysconfig/registerapprove', NULL, 0, '0F444XTZICM2FOR5Z840', '1', NULL, 'smw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF4VLMRNB1XTUTRD2Z', '200301', '我的信息', '200301', '', '0003', '0003', 1, 0, 'xiaoxi1', '/eipsw/#/myMessage', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF52RLTQJ1XTUADZVG', '200302', '企业管理', '200302', '', '0032', '0032', 1, 0, 'loudongguanli', '', NULL, 0, '', '1', '', 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF55RVX5S1XTUIQ7IA', '200303', '积分管理', '200303', '', '0033', '0033', 1, 0, 'shujuzonglaing', '', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF57HE0WO1XTUV3MDT', '20030201', '企业档案', '200302.20030201', '200302', '0001', '0032.0001', 2, 1, NULL, '/eipsw/#/searchHome', NULL, 0, '0GBF52RLTQJ1XTUADZVG', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF599Z7GZ1XTUZ4TCJ', '200304', '创新券管理', '200304', '', '0035', '0035', 1, 0, 'qita_2', '', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF5ACX0151XTUMMYLZ', '200305', '服务项目', '200305', '', '0036', '0036', 1, 0, 'rongqi', '/eipsw/#/servicesAvailable', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF5C1Z4KF1XTUOAW0D', '200306', '金融产品管理', '200306', '', '0037', '0037', 1, 0, 'jinrongchanpin', '/eipsw/#/financialProducts', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBF5EACPYZ1XTUBAHZG', '200307', '我的订单', '200307', '', '0039', '0039', 1, 0, 'shangquan', '/eipsw/#/boughtList', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBH7757TR31XTUNUR75', '20030101', '我的信息-编辑', '200301.20030101', '200301', '0001', '0003.0001', 2, 1, NULL, '/eipsw/#/editServiceInfo', '', 0, '0GBF4VLMRNB1XTUTRD2Z', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBH79NA3671XTUQAZXR', '20030202', '企业列表', '200302.20030202', '200302', '0002', '0032.0002', 2, 1, NULL, '/eipsw/#/enterpriseList', NULL, 0, '0GBF52RLTQJ1XTUADZVG', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBH7I9CLMJ1XTUCGO06', '20030203', '标签管理', '200302.20030203', '200302', '0003', '0032.0003', 2, 1, NULL, '/eipsw/#/tagManagement', NULL, 0, '0GBF52RLTQJ1XTUADZVG', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHA9SF7271XTUG7V6Y', '20030301', '积分模板', '200303.20030301', '200303', '0002', '0033.0002', 2, 1, NULL, '/eipsw/#/templateList', NULL, 0, '0GBF55RVX5S1XTUIQ7IA', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHAC3OQC11XTUJNW7J', '20030302', '指标管理', '200303.20030302', '200303', '0003', '0033.0003', 2, 1, NULL, '/eipsw/#/targetList', NULL, 0, '0GBF55RVX5S1XTUIQ7IA', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHAHM7CM51XTU4IXEU', '20030303', '积分榜单', '200303.20030303', '200303', '0004', '0033.0004', 2, 1, NULL, '/eipsw/#/integralList', NULL, 0, '0GBF55RVX5S1XTUIQ7IA', '1', NULL, 'eipsw', 1, 0);
INSERT INTO `sys_function` VALUES ('0GBHAME8TBT1XTU1E3KI', '20030401', '额度管理', '200304.20030401', '200304', '0001', '0035.0001', 2, 1, NULL, '/eipsw/#/innovationVolume', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHAOPA88C1XTU06T6Z', '20030402', '常见问题', '200304.20030402', '200304', '0010', '0035.0010', 2, 1, NULL, '/eipsw/#/commonProblem', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHATB0N0X1XTUEA7E3', '2003020101', '企业档案-搜索详情', '200302.2003020101', '200302', '0038', '0032.0038', 2, 1, NULL, '/eipsw/#/search', '', 0, '0GBF52RLTQJ1XTUADZVG', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHAWFM0CG1XTUCCQSF', '2003020102', '企业档案-企业详情', '200302.2003020102', '200302', '0039', '0032.0039', 2, 1, NULL, '/eipsw/#/enterpriseDetails', '', 0, '0GBF52RLTQJ1XTUADZVG', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHAZUZR0W1XTU5P02L', '2003030101', '积分模板-新增模板', '200303.2003030101', '200303', '0042', '0033.0042', 2, 1, NULL, '/eipsw/#/addTemplate', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHB1I1YHM1XTUN20I9', '2003030102', '积分模板-编辑模板', '200303.2003030102', '200303', '0043', '0033.0043', 2, 1, NULL, '/eipsw/#/editTemplate', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHB3DKGWR1XTUVMJ9X', '2003030301', '积分榜单-发布榜单', '200303.2003030301', '200303', '0047', '0033.0047', 2, 1, NULL, '/eipsw/#/release', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHB4VKVC21XTUH16YJ', '2003030302', '积分榜单-查看榜单', '200303.2003030302', '200303', '0048', '0033.0048', 2, 1, NULL, '/eipsw/#/viewList', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHB94N7QF1XTUX7XW6', '2003030103', '积分模板-评分详情', '200303.2003030103', '200303', '0044', '0033.0044', 2, 1, NULL, '/eipsw/#/score', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHBBG7D921XTU14053', '2003030104', '积分模板-企业评分详情', '200303.2003030104', '200303', '0045', '0033.0045', 2, 1, NULL, '/eipsw/#/scoreDetail', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHBE86RZ61XTUWFPA2', '2003030105', '评分详情-历史评分', '200303.2003030105', '200303', '0046', '0033.0046', 2, 1, NULL, '/eipsw/#/historical', '', 0, '0GBF55RVX5S1XTUIQ7IA', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHBMP2NW31XTU699GY', '2003020103', '企业档案-企业画像', '200302.2003020103', '200302', '0040', '0032.0040', 2, 1, NULL, '/eipsw/#/portrait', '', 0, '0GBF52RLTQJ1XTUADZVG', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHBS53Y7A1XTU83110', '2003020104', '企业档案-高级搜索', '200302.2003020104', '200302', '0041', '0032.0041', 2, 1, NULL, '/eipsw/#/advanced', '', 0, '0GBF52RLTQJ1XTUADZVG', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBHFSO0PNT1XTUKL7HS', '20030701', '我的订单-订单详情', '200307.20030701', '200307', '0001', '0039.0001', 2, 1, NULL, '/eipsw/#/orderDetail', '', 0, '0GBF5EACPYZ1XTUBAHZG', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBKOW07ABJ1XTUBJJN3', '20030403', '机构列表', '200304.20030403', '200304', '0002', '0035.0002', 2, 1, NULL, '/eipsw/#/serviceList', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBKP9F0DY21XTU8D4UF', '200308', '数据看板', '200308', '', '0046', '0046', 1, 1, 'shishijiankong', '/eipsw/#/dataBoard', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBKVLBJHM71XTUFAQOA', '2003040301', '机构列表-机构详情', '200304.2003040301', '200304', '0003', '0035.0003', 2, 1, NULL, '/eipsw/#/viewServiceList', '', 0, '0GBF599Z7GZ1XTUZ4TCJ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBLKQ9RD4Z1XTU99L8H', '20030503', '服务项目-编辑项目', '200305.20030503', '200305', '0052', '0036.0052', 2, 1, NULL, '/eipsw/#/editServiceItem', '', 0, '0GBF5ACX0151XTUMMYLZ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBLKT4UAM11XTUAPOI3', '20030502', '服务项目-发布服务', '200305.20030502', '200305', '0051', '0036.0051', 2, 1, NULL, '/eipsw/#/publishingService', '', 0, '0GBF5ACX0151XTUMMYLZ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBLKUSK8N51XTUQLDU2', '20030501', '服务项目-服务项目详情', '200305.20030501', '200305', '0050', '0036.0050', 2, 1, NULL, '/eipsw/#/servicesAvailable', '', 0, '0GBF5ACX0151XTUMMYLZ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBOWBUX1YL1XTUBEPDR', '200309', '贷款申请', '200309', '', '0040', '0040', 1, 0, 'a-daikuan1', '/eipsw/#/loanList', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBS7M7NKIJ1XTU163NE', '20030601', '金融产品管理-发布金融产品', '200306.20030601', '200306', '0001', '0037.0001', 2, 1, NULL, '/eipsw/#/releasedFinancialProducts', '', 0, '0GBF5C1Z4KF1XTUOAW0D', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBUC3ZR1X41XTUBGA81', '20030602', '金融产品管理-编辑金融产品', '200306.20030602', '200306', '0002', '0037.0002', 2, 1, NULL, '/eipsw/#/editFinancialProducts', '', 0, '0GBF5C1Z4KF1XTUOAW0D', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBUCZVICWS1XTUGWDD0', '200310', '机构工作台', '200310', '', '0002', '0002', 1, 0, 'xiaoxi1', '/eipsw/#/workBenchFI', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBUEPRZHH81XTUTLVWQ', '20031001', '金融机构信息-编辑机构信息', '200310.20031001', '200310', '0001', '0002.0001', 2, 1, NULL, '/eipsw/#/editFinancingOrgInfo', '', 0, '0GBUCZVICWS1XTUGWDD0', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBWKYWZWFM1XTUCCC60', '200311', '积分贷', '200311', '', '0041', '0041', 1, 0, 'fuwuchangsuo', '', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBWL2W8D471XTUPAL2I', '20031101', '金融机构列表', '200311.20031101', '200311', '0002', '0041.0002', 2, 1, NULL, '/eipsw/#/backstageServiceDocking', NULL, 0, '0GBWKYWZWFM1XTUCCC60', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBZ2RTA63S1XTUTB5SS', '2003110101', '金融机构列表-机构详情', '200311.2003110101', '200311', '0003', '0041.0003', 2, 1, NULL, '/eipsw/#/financingOrgDetails', NULL, 0, '0GBWKYWZWFM1XTUCCC60', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GBZ7BEN3BU1XTUF9G9W', '20030901', '贷款申请-企业详情', '200309.20030901', '200309', '0001', '0040.0001', 2, 1, NULL, '/eipsw/#/browseEnterpriseDetails', NULL, 0, '0GBOWBUX1YL1XTUBEPDR', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GC24D7V5961XTUSSYLA', '20030902', '贷款申请-积分详情', '200309.20030902', '200309', '0002', '0040.0002', 2, 1, NULL, '/eipsw/#/loanScore', NULL, 0, '0GBOWBUX1YL1XTUBEPDR', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GC24VXW3QQ1XTU67R5A', '20030903', '贷款申请-申请详情', '200309.20030903', '200309', '0003', '0040.0003', 2, 1, NULL, '/eipsw/#/loanDetail', NULL, 0, '0GBOWBUX1YL1XTUBEPDR', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCE69GAOFU1XTU0BT8K', '200312', '购物车', '200312', '', '0038', '0038', 1, 1, 'shopping-cart', '/eipsw/#/cart', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCFIQB1BNW1XTU1FEE5', '200313', '我的工作台', '200313', '', '0031', '0031', 1, 0, 'caijixitong', '/eipsw/#/workbench', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCFIRS0GZP1XTU3H0YA', '20031301', '我的工作台-编辑企业信息', '200313.20031301', '200313', '0001', '0031.0001', 2, 1, NULL, '/eipsw/#/editInfo', NULL, 0, '0GCFIQB1BNW1XTU1FEE5', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCN2IV77QR1XTUXKXK2', '200314', '兑付订单', '200314', '', '0042', '0042', 1, 0, 'qianbaojinrongzijin', '/eipsw/#/orderHonour', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCN2KWN2CE1XTUMETQY', '20031401', '兑付订单-兑付详情', '200314.20031401', '200314', '0001', '0042.0001', 2, 1, NULL, '/eipsw/#/orderHonourDetails', NULL, 0, '0GCN2IV77QR1XTUXKXK2', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCQDA1CM4F1XTURZDDD', '2003020105', '企业档案-企业报表', '200302.2003020105', '200302', '0042', '0032.0042', 2, 1, NULL, '/eipsw/#/report', NULL, 0, '0GBF52RLTQJ1XTUADZVG', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCQNHVWLRB1XTUOGVQ2', '20031302', '我的工作台-企业数据报表', '200313.20031302', '200313', '0002', '0031.0002', 2, 1, NULL, '/eipsw/#/enterpriseReport', NULL, 0, '0GCFIQB1BNW1XTU1FEE5', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCUQ9Z5Y9C1XTUZCEGS', '20030404', '兑付审批', '200304.20030404', '200304', '0006', '0035.0006', 2, 1, NULL, '/eipsw/#/honourAudit', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCUQBTBBLM1XTUCMFHP', '2003040401', '兑付审批详情', '200304.2003040401', '200304', '0007', '0035.0007', 2, 1, NULL, '/eipsw/#/honourAuditDetails', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCWA7A8I311XTUPMHO6', '20030405', '公示公告', '200304.20030405', '200304', '0008', '0035.0008', 2, 1, NULL, '/eipsw/#/proclamation', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCWA9KRCLX1XTUAI7CC', '2003040501', '公示公告-发布公告', '200304.2003040501', '200304', '0009', '0035.0009', 2, 1, NULL, '/eipsw/#/publishProclamation', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCY3CXF7741XTUJL9A3', '20031102', '贷款申请', '200311.20031102', '200311', '0004', '0041.0004', 2, 1, NULL, '/eipsw/#/loanList', NULL, 0, '0GBWKYWZWFM1XTUCCC60', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCY3MBKOE81XTUFGPIH', '2003110201', '贷款申请-申请详情', '200311.2003110201', '200311', '0005', '0041.0005', 2, 1, NULL, '/eipsw/#/loanDetail', NULL, 0, '0GBWKYWZWFM1XTUCCC60', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCY3P2W9751XTU98E2G', '20030406', '订单管理', '200304.20030406', '200304', '0004', '0035.0004', 2, 1, NULL, '/eipsw/#/boughtList', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GCY3S44QUE1XTUL7M4W', '2003040601', '我的订单-订单详情', '200304.2003040601', '200304', '0005', '0035.0005', 2, 1, NULL, '/eipsw/#/orderDetail', NULL, 0, '0GBF599Z7GZ1XTUZ4TCJ', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GD5RDV8IP23K3Q3O9QI', '20031103', '积分贷总览', '200311.20031103', '200311', '0001', '0041.0001', 2, 1, NULL, '/eipsw/#/workBenchIV', NULL, 0, '0GBWKYWZWFM1XTUCCC60', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GD9F8O4F3J3K3QJE08L', '200315', '企业监测', '200315', '', '0043', '0043', 1, 0, 'quanxibukong', '', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GD9F9PUNJH3K3Q9OPC4', '20031501', '监测动态', '200315.20031501', '200315', '0001', '0043.0001', 2, 1, NULL, '/eipsw/#/dynamicCondition', NULL, 0, '0GD9F8O4F3J3K3QJE08L', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GD9FTDKA0X3K3Q8XB9N', '200316', '政策申报', '200316', '', '0044', '0044', 1, 0, 'zhengcezhipei', '', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GD9FW040O83K3QPDB9Y', '20031601', '政策分类', '200316.20031601', '200316', '0001', '0044.0001', 2, 1, NULL, '/eipsw/#/policyClassifyList', NULL, 0, '0GD9FTDKA0X3K3Q8XB9N', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDA3WULHLG3K3QO4EKT', '20031502', '监测列表', '200315.20031502', '200315', '0002', '0043.0002', 2, 1, NULL, '/eipsw/#/monitoringList', NULL, 0, '0GD9F8O4F3J3K3QJE08L', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDCLBG9J0J3K3QJCXHN', '2003150201', '监测规则', '200315.2003150201', '200315', '0004', '0043.0004', 2, 1, NULL, '/eipsw/#/monitoringRules', NULL, 0, '0GD9F8O4F3J3K3QJE08L', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDDTK4AE5L3K3QXX2A3', '200317', '企业服务', '200317', '', '0034', '0034', 1, 0, 'gonggongfuwu', '', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDDTOD04ES3K3QCF4HK', '20031701', '双创空间管理', '200317.20031701', '200317', '0001', '0034.0001', 2, 1, NULL, '/eipsw/#/businessSpace', NULL, 0, '0GDDTK4AE5L3K3QXX2A3', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDDTPQSSJ93K3QM5XL2', '2003170101', '双创空间管理-新增双创空间', '200317.2003170101', '200317', '0002', '0034.0002', 2, 1, NULL, '/eipsw/#/addBusinessSpace', NULL, 0, '0GDDTK4AE5L3K3QXX2A3', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDDTQTI7ZA3K3QNVREL', '2003170102', '双创空间管理-编辑双创空间', '200317.2003170102', '200317', '0003', '0034.0003', 2, 1, NULL, '/eipsw/#/editBusinessSpace', NULL, 0, '0GDDTK4AE5L3K3QXX2A3', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDHUOMBLIK3K3QTZN67', '20031702', '创新平台管理', '200317.20031702', '200317', '0005', '0034.0005', 2, 1, NULL, '/eipsw/#/technologyInnovation', NULL, 0, '0GDDTK4AE5L3K3QXX2A3', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDPUUNB9E23K3Q71YB6', '20031602', '申报事项', '200316.20031602', '200316', '0002', '0044.0002', 2, 1, NULL, '/eipsw/#/declareList', NULL, 0, '0GD9FTDKA0X3K3Q8XB9N', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDRZN6VXWS3K3QQVV05', '20031002', '推荐企业', '200310.20031002', '200310', '0002', '0002.0002', 2, 1, NULL, '/eipsw/#/recommendEnterprise', NULL, 0, '0GBUCZVICWS1XTUGWDD0', '2', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDS7WEJPD43K3QTRWM6', '20031703', '空间需求', '200317.20031703', '200317', '0004', '0034.0004', 2, 1, NULL, '/eipsw/#/spaceRequirement', NULL, 0, '0GDDTK4AE5L3K3QXX2A3', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDXI6AYUJ43K3QD46H1', '20031603', '申报总览', '200316.20031603', '200316', '0003', '0044.0003', 2, 1, NULL, '/eipsw/#/declareHome', NULL, 0, '0GD9FTDKA0X3K3Q8XB9N', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDXI7LHJNP3K3QTH2ZF', '20031604', '申报情况查询', '200316.20031604', '200316', '0004', '0044.0004', 2, 1, NULL, '/eipsw/#/declareCondition', NULL, 0, '0GD9FTDKA0X3K3Q8XB9N', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GDZZNTBT4Z3K3QUCD2M', '200318', '系统设置', '200318', '', '0047', '0047', 1, 1, 'yunweiguanli', '/', NULL, 0, '', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GE0OTWIPO63K3QJEWG4', '20031605', '形式审查', '200316.20031605', '200316', '0005', '0044.0005', 2, 1, NULL, '/eipsw/#/formReview', NULL, 0, '0GD9FTDKA0X3K3Q8XB9N', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GE9G8NOJTY3K3Q4WS6Z', '20031606', '专家审核', '200316.20031606', '200316', '0006', '0044.0006', 2, 1, NULL, '/eipsw/#/expertReview', NULL, 0, '0GD9FTDKA0X3K3Q8XB9N', '1', NULL, 'eipsw', 0, 0);
INSERT INTO `sys_function` VALUES ('0GE9P13Z9BS3K3QU64G7', '200319', '数据统计', '200319', '', '0045', '0045', 1, 1, 'tongjifenxi_m', '/eipsw/#/dataStatistics', NULL, 0, '', '1', NULL, 'eipsw', 1, 0);

-- ----------------------------
-- Table structure for sys_gridconfig
-- ----------------------------
DROP TABLE IF EXISTS `sys_gridconfig`;
CREATE TABLE IF NOT EXISTS `sys_gridconfig`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键Id',
  `USERCODE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '关联用户code',
  `GRIDNO` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表格编号',
  `CONFIG` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '配置值json',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `IDX_GRID_CODE_GRIDNO`(`GRIDNO`, `USERCODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '表格配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_gridconfig
-- ----------------------------
INSERT INTO `sys_gridconfig` VALUES ('0GC3EIIGDLNAV99LXQ5Q', 'liuy', 'smw..sysconfig/user.userTable', '{\"columns\":[{\"dataIndex\":\"userName\",\"show\":true},{\"dataIndex\":\"departmentName\",\"show\":true},{\"dataIndex\":\"roleNameJoin\",\"show\":true},{\"dataIndex\":\"userCode\",\"show\":true},{\"dataIndex\":\"adminCn\",\"show\":true},{\"dataIndex\":\"accountExpireTypeCn\",\"show\":true},{\"dataIndex\":\"lastLoginIp\",\"show\":true},{\"dataIndex\":\"lastLoginTime\",\"show\":true},{\"dataIndex\":\"remark\",\"show\":true},{\"dataIndex\":\"disableCn\",\"show\":true},{\"dataIndex\":\"accountIsLockedCn\",\"show\":true},{\"dataIndex\":\"onlineStatus\",\"show\":true}],\"pageSize\":30}');

-- ----------------------------
-- Table structure for sys_license
-- ----------------------------
DROP TABLE IF EXISTS `sys_license`;
CREATE TABLE IF NOT EXISTS `sys_license`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `VERSION` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '版本号',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统版本信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_license
-- ----------------------------
INSERT INTO `sys_license` VALUES ('0G194395VDWA5XHJ0MPF', '5.8.1');

-- ----------------------------
-- Table structure for sys_moduleconfig
-- ----------------------------
DROP TABLE IF EXISTS `sys_moduleconfig`;
CREATE TABLE IF NOT EXISTS `sys_moduleconfig`  (
  `MODULEID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `MODULETITLE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '首页模块标题',
  `STATUS` int(11) NULL DEFAULT NULL COMMENT '模块状态(0:禁用  1:启用)',
  `REFRESHFREQUENCY` int(11) NULL DEFAULT 0 COMMENT '刷新频率',
  `ISDEFAULT` int(11) NULL DEFAULT 0 COMMENT '是否默认看板',
  `APIADDRESS` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块对应接口地址',
  `MODULETYPE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模块类型，数据字典',
  `REMARK` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  PRIMARY KEY (`MODULEID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '首页模块配置表' ROW_FORMAT = Dynamic;


-- ----------------------------
-- Table structure for sys_oprlog
-- ----------------------------
DROP TABLE IF EXISTS `sys_oprlog`;
CREATE TABLE IF NOT EXISTS `sys_oprlog`  (
  `LOGID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '日志id',
  `USERCODE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户code',
  `USERNAME` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户名',
  `DEPARTMENTID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '部门Id',
  `HOSTIP` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主机ip',
  `FUNCTIONCODE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能代码',
  `FUNCTIONNAME` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能名称',
  `ACTIONCODE` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '动作代码',
  `ACTIONNAME` varchar(510) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '动作名称',
  `CREATEDTIME` datetime(0) NOT NULL COMMENT '创建时间',
  `CONTENT` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '操作内容',
  `REQUESTPARAM` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '请求参数',
  `RESPONSE` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '响应结果',
  `ELAPSEDMILLISECONDS` decimal(11, 0) NULL DEFAULT NULL COMMENT '操作耗时ms',
  PRIMARY KEY (`LOGID`, `CREATEDTIME`) USING BTREE,
  INDEX `IX_OPRLOG_CODE_TIME`(`USERCODE`, `CREATEDTIME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '操作日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_oprlog
-- ----------------------------

-- ----------------------------
-- Table structure for sys_role_rights
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_rights`;
CREATE TABLE IF NOT EXISTS `sys_role_rights`  (
  `ROLERIGHTSGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `ROLEGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色ID',
  `ACTIONCODE` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '动作代码',
  `FUNCTIONCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '功能代码',
  PRIMARY KEY (`ROLERIGHTSGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_rights
-- ----------------------------
INSERT INTO `sys_role_rights` VALUES ('0GBF5O8XD4O1XTU7ADCL', 'MANAGER', '00', '20030201');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEKA1XTUAOAXB', 'MANAGER', '00', '2003020101');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEKW1XTUMPWC6', 'MANAGER', '00', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEKY1XTUS9ZNU', 'MANAGER', '01', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEKZ1XTUGUFEX', 'MANAGER', '02', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEL11XTUPQ8LB', 'MANAGER', '00', '2003020103');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEL41XTU1AAD7', 'MANAGER', '00', '2003020104');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEL51XTUJNYAZ', 'MANAGER', '00', '2003030101');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEL71XTUXKSUP', 'MANAGER', '01', '2003030101');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEL81XTU6K5QS', 'MANAGER', '02', '2003030102');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELA1XTUVE6OC', 'MANAGER', '00', '2003030102');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELB1XTUAL2Z9', 'MANAGER', '00', '2003030103');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELD1XTUCGF8J', 'MANAGER', '00', '2003030104');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELE1XTUXI54J', 'MANAGER', '00', '2003030105');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELF1XTUDYFI5', 'MANAGER', '00', '2003030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELH1XTUBED72', 'MANAGER', '01', '2003030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELI1XTUVS272', 'MANAGER', '00', '2003030302');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELL1XTUVZ6CJ', 'MANAGER', '00', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELM1XTUWVFUG', 'MANAGER', '01', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELN1XTU9RFR0', 'MANAGER', '02', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELP1XTU0I92N', 'MANAGER', '03', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELQ1XTUCZR3P', 'MANAGER', '04', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELS1XTUL53PB', 'MANAGER', '01', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELT1XTUQ5SZY', 'MANAGER', '02', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELU1XTUPEBBO', 'MANAGER', '03', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTELV1XTUHA949', 'MANAGER', '04', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEM41XTUV3RLK', 'MANAGER', '00', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEM61XTU5T2ZI', 'MANAGER', '02', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEM71XTU9XYQX', 'MANAGER', '03', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEM81XTUNR06Q', 'MANAGER', '04', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMA1XTUNI46N', 'MANAGER', '00', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMB1XTU3SN5I', 'MANAGER', '01', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMC1XTU8HB7L', 'MANAGER', '03', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEME1XTUBXB9Q', 'MANAGER', '04', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMF1XTUFL668', 'MANAGER', '00', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMH1XTUUT4KB', 'MANAGER', '01', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMI1XTUW98GB', 'MANAGER', '02', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMJ1XTUZ09SF', 'MANAGER', '04', '20030401');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEML1XTUDDUJ6', 'MANAGER', '00', '20030401');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMM1XTUDU2MD', 'MANAGER', '01', '20030401');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMN1XTU70FQ5', 'MANAGER', '02', '20030401');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMO1XTU04W52', 'MANAGER', '03', '20030401');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMQ1XTUPXQCO', 'MANAGER', '00', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMR1XTUDO167', 'MANAGER', '01', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMS1XTUD3RSB', 'MANAGER', '02', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMU1XTUS56VR', 'MANAGER', '03', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GBHD6LTEMV1XTUM590U', 'MANAGER', '04', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GBHDTV03SJ1XTU6N63F', 'SERVICE_INSTITUTION', '00', '20030101');
INSERT INTO `sys_role_rights` VALUES ('0GBHDTV03SK1XTUZDD69', 'SERVICE_INSTITUTION', '01', '20030101');
INSERT INTO `sys_role_rights` VALUES ('0GBHDTV03SL1XTUWQGOQ', 'SERVICE_INSTITUTION', '02', '20030101');
INSERT INTO `sys_role_rights` VALUES ('0GBHFXLKLI51XTUKEWZ6', 'SERVICE_INSTITUTION', '00', '20030701');
INSERT INTO `sys_role_rights` VALUES ('0GBHGGJ28UU1XTUFN3K8', 'SERVICE_INSTITUTION', '00', '20030501');
INSERT INTO `sys_role_rights` VALUES ('0GBHH0HRP281XTUIAJUM', 'ENTERPRISE_USER', '00', '20030701');
INSERT INTO `sys_role_rights` VALUES ('0GBJB87Y4M71XTUS7JKH', 'SERVICE_INSTITUTION', '00', '20030502');
INSERT INTO `sys_role_rights` VALUES ('0GBKUO89S171XTUVM3W2', 'MANAGER', '00', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GBLKXRV3FK1XTU1XSCQ', 'SERVICE_INSTITUTION', '00', '20030503');
INSERT INTO `sys_role_rights` VALUES ('0GBLUFC84CA1XTUS6X1U', 'MANAGER', '00', '20030403');
INSERT INTO `sys_role_rights` VALUES ('0GBLUFC84CB1XTUF9MU8', 'MANAGER', '00', '2003040301');
INSERT INTO `sys_role_rights` VALUES ('0GBLWWA7OQB1XTUC4AQ2', 'MANAGER', '00', '20030801');
INSERT INTO `sys_role_rights` VALUES ('0GBSFL58KO31XTUOR61D', 'MANAGER', '00', '200308');
INSERT INTO `sys_role_rights` VALUES ('0GBSGP0Y4KC1XTU1WJ99', 'BANK_INSTITUTION', '00', '20030601');
INSERT INTO `sys_role_rights` VALUES ('0GBUDPK51CB1XTUL4778', 'BANK_INSTITUTION', '00', '20030602');
INSERT INTO `sys_role_rights` VALUES ('0GBUDPK51CD1XTUUKYT1', 'BANK_INSTITUTION', '02', '20030602');
INSERT INTO `sys_role_rights` VALUES ('0GBUEQON09D1XTUOBXXO', 'BANK_INSTITUTION', '02', '20031001');
INSERT INTO `sys_role_rights` VALUES ('0GBUEQON09F1XTUZKUYZ', 'BANK_INSTITUTION', '00', '20031001');
INSERT INTO `sys_role_rights` VALUES ('0GBYPV52OWD1XTUKVSH6', 'MANAGER', '00', '20031101');
INSERT INTO `sys_role_rights` VALUES ('0GBZ7C3ZBTE1XTURC7I6', 'BANK_INSTITUTION', '00', '20030901');
INSERT INTO `sys_role_rights` VALUES ('0GC35EQWPAFCWQ5XIPX0', 'ENTERPRISE_USER', '00', '20030901');
INSERT INTO `sys_role_rights` VALUES ('0GC35ZL8GT1CWQ5UCE01', 'ENTERPRISE_USER', '00', '20030902');
INSERT INTO `sys_role_rights` VALUES ('0GC362613LOCWQ5S7ICC', 'ENTERPRISE_USER', '00', '20030903');
INSERT INTO `sys_role_rights` VALUES ('0GC6TATNKIXCWQ59IZIK', 'BANK_INSTITUTION', '00', '20030902');
INSERT INTO `sys_role_rights` VALUES ('0GC6TATNKIZCWQ58P77I', 'BANK_INSTITUTION', '00', '20030903');
INSERT INTO `sys_role_rights` VALUES ('0GC8W0UW5DECWQ5P3OH4', 'MANAGER', '00', '2003110101');
INSERT INTO `sys_role_rights` VALUES ('0GCE69YH9X31XTUYAAWI', 'ENTERPRISE_USER', '00', '200312');
INSERT INTO `sys_role_rights` VALUES ('0GCGDWBID5J1XTUS2V3L', 'ENTERPRISE_USER', '00', '20031301');
INSERT INTO `sys_role_rights` VALUES ('0GCGDWBID5K1XTUG7C49', 'ENTERPRISE_USER', '02', '20031301');
INSERT INTO `sys_role_rights` VALUES ('0GCN2LDU9XI1XTUWCUK3', 'SERVICE_INSTITUTION', '00', '20031401');
INSERT INTO `sys_role_rights` VALUES ('0GCQDAE2FUI1XTUT7PTS', 'MANAGER', '00', '2003020105');
INSERT INTO `sys_role_rights` VALUES ('0GCQNJMM7JP1XTUOZ4Z3', 'ENTERPRISE_USER', '00', '20031302');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KO71XTUS95LP', 'MANAGER', '00', '20030404');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KO81XTU8ZT60', 'MANAGER', '01', '20030404');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KOA1XTU3NLXU', 'MANAGER', '02', '20030404');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KOC1XTUP2CK4', 'MANAGER', '03', '20030404');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KOD1XTUFKG4H', 'MANAGER', '04', '20030404');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KOF1XTUNYX8K', 'MANAGER', '00', '2003040401');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KOG1XTU2PQB1', 'MANAGER', '01', '2003040401');
INSERT INTO `sys_role_rights` VALUES ('0GCUQCC0KOI1XTULXF2W', 'MANAGER', '02', '2003040401');
INSERT INTO `sys_role_rights` VALUES ('0GCWAA2TGNL1XTUVA3HZ', 'MANAGER', '00', '2003040501');
INSERT INTO `sys_role_rights` VALUES ('0GCWAA2TGNM1XTUQKUP4', 'MANAGER', '01', '2003040501');
INSERT INTO `sys_role_rights` VALUES ('0GCWAA2TGNO1XTUJ5YKO', 'MANAGER', '02', '2003040501');
INSERT INTO `sys_role_rights` VALUES ('0GCWAA2TGNP1XTUZYZAG', 'MANAGER', '03', '2003040501');
INSERT INTO `sys_role_rights` VALUES ('0GCWAA2TGNQ1XTU9OOKU', 'MANAGER', '04', '2003040501');
INSERT INTO `sys_role_rights` VALUES ('0GCY3HYARXH1XTU3ABYC', 'MANAGER', '00', '20031102');
INSERT INTO `sys_role_rights` VALUES ('0GCY3MRNYQV1XTUMQ5K6', 'MANAGER', '00', '2003110201');
INSERT INTO `sys_role_rights` VALUES ('0GCY3QRFXIG1XTUMQVWT', 'MANAGER', '00', '20030406');
INSERT INTO `sys_role_rights` VALUES ('0GCY3SGKTZX1XTUCXOF4', 'MANAGER', '00', '2003040601');
INSERT INTO `sys_role_rights` VALUES ('0GD9FA6TWYM3K3QCHAR3', 'MANAGER', '00', '20031501');
INSERT INTO `sys_role_rights` VALUES ('0GD9FWBTOXX3K3QFBAGJ', 'MANAGER', '00', '20031601');
INSERT INTO `sys_role_rights` VALUES ('0GDA3X226O23K3Q9CC6T', 'MANAGER', '00', '20031502');
INSERT INTO `sys_role_rights` VALUES ('0GDAIYYW9ME3K3QYHJAJ', 'MANAGER', '00', '20031503');
INSERT INTO `sys_role_rights` VALUES ('0GDCLC0KT9U3K3QI2F70', 'MANAGER', '00', '2003150201');
INSERT INTO `sys_role_rights` VALUES ('0GDDTSQGZWH3K3QORH3K', 'MANAGER', '00', '20031701');
INSERT INTO `sys_role_rights` VALUES ('0GDDTSQGZWJ3K3QOYE8F', 'MANAGER', '00', '2003170101');
INSERT INTO `sys_role_rights` VALUES ('0GDDTSQGZWK3K3QR5VDL', 'MANAGER', '00', '2003170102');
INSERT INTO `sys_role_rights` VALUES ('0GDHUPFRQCR3K3QMMP21', 'MANAGER', '00', '20031702');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0C3K3QHAD0W', 'DEMO_USER', '00', '20030201');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0M3K3QXWRJW', 'DEMO_USER', '00', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0O3K3QHVNIL', 'DEMO_USER', '04', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0P3K3QIBU2M', 'DEMO_USER', '00', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0Q3K3Q2EPLW', 'DEMO_USER', '04', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0V3K3Q3WDPQ', 'DEMO_USER', '00', '2003020101');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0X3K3Q9H503', 'DEMO_USER', '00', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA0Y3K3QJOZMM', 'DEMO_USER', '00', '2003020103');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA103K3QFQCLO', 'DEMO_USER', '00', '2003020104');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA123K3QZIK64', 'DEMO_USER', '00', '2003020105');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1A3K3Q5ONTG', 'DEMO_USER', '00', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1B3K3QLLZCY', 'DEMO_USER', '04', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1D3K3Q9I1KN', 'DEMO_USER', '00', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1E3K3Q38K12', 'DEMO_USER', '04', '20030302');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1F3K3QVFHMF', 'DEMO_USER', '00', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1H3K3QBFASL', 'DEMO_USER', '04', '20030303');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1I3K3QKUE4R', 'DEMO_USER', '00', '2003030103');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1J3K3QYJEYR', 'DEMO_USER', '00', '2003030104');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1L3K3QXFACO', 'DEMO_USER', '00', '2003030105');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1M3K3Q2SLVR', 'DEMO_USER', '00', '2003030301');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1N3K3QWW3G7', 'DEMO_USER', '00', '2003030302');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1R3K3QKZ885', 'DEMO_USER', '00', '20030403');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1T3K3QWCCUN', 'DEMO_USER', '00', '2003040301');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1U3K3QO0MBP', 'DEMO_USER', '00', '20030406');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA1V3K3Q5KUJQ', 'DEMO_USER', '00', '2003040601');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA223K3QL8LTO', 'DEMO_USER', '00', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA233K3QZS0AB', 'DEMO_USER', '04', '20030402');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA253K3QUZH9H', 'DEMO_USER', '00', '20031103');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2B3K3Q5CJ90', 'DEMO_USER', '00', '20031101');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2C3K3QXOCQH', 'DEMO_USER', '00', '2003110101');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2E3K3QRPZWP', 'DEMO_USER', '00', '20031102');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2F3K3QMJ857', 'DEMO_USER', '00', '2003110201');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2G3K3QB4OE1', 'DEMO_USER', '00', '20031501');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2H3K3QX65HY', 'DEMO_USER', '00', '20031502');
INSERT INTO `sys_role_rights` VALUES ('0GDI59ALA2K3K3QKOVPF', 'DEMO_USER', '00', '200308');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTSO3K3QTV74E', 'MANAGER', '01', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTSP3K3QM4GEY', 'MANAGER', '02', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTTJ3K3QPA8FY', 'MANAGER', '03', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTTN3K3Q1S9WU', 'MANAGER', '04', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTTP3K3QHU15K', 'MANAGER', '05', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTTQ3K3QBXS0P', 'MANAGER', '06', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTTR3K3QUSSRX', 'MANAGER', '07', '20030202');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTTZ3K3QTYNFV', 'MANAGER', '07', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTU23K3QOC4AJ', 'MANAGER', '05', '2003020101');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTU83K3Q0M35Y', 'MANAGER', '03', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTUP3K3QJNIK7', 'MANAGER', '05', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTUQ3K3QMGIH6', 'MANAGER', '06', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTUR3K3QGOYAS', 'MANAGER', '07', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTXV3K3QFKALL', 'MANAGER', '01', '20031101');
INSERT INTO `sys_role_rights` VALUES ('0GDI7KEOTXX3K3QU54MF', 'MANAGER', '02', '20031101');
INSERT INTO `sys_role_rights` VALUES ('0GDI96M17FL3K3Q7YL56', 'DEMO_USER', '01', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GDI96M17FP3K3QD3ROY', 'DEMO_USER', '02', '20030203');
INSERT INTO `sys_role_rights` VALUES ('0GDI99JRLU23K3QYSPO6', 'DEMO_USER', '07', '20030301');
INSERT INTO `sys_role_rights` VALUES ('0GDIAWV97LH3K3QK60MM', 'DEMO_USER', '04', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GDJ640HXVR3K3QUIO9B', 'MANAGER', '04', '2003020102');
INSERT INTO `sys_role_rights` VALUES ('0GDPKOC03973K3QTDF55', 'MANAGER', '01', '20031701');
INSERT INTO `sys_role_rights` VALUES ('0GDPN62CNG23K3Q8ODDU', 'MANAGER', '01', '20030403');
INSERT INTO `sys_role_rights` VALUES ('0GDPO2Z65BQ3K3QRRS3Z', 'MANAGER', '01', '20031502');
INSERT INTO `sys_role_rights` VALUES ('0GDPO2Z65BR3K3QKXU64', 'MANAGER', '06', '20031502');
INSERT INTO `sys_role_rights` VALUES ('0GDPO6TFSOA3K3QZFIDV', 'MANAGER', '07', '20031502');
INSERT INTO `sys_role_rights` VALUES ('0GDPUL46A423K3Q1WRX0', 'MANAGER', '04', '2003030103');
INSERT INTO `sys_role_rights` VALUES ('0GDPUL46A463K3QFRPT8', 'MANAGER', '05', '2003030103');
INSERT INTO `sys_role_rights` VALUES ('0GDPUV6YRI63K3QJ3PS5', 'MANAGER', '00', '20031602');
INSERT INTO `sys_role_rights` VALUES ('0GDQ1T3A7ZZ3K3QAURWU', 'MANAGER', '00', '20031103');
INSERT INTO `sys_role_rights` VALUES ('0GDS7XADO093K3QBL9YB', 'MANAGER', '00', '20031703');
INSERT INTO `sys_role_rights` VALUES ('0GDXI8BRQGP3K3QV613G', 'ENTERPRISE_USER', '00', '20031603');
INSERT INTO `sys_role_rights` VALUES ('0GDXI8BRQGR3K3Q5W9HI', 'ENTERPRISE_USER', '00', '20031604');
INSERT INTO `sys_role_rights` VALUES ('0GE0L6BUWVR3K3QKRGMM', 'DEMO_USER', '00', '200318');
INSERT INTO `sys_role_rights` VALUES ('0GE0OUAOEAV3K3Q5UJD8', 'MANAGER', '00', '20031605');
INSERT INTO `sys_role_rights` VALUES ('0GE9G8UN5S33K3QP2MFV', 'MANAGER', '00', '20031606');
INSERT INTO `sys_role_rights` VALUES ('0GE9P1FEW3Z3K3QSI5Y7', 'MANAGER', '00', '200319');


-- ----------------------------
-- Table structure for sys_role_thirdapp_rights
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_thirdapp_rights`;
CREATE TABLE IF NOT EXISTS `sys_role_thirdapp_rights`  (
  `ROLERIGHTSGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `ROLEGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色ID',
  `APPNO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '应用编号',
  PRIMARY KEY (`ROLERIGHTSGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色第三方应用权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_thirdapp_rights
-- ----------------------------

-- ----------------------------
-- Table structure for sys_roles
-- ----------------------------
DROP TABLE IF EXISTS `sys_roles`;
CREATE TABLE IF NOT EXISTS `sys_roles`  (
  `ROLEGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色GUID',
  `ROLENAME` varchar(400) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色名称',
  `ORDERCODE` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '排序代码',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注信息',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`ROLEGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_roles
-- ----------------------------
INSERT INTO `sys_roles` VALUES ('BANK_INSTITUTION', '银行机构', '003', '银行机构', 'admin', '2022-06-07 11:18:40', NULL, NULL);
INSERT INTO `sys_roles` VALUES ('DEMO_USER', '演示用户', '005', '演示用户', 'liuy', '2022-09-07 19:38:34', 'liuy', '2022-09-13 18:22:16');
INSERT INTO `sys_roles` VALUES ('ENTERPRISE_USER', '企业用户', '002', '企业用户', 'admin', '2022-06-07 11:18:28', NULL, NULL);
INSERT INTO `sys_roles` VALUES ('MANAGER', '管理员', '001', '管理员', 'admin', '2022-06-07 11:17:05', NULL, NULL);
INSERT INTO `sys_roles` VALUES ('SERVICE_INSTITUTION', '服务机构', '004', '服务机构', 'admin', '2022-06-07 11:18:48', NULL, NULL);

-- ----------------------------
-- Table structure for sys_roles_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_roles_user`;
CREATE TABLE IF NOT EXISTS `sys_roles_user`  (
  `ROLEUSERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色成员GUID',
  `ROLEGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色GUID',
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户GUID',
  PRIMARY KEY (`ROLEUSERGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色用户关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_roles_user
-- ----------------------------
INSERT INTO `sys_roles_user` VALUES ('0GBF5OQ9ZDT1XTUNGNO3', 'MANAGER', '0GBEY0N5FJM1XTUA9COH');
INSERT INTO `sys_roles_user` VALUES ('0GBHCFKYRTP1XTUWL78V', 'SERVICE_INSTITUTION', '0GBHCFKY5201XTUBJ8T6');
INSERT INTO `sys_roles_user` VALUES ('0GBKFBN3WGX1XTU43R49', 'SERVICE_INSTITUTION', '0GBKFBN3ANT1XTUICB2G');
INSERT INTO `sys_roles_user` VALUES ('0GBKFC70MT61XTUANW9Z', 'SERVICE_INSTITUTION', '0GBKFC700NE1XTU8YMQF');
INSERT INTO `sys_roles_user` VALUES ('0GBLOIHYFXK1XTUIF2K4', 'SERVICE_INSTITUTION', '0GBLOIHXVLV1XTUOR7XN');
INSERT INTO `sys_roles_user` VALUES ('0GBLOJCIXZX1XTUOMOOT', 'SERVICE_INSTITUTION', '0GBLOJCIDZ11XTUYWC7M');
INSERT INTO `sys_roles_user` VALUES ('0GBLUK0MRC71XTUGH7HH', 'MANAGER', '0GBLQLJKPY01XTUYA07Z');
INSERT INTO `sys_roles_user` VALUES ('0GBOVJRVGRH1XTU551LZ', 'BANK_INSTITUTION', '0GBOVJRUXBI1XTUGGWDQ');
INSERT INTO `sys_roles_user` VALUES ('0GBSK60DVNF1XTUCZHC3', 'ENTERPRISE_USER', '0GBSK60DANM1XTUSHHZ3');
INSERT INTO `sys_roles_user` VALUES ('0GBURT9LDVA1XTUGAYUE', 'BANK_INSTITUTION', '0GBURT9KSET1XTUEGY6L');
INSERT INTO `sys_roles_user` VALUES ('0GBZ4TPXOTC1XTU2M8MM', 'BANK_INSTITUTION', '0GBZ4TPX4G81XTUVN72U');
INSERT INTO `sys_roles_user` VALUES ('0GBZ4V1VTWQ1XTUUA74U', 'BANK_INSTITUTION', '0GBZ4V1V9MZ1XTUN660B');
INSERT INTO `sys_roles_user` VALUES ('0GBZ6F7XDNL1XTUDG7H2', 'BANK_INSTITUTION', '0GBZ6F7WU1U1XTUFWORO');
INSERT INTO `sys_roles_user` VALUES ('0GC23WC9IYF1XTU7VYDU', 'BANK_INSTITUTION', '0GC23WC91KD1XTUXM4PQ');
INSERT INTO `sys_roles_user` VALUES ('0GC34YX548I1XTUIS4YP', 'BANK_INSTITUTION', '0GC34YX413X1XTUI8VU8');
INSERT INTO `sys_roles_user` VALUES ('0GC34Z9X5XU1XTUM7M9F', 'BANK_INSTITUTION', '0GC34Z9WLDG1XTUEJL4A');
INSERT INTO `sys_roles_user` VALUES ('0GC34ZI22XO1XTU83P46', 'BANK_INSTITUTION', '0GC34ZI1NM11XTU3WY7Q');
INSERT INTO `sys_roles_user` VALUES ('0GC350U30NY1XTUZG01J', 'BANK_INSTITUTION', '0GC350U2HVI1XTUXTX63');
INSERT INTO `sys_roles_user` VALUES ('0GC351D5XAE1XTUT8ZSM', 'BANK_INSTITUTION', '0GC351D5D3A1XTUL3R7L');
INSERT INTO `sys_roles_user` VALUES ('0GC38GICSP11XTU4H1KU', 'SERVICE_INSTITUTION', '0GC38GIC8BW1XTUE69SQ');
INSERT INTO `sys_roles_user` VALUES ('0GC3GFZMPMU1XTUWG0FM', 'BANK_INSTITUTION', '0GC3GFZM5121XTU0UXB2');
INSERT INTO `sys_roles_user` VALUES ('0GC6FJ2R5751XTU14SFP', 'MANAGER', '0GC6FABNDWD1XTUO69DI');
INSERT INTO `sys_roles_user` VALUES ('0GCA78LVF861XTUAX6J4', 'MANAGER', '7E3F958BF9884D61BCE47A16638FB4FD');
INSERT INTO `sys_roles_user` VALUES ('0GCEDPPCWGW1XTU9L8KM', 'BANK_INSTITUTION', '0GCEDPPCHBE1XTUJ4O3A');
INSERT INTO `sys_roles_user` VALUES ('0GCFLOXBG4M1XTUU87K5', 'ENTERPRISE_USER', '0GCFLOXAWQJ1XTUWJE6R');
INSERT INTO `sys_roles_user` VALUES ('0GCGLPFLP6K1XTUWZYJG', 'SERVICE_INSTITUTION', '0GCGLPFL4PU1XTUAE8NY');
INSERT INTO `sys_roles_user` VALUES ('0GCGP03WC5P1XTUVFOTG', 'SERVICE_INSTITUTION', '0GCGP03VREE1XTUPUQMA');
INSERT INTO `sys_roles_user` VALUES ('0GCHJARHZHE1XTU20MEF', 'SERVICE_INSTITUTION', '0GCHJARHEIJ1XTU91ZIU');
INSERT INTO `sys_roles_user` VALUES ('0GCHJD5MEHF1XTUC274E', 'ENTERPRISE_USER', '0GCHJD5LIZ01XTUHBBD2');
INSERT INTO `sys_roles_user` VALUES ('0GCHJXJLDDE1XTUZRYQT', 'ENTERPRISE_USER', '0GCHJWZ94HY1XTUY4ESC');
INSERT INTO `sys_roles_user` VALUES ('0GCHP9V6YV11XTUIVUKM', 'SERVICE_INSTITUTION', '0GCHP9V6F5I1XTUBX9MF');
INSERT INTO `sys_roles_user` VALUES ('0GCHQ1LS8BI1XTU80SZ7', 'ENTERPRISE_USER', '0GBHCEQ43SV1XTUOOBR5');
INSERT INTO `sys_roles_user` VALUES ('0GCHSGVJ7QZ1XTU3XNL0', 'ENTERPRISE_USER', '0GBEY0N5FJM1XTUA9COH');
INSERT INTO `sys_roles_user` VALUES ('0GCHSGVJ8801XTUENHB3', 'BANK_INSTITUTION', '0GBEY0N5FJM1XTUA9COH');
INSERT INTO `sys_roles_user` VALUES ('0GCHSGVJ8IL1XTUJJYQQ', 'SERVICE_INSTITUTION', '0GBEY0N5FJM1XTUA9COH');
INSERT INTO `sys_roles_user` VALUES ('0GCMCWJEA7M1XTU6H2MM', 'SERVICE_INSTITUTION', '0GCMCWJDDGH1XTUHHMKQ');
INSERT INTO `sys_roles_user` VALUES ('0GCO3AETJZO1XTUIBCW9', 'ENTERPRISE_USER', '0GCO3AET5PF1XTU3H4OL');
INSERT INTO `sys_roles_user` VALUES ('0GCO5ZMUY1N1XTUARTKO', 'ENTERPRISE_USER', '0GCO5ZMUEXC1XTU5OI24');
INSERT INTO `sys_roles_user` VALUES ('0GCO6FW0L2A1XTU2R808', 'SERVICE_INSTITUTION', '0GCO5ZMUEXC1XTU5OI24');
INSERT INTO `sys_roles_user` VALUES ('0GCO810DUPG1XTU5DI9R', 'SERVICE_INSTITUTION', '0GCHJD5LIZ01XTUHBBD2');
INSERT INTO `sys_roles_user` VALUES ('0GCP9KPJOYC1XTU4MPT0', 'SERVICE_INSTITUTION', '0GCO3AET5PF1XTU3H4OL');
INSERT INTO `sys_roles_user` VALUES ('0GCTO0RWXPG1XTUZK3JO', 'BANK_INSTITUTION', '0GCTO0RWENJ1XTUVZ7OA');
INSERT INTO `sys_roles_user` VALUES ('0GCTO8VTCW01XTUV924F', 'BANK_INSTITUTION', '0GCTO8VSTLX1XTU7Q8G5');
INSERT INTO `sys_roles_user` VALUES ('0GCU0M6DBHO1XTUKQYC9', 'SERVICE_INSTITUTION', '0GCFLOXAWQJ1XTUWJE6R');
INSERT INTO `sys_roles_user` VALUES ('0GCV40C8ELY1XTUCBGUM', 'SERVICE_INSTITUTION', '0GBHCEQ43SV1XTUOOBR5');
INSERT INTO `sys_roles_user` VALUES ('0GCZ60GWFPR1XTUNLQRI', 'MANAGER', '0GCZ60GVUZV1XTUU5Y17');
INSERT INTO `sys_roles_user` VALUES ('0GDBPAL00UZ3K3QUBSL3', 'DEMO_USER', '0GDBPA5X4733K3QPLENP');
INSERT INTO `sys_roles_user` VALUES ('0GDL4IS8NUM3K3QHLPVC', 'SERVICE_INSTITUTION', '0GDL4IS84A53K3Q4U8DW');
INSERT INTO `sys_roles_user` VALUES ('0GDT54BGRRR3K3Q6MPCJ', 'BANK_INSTITUTION', '0GDT54BG0T13K3QEKLA9');
INSERT INTO `sys_roles_user` VALUES ('0GDT54PFPQT3K3QKEPDZ', 'BANK_INSTITUTION', '0GDT54PF6XM3K3QWOOH2');
INSERT INTO `sys_roles_user` VALUES ('0GE0TT45ORI3K3Q1X30M', 'ENTERPRISE_USER', '0GE0TT455D33K3QXTTG1');

-- ----------------------------
-- Table structure for sys_staff
-- ----------------------------
DROP TABLE IF EXISTS `sys_staff`;
CREATE TABLE IF NOT EXISTS `sys_staff`  (
  `STAFFID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '人员Id',
  `STAFFNAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '人员姓名',
  `STAFFTYPE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人员类型',
  `GENDER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '性别',
  `BIRTHDAY` datetime(0) NULL DEFAULT NULL COMMENT '出生日期',
  `IDENTITYCARD` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证号码',
  `WEIXINNO` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '微信号',
  `JOBNUMBER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工号',
  `OFFICEPHONE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司电话',
  `MOBILEPHONE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '移动电话',
  `EMAIL` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `EDUCATION` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '学历',
  `WORKYEAR` decimal(3, 0) NULL DEFAULT NULL COMMENT '工作年限',
  `HOMEADDRESS` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '家庭住址',
  `DUTY` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务',
  `USERCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关联系统账户Code',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改日期',
  PRIMARY KEY (`STAFFID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '人员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_staff
-- ----------------------------

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE IF NOT EXISTS `sys_user`  (
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户GUID',
  `USERCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户代码',
  `USERNAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户昵称',
  `PASSWORD` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `DEPARTMENTID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '部门Id',
  `ISADMIN` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否超级用户 0：否 1：是',
  `ISDISABELD` decimal(1, 0) NULL DEFAULT 0 COMMENT '账户是否禁用 0：否 1：是',
  `DISABLEDREASON` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '账户禁用原因',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改日期',
  `PSWMODIFYTIME` datetime(0) NULL DEFAULT NULL COMMENT '密码修改时间',
  `ISUSERCHANGEPWD` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否用户自己更改密码 0:否 1:是',
  `PWDERRORCOUNT` decimal(5, 0) NULL DEFAULT 0 COMMENT '密码错误次数 默认为0',
  `ACCOUNTISLOCKED` decimal(1, 0) NULL DEFAULT 0 COMMENT '是否锁定 0:否 1:是',
  `ACCOUNTLOCKSTARTTIME` datetime(0) NULL DEFAULT NULL COMMENT '账号开始锁定时间',
  `LOCKMINUTE` decimal(10, 0) NULL DEFAULT NULL COMMENT '账号锁定时长 单位分钟',
  `LOCKREASON` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '账户锁定原因',
  `LASTLOGINIP` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户最后登录ip',
  `LASTLOGINTIME` datetime(0) NULL DEFAULT NULL COMMENT '用户最后登录时间',
  `ACCOUNTEXPIRETYPE` decimal(1, 0) NULL DEFAULT 1 COMMENT '账号有效期类型(0:临时有效 1:永久有效)',
  `CARDNO` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证号码',
  `TELPHONE` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '鎵嬫満鍙风爜',
  `POLICENO` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '璀﹀彿',
  PRIMARY KEY (`USERGUID`) USING BTREE,
  INDEX `INX_USER_CODE`(`USERCODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

INSERT INTO `sys_user` VALUES ('7E3F958BF9884D61BCE47A16638FB4FD', 'admin', '系统管理员', 'AQAAAAEAACcQAAAAELbx70YT52eejLTd1wKKnO4nQkmr0aQErY6y7wQ8KzrXrNOqKaGpSnBDMcXZMhw70A==', '5B3D8D8AD0BB8CE0E0530D01360B4F70', 0, 0, NULL, NULL, NULL, '2015-11-23 17:42:24', 'liuy', '2022-09-13 17:05:16', '2022-08-22 10:55:52', 0, 0, 0, NULL, NULL, '登录时，锁定时间已过期自动解锁', '172.17.0.8', '2022-10-08 15:58:00', 1, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for sys_user_finger
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_finger`;
CREATE TABLE IF NOT EXISTS `sys_user_finger`  (
  `FINGERID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '指纹Id',
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户Id',
  `FINGERFEATUREDATA` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户指纹特征base64字符串',
  PRIMARY KEY (`FINGERID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户指纹' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_finger
-- ----------------------------

-- ----------------------------
-- Table structure for sys_user_iplimit
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_iplimit`;
CREATE TABLE IF NOT EXISTS `sys_user_iplimit`  (
  `LIMITIPGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '限制规则Id',
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户GUID',
  `IP` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '起始IP',
  `ENDIP` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '结束IP 范围匹配时采用',
  `CHECKTYPE` decimal(10, 0) NOT NULL DEFAULT 0 COMMENT '类别 0：精确匹配或者模糊匹配 1：范围匹配 ',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`LIMITIPGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户登录IP限制规则表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_iplimit
-- ----------------------------

-- ----------------------------
-- Table structure for sys_user_register
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_register`;
CREATE TABLE IF NOT EXISTS `sys_user_register`  (
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户GUID',
  `USERCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户代码',
  `USERNAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户昵称',
  `PASSWORD` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `DEPARTMENTID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '部门Id',
  `APPROVESTATUS` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '审核状态',
  `APPROVEDESC` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '驳回理由',
  `ROLEGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户角色ID',
  `REMARK` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `CREATOR` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '创建日期',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NULL DEFAULT NULL COMMENT '修改日期',
  `CARDNO` longtext CHARACTER SET utf16 COLLATE utf16_general_ci NULL COMMENT '身份证号码',
  `TELPHONE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `POLICENO` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '警号',
  `COMPANYNAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位名称',
  PRIMARY KEY (`USERGUID`) USING BTREE,
  INDEX `INX_USER_CODE`(`USERCODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户注册表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_register
-- ----------------------------

-- ----------------------------
-- Table structure for sys_user_rights
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_rights`;
CREATE TABLE IF NOT EXISTS `sys_user_rights`  (
  `USERRIGHTSGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户权限Id',
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户GUID',
  `ACTIONCODE` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '动作代码',
  `FUNCTIONCODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '应用系统',
  `ACTIONTYPE` decimal(8, 0) NULL DEFAULT 1 COMMENT '权限动作类型(0：拒绝， 1：允许)， 默认 1 允许。',
  PRIMARY KEY (`USERRIGHTSGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_rights
-- ----------------------------

-- ----------------------------
-- Table structure for sys_userpwd_history
-- ----------------------------
DROP TABLE IF EXISTS `sys_userpwd_history`;
CREATE TABLE IF NOT EXISTS `sys_userpwd_history`  (
  `HISTORYID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id-主键',
  `USERGUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户GUID',
  `PASSWORD` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `MODIFIER` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime(0) NOT NULL COMMENT '修改时间',
  PRIMARY KEY (`HISTORYID`) USING BTREE,
  INDEX `IX_USERPWD_HISRTORY_UID`(`USERGUID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户密码历史表' ROW_FORMAT = Dynamic;


-- ----------------------------
-- Table structure for systeminfo
-- ----------------------------
DROP TABLE IF EXISTS `systeminfo`;
CREATE TABLE IF NOT EXISTS `systeminfo`  (
  `ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `SYSTEMICON` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '系统图标',
  `COMPANYNAME` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `ISUSED` int(11) NULL DEFAULT NULL COMMENT '是否使用：1:使用 0:未使用',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统版权信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of systeminfo
-- ----------------------------
INSERT INTO `systeminfo` VALUES ('0G19YIAQWJ01XTU58PXJ', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAACWCAYAAAA8AXHiAAASV0lEQVR4nO2dCZQVxRWG77DIyMiigBKNyiKgaBCBAGriLhhCMCYalSAJgpqICiqaKAloNIIKQQiIUXGJikuCgsYoiLuoo8YlsgiGoxEVQRaRzRkYJqf075y2TlV3ddeteu+N9Z3D0XnvdXX1e7dv37pbUSAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQsKRMd/iYa26vi99tGyI6koi6EdHBRNSWiPYkon5E9ATTOXYloklE1IqIXiWiSiJ6hYjWMo1fVPzh8iHK6TSoixcr0YuIfoJ/+2k+cyMRHUhE1Zbnqk9EjxDR4fi7X+y9d4noOSJ6hoieJqKPLM9V1NRVwdqJiH5JRBdAYNIQAjeYiG61PO8vYkIl0wH/huJ1ocluI6J7iGiz5XmLjnp17YKI6EdEtISI/mIoVBG/Yfg+RmX4bC/M8T9E9Ksks6QUqUuCVUFEdxDRw0TULsfxQmv1tTj/94nogBzHtSai6UQ0n4h2szh/UVFXBOvbRPQCHkU2DLU4doTluY8houdxLSVPXRCstjCIuzKM1Z+ImuU47iAi+inD+TsT0UsJi4ySodQFqyURzSWi9kzjNZJWcqYMYDo/QWPNwyOyZCllwRJL+/uw0uKkf46xjmeeQ1vYio2Yx/VGKQvWpUR0rINxT4DQmlKR4GKw4btENM7BuF4oVcESj76xjsYWK7PDMnxeePIbOprLSCLq6Whsp5SqYI1z/JjIYme50FYRwrd1ncPxnVGKgtWRiE52fI4sguVaowiN2MPxOdgpRcH6tQcvdRdDf1I9T4+qwR7OwUqpCZaY72mezmXihe9ERE09zIXTneGFUhOsrh79OyaPn24e5iHYl4j293QuFkpNsLKs1mz5jsHxHN5+U3wJMQulJlhZshVs6WJgyx3scT55AtwFw6dgdTTUAkn4DNA2QcZpEj411u6Wxx9BRCcyzSUVX4K1H7IPFlgKVxPGOZmQpCW+hfRjX7S0OE9nxFRnE9EZPubrQ7DEnfY4foQmuLg8GQSFICkO6VNbUcYwU5xGyFItx2s3E1F3/ul9HdeCJS5qjpR9IJLwZuQcbz3TvEzpmPA5n/aVYFPO466VbgIhYA+61rauBesWIuqteF3kLp2fYzzflS5JS3zfgpXnpjpRk4C4DzJD8mrBVFwK1vkpz/OJObzWvitb9kl4z3YhkpWVGT8v5p5UwycyVse7mqwrwTqEiCakfEZkBNyPOjxT3nM0Xx17J7y3l+e5fJDhs6bf7SjLPH8tLgSrMS5qJ4PPtkEBhGns79+Wc8uKsBFbKI4Rdkpzz3NZnOGz4zQmiIo7XNhbLgRrbMaszgHIOzJhIRFtdzDnJFS+M99pwzUZBOsHRHRxhrHFtUzLOS8t3IJ1SMaLihiPY9OoznjncqDyH9k6K7Miqqi/MDhmd2igrJxCRMdxTphbsCblXGmIx+ZMPEbTqOSdciqq7IUsdiEH/zIYowzGel6hH8+ZjsQpWCcgKS0vYmn/J4Nj5zHO2QSVM9e3YD1t8JnhOSuMIrqjvwULnIJ1FcMY5xjEs54koh0M5zKlGARrfsr7Bxmswk24gktrcQlWT8b02RloLaRjPdoD+UJV9u5TsN4iov8mvC9WqPcy1QAIAT2aYRw2wTqXaRzC8v7OlDtnNuP50thX8b5PV8NDKe9PgEBwcSbHOByCJQzunzGME+e4lF4IM5nPl4TK++5TsJKutR9sK05O5NB+HILVh4h2Zr20rxiXEKsTXugXHZxTRSEfhQvgalDRgqGfl4pdOEraOATrGIYxVJTDJ6NzX/jSWioXyB6ezp3kk5qGnDAXWKeAcwiWaeggD73QEE2FyDHa4vDcEarQlI8Ev61E9IDmPWF6nOrw3Na/KYdgdWYYI4mxGuP0M6R+FAKbbE5ThEb+XPHZqFGbS6yTGG0FqyWaYrhEaIy7Nf0RXH/BOlz1aogzWfP6rR46/+1pe422gqWK/LtAJNWNVoz7WgFCPGSYuWGDcIi+rTheNOz9oeNzE1w9VoUrtoLlYjWoYzRKsmQ4PM5ZcX3dNyhea20Y8uLCqnDFVrBUNoArGsArL68SHypAAqBLRMfnxxTjT/Ps8V9jc7CtYH1ieXxWeqB3e5waz3eya65TxEJP5gwQG1Bl+9vaCpZY7n9sOUZWrlYUks5wKOQ++6+vgBsljrBjp3qcg2CpbaCfw93wMsMYWWiMxvtxtjpsUOazBlLYi9uk1yZ6dMhGWP+mHIL1D4YxstJHUQF0S4lvhLQK1xDnWIbe9Xl4ynYALsHymR8VMUnygG9ytEL04d0n5EJtjf3dqEB+umpUrlvBIViforLWN8L2uF4651QHWst2RzAT3lBoq8sctBo3YRYRbbAdhCsfqxC+JMJj4nuxv4XW+jPzOTYyj6diOFa3EaK0/7cezqtiCscgXIIlvN//ZBorK9Ok7fEmI47IhWuNdT+2OYkzvUCbB8zlWoxx5ryfZ1iixE0XqQ/EZ0z59xEuNVat2KRUeu3nDlORkhCr0Yu4BuMULOH9/j3jeFm4UspNmop9AF3BVTT7gFQn2aSAZsUYzppN7rrCiQVyP8g/iHh8XeLwfFw7ol4t/T2mQJszzUK7Iza4BUuo9oHIOvDNQOkRIgouni3APEy5Hy0DIvZn2PMwDzORNFjLOWiSYO2PIPOcjO2GNiLJ/02G+WVlsmTIX8j9hYEao0/pqYY7Ic5kT3lecR7G5gRZrqcn3EtrkmpAkwTrNDxiBmDVd2cGNS18W0cZFFpyIzJNz4qN+UbOXgZp2GZ1TJEyMk5CNMEn89CzwVSo2iCOWYn5tkjaIjlJsGQtNRgG8RjDrNEN6Hxyjdev66tVVrw8a7SDlZ2NA/FjaSVYXoDsjLkQDhNXSnPEYd+BuRFHVXP5JUmCpepYV4EVmBCwYdJjR8V2/LCDFcFVV7SE8EesxJzzour9aeMnu1AS9BEGbb85mY4s1LRQ1U6Y23IshFR+NW3HwyTBSioYaI0QxJuGO5LeBbuL03GZxHlSY9opSKDLg0rbrc451nyp8kZ0hrnc+mrN2IIb/NyUx18Z8r+WIJM1Kb9e2/EwSbDKE96LEDtFPIJoeFqL5/nYNVSVy81NQymOuC1nM13SaKxPc4xTrWhFcIWnTZ7egWlzV8rnDkch8N+S7KcYuTRWFo5Go467k567eIT2dmRQywyQ3A+iS83fc4yj0lh5At0TpKpmUTZ3do5xsjITN/SihOM6wJf1QsaaQq024/RjlSEcsRTaQtffQKjkIUR0uoec+UnSNV6UIw1GNces8xYtAf4ovTbBZTtszHEQfhNdj/iWCNovzpn6rLWxXfQgbYRuvMthqOpKpe5DWZfLHgxdpJXMCsUPnIbKLswqWBdKAn0cVsyueA7XLqc5RzRChfly2KNpizAdWps5SbBs42G7YRkt7oYfaz7zPjYPuoLB6ajjKkm4r88YE1MJURb3xVwpX62MO3wSowqO16M1PbXK4Lt6B60hbe27D3VvJAmW9qCMtEeJ1jOaBrY1cAf0dBQKaoPtfiO2ZbRtbB6FVdAIcU5xtPdgJUrjx2syekWF0/NYlXK5N3IJ1gqmk0cciSatt2k69r0Ow3GEA4fm76UCzAUZ9vNRaW5TwbpSyrJokONRnMZWPGoPgyaSERXNf8XiinvH/VyC9TrzJAiqWBjuy4jod4qK4hr4nDozd+1roch2uNTQbaCKNZoI1kJFCswwbLHHxRNwZN+g0FKRM3uZw63ktKlJSYIlZzVyUgHbZylWLXLt3ocIOZzE+Ei+SIp1rjNMbFOFb9JCOrUQoni0oTE653DwCWK5fWCAx6mHHg/LEIFw2Q5Am2iQJFhPeNgFYm/4vl7SNPuajSyL8QwpwhXQknHuhn8riSrFe2kaa4qiWckFDLlWO5DE2AlpNzJH4JF3e0qDYA5qk/rPJwnWOoMvnYtesHvuUxiWm7HSOYghr/5shbf4rJTEPZXdsi7hphMrXbkzzi5wwdjwPKIb5ysEuy0cnM963JR8QVJ/hzQ/Vt4NK/NyKmJUYxUq/F0ET/sr1L8pDRWxufcS4nVbEvYJ1H2pouuwLKgjLVo+fQhn8pGKR08FskeWeO7tILgp6c00wXrIweowjXL4tXTe4EcRoxydM0X4TIXWmopwhkxSxxVVIPpmxS4SzXNqq61Ir+kETR5fRJTB8bsM2tx3Rc8KzaP4/6QJ1nYHy2NT2kC9z1N0T67CndoBWjVLJbZKa4njhyrsqaTtcldJf6/Q5NmPzNj/oRax1A7Q3HIIqjtugns82FE6JqbZ3yYhnRkJLaF9cDwyIiYoPMUrsfrqCg+3KSqttUxRZZRkpMva7BzF55tn2DKPkCXSDS4ZeTfZlkhVepWjq7EFK0xK/00Ea7vkuS4EDbBd3VLkFMnuibexSVRfw7QcldYihKDi26msSxgj3jbpTk2zNFNt9Sbmf6zCjqqPdJtluIl8tlVScZnJCt00CP0kPOaFpjV+xAWa1c88aK9hBrbhUIWzsgbaInokJjlQo/dWabSSibZaDlupm0bjHoowl+9ufjoeSwhsf40s2Q0joDGKgegLv0mR6boDj+8OCHXohKOBxiZaFNNmSSbApzjXIE2UP0lbfYJ+DQdggyXZu78H7KwXOVpjM7ECN50RWQRrE1JWfTTJMKEMds0y+Kfka6lCqKMdbCeVt3yIJgtyEmw61Uox4l5oGlUl0m4ar/4GrGZFYP5GRR1APQjc0gL1xdLxEZIm5QWLlqz5WAuxK0Ih+mHp2BUd/hYgv0tmEyqO2yJdJd6DqqEmZbkW2iyp4HUztnxTMUwKeldBUNthNatKNuwBb/1Uz10E0/gIpXyZWhbkSfR7HMLlo29UFnojxDBJ00p6PVoDtUdxaNTA5AwHBvE5sf+/F+6SSzSLgWYQpkrGPR+5WIMFReY+GHkzSGchAKrzSheK+rBtluCxrWIlPtMGDsjNhoUDpgjN2BSLjK4wzt/XHDsQIaPhjrJ5bViJx18uu9rmYp7FF+e7ua0Je6HS5JGESpJVcEC2T9nBNCvCyG2FDAPdo7IdVoH3FKgJSBqLkLuVu6LK9i75ABH1yyTbpVjoj9DQyJTCBc4sjqSxopXowgKU1JuwDV71nrabMnCo321IazlQs3QuNBWwu14u8NK9B5yv13neKsaUl1GAMYqjoS9347WBSG+ZztEglZke8H1da1iMy8UuEOzKIvJJxXkJefi61OZc5C37SWIxQhAXo6y+L6pG2hdBOKI+UpL3VjS4cEEDFJGkVYn7ogYrvFfw7zGLFKREXAhWxFasHmfh78ZYdkd7HLr01exICSD78sM1QCJhIf1SG2D3rY5FC5zjUrBktjgq0ChmvkCPrm8cxeY7CdQRfGos1zTFjVKBUE05bIooHrcdcc5CLSqaYjUorwg3Yp6+Wjx5waVg7axImS3Hv2Z4f1ekl0T/jUrhK2L9OMtiNko9/EDNkEO+B5yRWRYFjxr29OKiHIUQJuGaHRC0aoRTVkPgIuGrkvyFNVJSwEZEEtbj2PXS8Zs8VF59Cadg9UI5VasiC6LGeRT1eD75Akl8D8KZnES92HfXCmk1LvkcGn0t/p3OFYXgtLEqEQQuRqGqQneVASl57K5Yi7jbWIfNT/LQFJq/I1aMbKEtbuN9eJacHU9UIp1GtSWuT2oQ9O6d0gStEFRxb7jALVhrkZNeDGGdqJf64UWU+Urw/ndHXlax5LWNQsIkGy7cDfMUGw/55i0EUscX2aMnogqZpL2KQHvNQU49K678WFdx7NKZg2qcu1dCykox8RrSm6/0tVqTeB2hLfYnjCvBqkGWqbZphAOeQ5B3jKaRR7FSjcrvrrgGXyyH28XJ1sQuPe8b0WfT9Z46q1GAepRFL/diYBGuYZBUs+iC5TjXSlcncB3SifbUcfFYrIIN1QFte4otDywPtcgq7YTiCxePx4Xwp3H1HVPiI1a4ASqXq4FtLZpkHIBVn+uW3oXgcyz/D2ZuJfU49tD+2PU1+QpCRw1sj7Bc1s6BsXu6bepsibAYrbv7WtqrG9Bkt5+vWKnv7IYXkcI8JEOi/naEQw5FW+9C7INYaOZhd4mTMvbFF87qcagcmubTXChEdsN2lI/fgTTmPnAYtovtZrEGmm0Buvi5NmZLgVq0zpyNhraDkE7cAYHuxljIvIdow1No9+lr17VAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBALfRIjof8DZfq2niuSkAAAAAElFTkSuQmCC', '华为技术有限公司', 1);
INSERT INTO `systeminfo` VALUES ('0G19Z842Z941XTUAQ8QD', 'data:image/png;base64,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', '武汉中科通达高新技术股份有限公司', 0);

SET FOREIGN_KEY_CHECKS = 1;

-- citms_smw_31.sys_das_field definition

CREATE TABLE `sys_das_field` (
  `FIELDID` varchar(50) NOT NULL COMMENT '字段id',
  `FIELD` varchar(100) NOT NULL COMMENT '字段',
  `FIELDNAME` varchar(300) NOT NULL COMMENT '字段中文',
  `PLATFORMCODE` varchar(100) NOT NULL COMMENT '厂商编号',
  `DICTTYPEKIND` varchar(10) DEFAULT NULL COMMENT '数据字典类型kind',
  `CREATOR` varchar(100) DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(100) DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`FIELDID`) USING BTREE,
  KEY `IX_DAS_FIELD_NAME` (`FIELDNAME`,`FIELD`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='数据接入字段';

-- citms_smw_31.sys_das_fieldmapping definition

CREATE TABLE `sys_das_fieldmapping` (
  `MAPPINGID` varchar(50) NOT NULL COMMENT '字段映射',
  `FIELDID` varchar(50) NOT NULL COMMENT '字段id',
  `CODEREMARK` varchar(300) DEFAULT NULL COMMENT '编号描述',
  `CUSTOMCODE` varchar(100) NOT NULL COMMENT '厂商自定义编号',
  `BZCODE` varchar(100) NOT NULL COMMENT '中科标准编号',
  PRIMARY KEY (`MAPPINGID`) USING BTREE,
  KEY `IX_DAS_MP_FIELDID` (`FIELDID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='数据接入字段字典映射关系';

-- citms_smw_31.sys_das_fieldrange definition

CREATE TABLE `sys_das_fieldrange` (
  `DETAILID` varchar(50) NOT NULL COMMENT '明细id',
  `FIELDID` varchar(50) NOT NULL COMMENT '字段id',
  `APPLYRANGE` varchar(100) NOT NULL COMMENT '应用范围,对应字典1102',
  PRIMARY KEY (`DETAILID`) USING BTREE,
  KEY `IX_DAS_CODE_RANGE` (`APPLYRANGE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='数据接入字段应用范围';

-- citms_smw_31.sys_das_platform definition

CREATE TABLE `sys_das_platform` (
  `PLATFORMID` varchar(50) NOT NULL COMMENT '厂商id',
  `PLATFORMNAME` varchar(400) NOT NULL COMMENT '厂商名称',
  `PLATFORMCODE` varchar(100) NOT NULL COMMENT '厂商编号',
  `SIGNATURE` varchar(100) NOT NULL COMMENT '签名标记',
  `DISABLED` decimal(1,0) NOT NULL DEFAULT '0' COMMENT '是否禁用',
  `REMARK` varchar(1000) DEFAULT NULL COMMENT '备注',
  `CREATOR` varchar(100) DEFAULT NULL COMMENT '创建人',
  `CREATEDTIME` datetime DEFAULT NULL COMMENT '创建时间',
  `MODIFIER` varchar(100) DEFAULT NULL COMMENT '修改人',
  `MODIFIEDTIME` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`PLATFORMID`) USING BTREE,
  KEY `IX_PF_CODE` (`PLATFORMCODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='数据接入厂商信息';
