SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE IF NOT EXISTS `citms_cbsdw`.`ref_org_enterprise_recommend`  (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `org_enterprise_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '银行机构统一社会信用代码',
  `enterprise_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '企业统一社会信用代码',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_org_enterprise_code`(`org_enterprise_code`, `enterprise_code`) USING BTREE COMMENT '银行机构企业code联合索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '银行机构推荐企业记录表' ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS `citms_cbsdw`.`tbl_financial_org`  (
  `id` int(12) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `org_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '金融机构名称',
  `enterprise_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '社会同一信用代码',
  `org_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '机构介绍',
  `business_license` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '营业执照url',
  `status` tinyint(2) NOT NULL DEFAULT 0 COMMENT '状态启用状态 0 启用 1禁用  默认 0',
  `org_logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构logo url',
  `contact_man` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人',
  `contact_details` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系方式',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `is_deleted` tinyint(3) NULL DEFAULT 0 COMMENT '逻辑删除 0 否 1是',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_entepriseCode`(`enterprise_code`) USING BTREE COMMENT '统一社会信用代码索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '金融机构表' ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS `citms_cbsdw`.`tbl_financial_product`  (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `org_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '金融机构名称',
  `org_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '金融机构id',
  `org_enterprise_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行机构的社会同一信用代码',
  `product_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '金融产品名称',
  `is_quota_calc` tinyint(1) NOT NULL DEFAULT 1 COMMENT '是否开启额度测算 0 否 1是',
  `is_points_loan` tinyint(2) NOT NULL COMMENT '是否积分贷 0 否 1是',
  `product_tag` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '金融产品标签',
  `start_loan_quota` decimal(16, 2) NULL DEFAULT NULL COMMENT '起始贷款额度（万元）',
  `end_loan_quota` decimal(16, 2) NULL DEFAULT NULL COMMENT '结束贷款额度（万元）',
  `start_reference_rate` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '起始参考利率（%）',
  `start_loan_term` int(2) NULL DEFAULT NULL COMMENT '起始贷款期限（月）',
  `end_loan_term` int(2) NULL DEFAULT NULL COMMENT '结束贷款期限（月）',
  `introduce` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产品介绍',
  `applicable_customer` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '适用客户',
  `apply_condition` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请条件',
  `apply_illustrate` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '申请说明',
  `image_introduce` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片介绍',
  `qr_code` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产品二维码',
  `is_publish` tinyint(1) NULL DEFAULT 0 COMMENT '是否发布 0 否 1 是',
  `is_deleted` tinyint(2) NOT NULL DEFAULT 0 COMMENT '是否删除 0否 1是（默认0）',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '金融产品表' ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS `citms_cbsdw`.`tbl_financial_product_order`  (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `financial_product_id` bigint(64) NOT NULL COMMENT '金融产品id',
  `org_enterprise_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '银行机构的社会同一信用代码',
  `enterprise_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '企业社会同一信用代码',
  `enterprise_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '企业名称',
  `org_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '银行机构名称',
  `product_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '金融产品名称',
  `order_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单编号',
  `order_status` tinyint(3) NOT NULL COMMENT '订单状态 0 等待测算 10 测算完成 20 测算未通过 30 申请贷款 40 贷款成功 50 贷款失败 60 已取消',
  `image_introduce` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片介绍',
  `start_loan_quota` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '起始贷款额度（万元）',
  `end_loan_quota` decimal(16, 2) NULL DEFAULT NULL COMMENT '结束贷款额度（万元）',
  `credit_quota` decimal(16, 2) NULL DEFAULT NULL COMMENT '预授信额度（万元）',
  `start_reference_rate` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '起始参考利率（%）',
  `credit_rate` decimal(5, 2) NULL DEFAULT NULL COMMENT '预授信利率（%）',
  `start_loan_term` int(5) NULL DEFAULT NULL COMMENT '起始贷款期限（月）',
  `end_loan_term` int(5) NULL DEFAULT NULL COMMENT '结束贷款期限（月）',
  `credit_term` int(5) NULL DEFAULT NULL COMMENT '预授信期限（月）',
  `contact_man` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '额度测算企业联系人',
  `contact_details` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '额度测算企业联系方式',
  `apply_loan_quota` decimal(16, 2) NULL DEFAULT NULL COMMENT '申请贷款额度（万元）',
  `is_deleted` tinyint(2) NOT NULL DEFAULT 0 COMMENT '是否删除 0否 1是（默认0）',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `update_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_org_enterprise_code`(`org_enterprise_code`) USING BTREE COMMENT '银行机构企业code索引',
  INDEX `index_enterprise_code`(`enterprise_code`) USING BTREE COMMENT '企业code索引',
  INDEX `index_financial_product_id`(`financial_product_id`) USING BTREE COMMENT '金融产品索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '金融产品订单表' ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS `citms_cbsdw`.`tbl_financial_product_order_link`  (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` bigint(64) NOT NULL COMMENT '订单id',
  `type` tinyint(3) NULL DEFAULT NULL COMMENT '订单链路类型 0 额度测算 10 预授信额度 20 预授信额度未通过 30 申请贷款 40 已批复 50 未批复 60 取消订单',
  `org_enterprise_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '机构或企业名称',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '相关备注信息（图片、过程描述等等）',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `create_user` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_order_id`(`order_id`) USING BTREE COMMENT '订单id关联索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '订单链路记录表' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS=1;